/*
 * Decompiled with CFR 0.152.
 */
package cdm.security.lending.functions;

import cdm.event.common.BusinessEvent;
import cdm.event.workflow.EventInstruction;
import cdm.event.workflow.Workflow;
import cdm.event.workflow.WorkflowStep;
import cdm.security.lending.functions.RunReturnSettlementWorkflowInput;
import cdm.security.lending.functions.SettlementFunctionHelper;
import cdm.security.lending.functions.WorkflowFunctionHelper;
import com.regnosys.rosetta.common.testing.ExecutableFunction;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;

public class RunReturnSettlementWorkflow
implements ExecutableFunction<RunReturnSettlementWorkflowInput, Workflow> {
    @Inject
    SettlementFunctionHelper settlements;
    @Inject
    WorkflowFunctionHelper workflows;

    public Workflow execute(RunReturnSettlementWorkflowInput input) {
        LocalDate returnDate = input.getReturnDate().toLocalDate();
        BusinessEvent returnBusinessEvent = this.settlements.createReturn(input.getTradeState(), input.getReturnInstruction(), input.getReturnDate());
        WorkflowStep returnWorkflowStep = this.workflows.createWorkflowStep(returnBusinessEvent, WorkflowFunctionHelper.dateTime(returnDate, 9, 0));
        LocalDate settlementDate = returnDate.plus(1L, ChronoUnit.DAYS);
        EventInstruction transferInstruction = this.settlements.createReturnTransferInstruction(returnWorkflowStep.getBusinessEvent(), input.getReturnInstruction().getQuantity(), settlementDate);
        WorkflowStep proposedTransferWorkflowStep = this.workflows.createProposedWorkflowStep(returnWorkflowStep, transferInstruction, WorkflowFunctionHelper.dateTime(returnDate, 15, 0));
        BusinessEvent transferBusinessEvent = this.settlements.createTransferBusinessEvent(transferInstruction);
        WorkflowStep acceptedTransferWorkflowStep = this.workflows.createAcceptedWorkflowStep(proposedTransferWorkflowStep, transferBusinessEvent, WorkflowFunctionHelper.dateTime(settlementDate, 18, 0));
        return Workflow.builder().addSteps(returnWorkflowStep).addSteps(proposedTransferWorkflowStep).addSteps(acceptedTransferWorkflowStep).build();
    }

    public Class<RunReturnSettlementWorkflowInput> getInputType() {
        return RunReturnSettlementWorkflowInput.class;
    }

    public Class<Workflow> getOutputType() {
        return Workflow.class;
    }
}

