/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.NonTransferableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="NonTransferableProductPrimaryAssetClass")
@ImplementedBy(value=Default.class)
public interface NonTransferableProductPrimaryAssetClass
extends Validator<NonTransferableProduct> {
    public static final String NAME = "NonTransferableProductPrimaryAssetClass";
    public static final String DEFINITION = "if economicTerms -> nonStandardisedTerms = True then taxonomy -> primaryAssetClass exists";

    public static class NoOp
    implements NonTransferableProductPrimaryAssetClass {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, NonTransferableProduct nonTransferableProduct) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements NonTransferableProductPrimaryAssetClass {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, NonTransferableProduct nonTransferableProduct) {
            ComparisonResult result = this.executeDataRule(nonTransferableProduct);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)NonTransferableProductPrimaryAssetClass.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"NonTransferableProduct", (RosettaPath)path, (String)NonTransferableProductPrimaryAssetClass.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)NonTransferableProductPrimaryAssetClass.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"NonTransferableProduct", (RosettaPath)path, (String)NonTransferableProductPrimaryAssetClass.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(NonTransferableProduct nonTransferableProduct) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)nonTransferableProduct).map("getEconomicTerms", _nonTransferableProduct -> _nonTransferableProduct.getEconomicTerms()).map("getNonStandardisedTerms", economicTerms -> economicTerms.getNonStandardisedTerms()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)nonTransferableProduct).mapC("getTaxonomy", _nonTransferableProduct -> _nonTransferableProduct.getTaxonomy()).map("getPrimaryAssetClass", productTaxonomy -> productTaxonomy.getPrimaryAssetClass()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

