/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.functions;

import cdm.base.datetime.AdjustableOrAdjustedOrRelativeDate;
import cdm.base.math.NonNegativeQuantity;
import cdm.base.math.UnitType;
import cdm.base.staticdata.asset.common.Asset;
import cdm.base.staticdata.asset.common.AssetIdTypeEnum;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.Cash;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.common.settlement.Cashflow;
import cdm.product.common.settlement.CashflowType;
import cdm.product.common.settlement.ScheduledTransferEnum;
import cdm.product.template.SettlementPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=Create_CashflowFromSettlementPayoutDefault.class)
public abstract class Create_CashflowFromSettlementPayout
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends Cashflow> evaluate(SettlementPayout payout) {
        List cashflows;
        this.conditionValidator.validate(() -> ExpressionOperators.exists((Mapper)MapperS.of((Object)payout).map("getUnderlier", settlementPayout -> settlementPayout.getUnderlier()).map("getObservable", underlier -> underlier.getObservable()).map("Type coercion", referenceWithMetaObservable -> referenceWithMetaObservable == null ? null : referenceWithMetaObservable.getValue()).map("getAsset", observable -> observable.getAsset())), "Restricts the function's applicability to a single asset for the underlier.");
        this.conditionValidator.validate(() -> ExpressionOperators.exists((Mapper)MapperS.of((Object)payout).map("getSettlementTerms", settlementPayout -> settlementPayout.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getAdjustableOrRelativeDate", settlementDate -> settlementDate.getAdjustableOrRelativeDate())), "Restricts the function's applicability to the adjustable or relative date for the settlement date.");
        this.conditionValidator.validate(() -> {
            ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule = (ReferenceWithMetaPriceSchedule)MapperS.of((Object)payout).map("getPriceQuantity", settlementPayout -> settlementPayout.getPriceQuantity()).mapC("getPriceSchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getPriceSchedule()).get();
            return ExpressionOperators.exists((Mapper)MapperS.of((Object)payout).map("getPriceQuantity", settlementPayout -> settlementPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue())).and(ExpressionOperators.exists((Mapper)(referenceWithMetaPriceSchedule == null ? MapperS.ofNull() : MapperS.of((Object)referenceWithMetaPriceSchedule.getValue())).map("getValue", priceSchedule -> priceSchedule.getValue())));
        }, "Restricts the function's applicability to a single quantity and price.");
        List<Cashflow.CashflowBuilder> cashflowsBuilder = this.doEvaluate(payout);
        if (cashflowsBuilder == null) {
            cashflows = null;
        } else {
            cashflows = cashflowsBuilder.stream().map(Cashflow::build).collect(Collectors.toList());
            this.objectValidator.validate(Cashflow.class, cashflows);
        }
        return cashflows;
    }

    protected abstract List<Cashflow.CashflowBuilder> doEvaluate(SettlementPayout var1);

    protected abstract MapperS<? extends Cashflow> assetLeg(SettlementPayout var1);

    protected abstract MapperS<BigDecimal> priceLegAmount(SettlementPayout var1);

    protected abstract MapperS<? extends FieldWithMetaString> priceLegCurrency(SettlementPayout var1);

    protected abstract MapperS<? extends PayerReceiver> priceLegPayerReceiver(SettlementPayout var1);

    protected abstract MapperS<? extends Cashflow> priceLeg(SettlementPayout var1);

    public static class Create_CashflowFromSettlementPayoutDefault
    extends Create_CashflowFromSettlementPayout {
        @Override
        protected List<Cashflow.CashflowBuilder> doEvaluate(SettlementPayout payout) {
            ArrayList<Cashflow.CashflowBuilder> cashflows = new ArrayList<Cashflow.CashflowBuilder>();
            return this.assignOutput(cashflows, payout);
        }

        protected List<Cashflow.CashflowBuilder> assignOutput(List<Cashflow.CashflowBuilder> cashflows, SettlementPayout payout) {
            cashflows = this.toBuilder(MapperC.of((MapperBuilder[])new MapperBuilder[]{this.assetLeg(payout), this.priceLeg(payout)}).getMulti());
            return Optional.ofNullable(cashflows).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends Cashflow> assetLeg(SettlementPayout payout) {
            return MapperS.of((Object)Cashflow.builder().setQuantity(NonNegativeQuantity.builder().setValue((BigDecimal)MapperS.of((Object)payout).map("getPriceQuantity", settlementPayout -> settlementPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get()).setUnit((UnitType)MapperS.of((Object)payout).map("getPriceQuantity", settlementPayout -> settlementPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).get()).build()).setAsset((Asset)MapperS.of((Object)payout).map("getUnderlier", settlementPayout -> settlementPayout.getUnderlier()).map("getObservable", underlier -> underlier.getObservable()).map("Type coercion", referenceWithMetaObservable -> referenceWithMetaObservable == null ? null : referenceWithMetaObservable.getValue()).map("getAsset", observable -> observable.getAsset()).get()).setSettlementDate((AdjustableOrAdjustedOrRelativeDate)MapperS.of((Object)payout).map("getSettlementTerms", settlementPayout -> settlementPayout.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getAdjustableOrRelativeDate", settlementDate -> settlementDate.getAdjustableOrRelativeDate()).get()).setPayerReceiver((PayerReceiver)MapperS.of((Object)payout).map("getPayerReceiver", settlementPayout -> settlementPayout.getPayerReceiver()).get()).setCashflowType(CashflowType.builder().setCashflowType(ScheduledTransferEnum.PRINCIPAL_PAYMENT).build()).build());
        }

        @Override
        protected MapperS<BigDecimal> priceLegAmount(SettlementPayout payout) {
            ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule = (ReferenceWithMetaPriceSchedule)MapperS.of((Object)payout).map("getPriceQuantity", settlementPayout -> settlementPayout.getPriceQuantity()).mapC("getPriceSchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getPriceSchedule()).get();
            return MapperMaths.multiply((Mapper)MapperS.of((Object)payout).map("getPriceQuantity", settlementPayout -> settlementPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), (Mapper)(referenceWithMetaPriceSchedule == null ? MapperS.ofNull() : MapperS.of((Object)referenceWithMetaPriceSchedule.getValue())).map("getValue", priceSchedule -> priceSchedule.getValue()));
        }

        @Override
        protected MapperS<? extends FieldWithMetaString> priceLegCurrency(SettlementPayout payout) {
            ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule = (ReferenceWithMetaPriceSchedule)MapperS.of((Object)payout).map("getPriceQuantity", settlementPayout -> settlementPayout.getPriceQuantity()).mapC("getPriceSchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getPriceSchedule()).get();
            return (referenceWithMetaPriceSchedule == null ? MapperS.ofNull() : MapperS.of((Object)referenceWithMetaPriceSchedule.getValue())).map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency());
        }

        @Override
        protected MapperS<? extends PayerReceiver> priceLegPayerReceiver(SettlementPayout payout) {
            return MapperS.of((Object)PayerReceiver.builder().setPayer((CounterpartyRoleEnum)((Object)MapperS.of((Object)payout).map("getPayerReceiver", settlementPayout -> settlementPayout.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get())).setReceiver((CounterpartyRoleEnum)((Object)MapperS.of((Object)payout).map("getPayerReceiver", settlementPayout -> settlementPayout.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer()).get())).build());
        }

        @Override
        protected MapperS<? extends Cashflow> priceLeg(SettlementPayout payout) {
            AssetIdentifier assetIdentifier = AssetIdentifier.builder().setIdentifier((FieldWithMetaString)this.priceLegCurrency(payout).get()).setIdentifierType(AssetIdTypeEnum.CURRENCY_CODE).build();
            return MapperS.of((Object)Cashflow.builder().setQuantity(NonNegativeQuantity.builder().setValue((BigDecimal)this.priceLegAmount(payout).get()).setUnit(UnitType.builder().setCurrency((FieldWithMetaString)this.priceLegCurrency(payout).get()).build()).build()).setAsset(Asset.builder().setCash(Cash.builder().setIdentifier(assetIdentifier == null ? Collections.emptyList() : Collections.singletonList(assetIdentifier)).build()).build()).setSettlementDate((AdjustableOrAdjustedOrRelativeDate)MapperS.of((Object)payout).map("getSettlementTerms", settlementPayout -> settlementPayout.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getAdjustableOrRelativeDate", settlementDate -> settlementDate.getAdjustableOrRelativeDate()).get()).setPayerReceiver((PayerReceiver)this.priceLegPayerReceiver(payout).get()).setCashflowType(CashflowType.builder().setCashflowType(ScheduledTransferEnum.PRINCIPAL_PAYMENT).build()).build());
        }
    }
}

