/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.datetime.BusinessCenterTime;
import cdm.observable.asset.FxRate;
import cdm.observable.asset.FxSpotRateSource;
import cdm.product.template.meta.QuantoMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Quanto", builder=QuantoBuilderImpl.class, version="6.10.0")
@RuneDataType(value="Quanto", model="cdm", builder=QuantoBuilderImpl.class, version="6.10.0")
public interface Quanto
extends RosettaModelObject {
    public static final QuantoMeta metaData = new QuantoMeta();

    public List<? extends FxRate> getFxRate();

    public FxSpotRateSource getFxSpotRateSource();

    public BusinessCenterTime getFixingTime();

    public Quanto build();

    public QuantoBuilder toBuilder();

    public static QuantoBuilder builder() {
        return new QuantoBuilderImpl();
    }

    default public RosettaMetaData<? extends Quanto> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Quanto> getType() {
        return Quanto.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("fxRate"), processor, FxRate.class, this.getFxRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxSpotRateSource"), processor, FxSpotRateSource.class, this.getFxSpotRateSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixingTime"), processor, BusinessCenterTime.class, this.getFixingTime(), new AttributeMeta[0]);
    }

    public static class QuantoBuilderImpl
    implements QuantoBuilder {
        protected List<FxRate.FxRateBuilder> fxRate = new ArrayList<FxRate.FxRateBuilder>();
        protected FxSpotRateSource.FxSpotRateSourceBuilder fxSpotRateSource;
        protected BusinessCenterTime.BusinessCenterTimeBuilder fixingTime;

        @Override
        @RosettaAttribute(value="fxRate")
        @RuneAttribute(value="fxRate")
        public List<? extends FxRate.FxRateBuilder> getFxRate() {
            return this.fxRate;
        }

        @Override
        public FxRate.FxRateBuilder getOrCreateFxRate(int index) {
            if (this.fxRate == null) {
                this.fxRate = new ArrayList<FxRate.FxRateBuilder>();
            }
            return (FxRate.FxRateBuilder)this.getIndex(this.fxRate, index, () -> {
                FxRate.FxRateBuilder newFxRate = FxRate.builder();
                return newFxRate;
            });
        }

        @Override
        @RosettaAttribute(value="fxSpotRateSource")
        @RuneAttribute(value="fxSpotRateSource")
        public FxSpotRateSource.FxSpotRateSourceBuilder getFxSpotRateSource() {
            return this.fxSpotRateSource;
        }

        @Override
        public FxSpotRateSource.FxSpotRateSourceBuilder getOrCreateFxSpotRateSource() {
            FxSpotRateSource.FxSpotRateSourceBuilder result = this.fxSpotRateSource != null ? this.fxSpotRateSource : (this.fxSpotRateSource = FxSpotRateSource.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixingTime")
        @RuneAttribute(value="fixingTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getFixingTime() {
            return this.fixingTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateFixingTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.fixingTime != null ? this.fixingTime : (this.fixingTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxRate")
        @RuneAttribute(value="fxRate")
        public QuantoBuilder addFxRate(FxRate _fxRate) {
            if (_fxRate != null) {
                this.fxRate.add(_fxRate.toBuilder());
            }
            return this;
        }

        @Override
        public QuantoBuilder addFxRate(FxRate _fxRate, int idx) {
            this.getIndex(this.fxRate, idx, () -> _fxRate.toBuilder());
            return this;
        }

        @Override
        public QuantoBuilder addFxRate(List<? extends FxRate> fxRates) {
            if (fxRates != null) {
                for (FxRate fxRate : fxRates) {
                    this.fxRate.add(fxRate.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fxRate")
        public QuantoBuilder setFxRate(List<? extends FxRate> fxRates) {
            this.fxRate = fxRates == null ? new ArrayList<FxRate.FxRateBuilder>() : (List)fxRates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="fxSpotRateSource")
        @RuneAttribute(value="fxSpotRateSource")
        public QuantoBuilder setFxSpotRateSource(FxSpotRateSource _fxSpotRateSource) {
            this.fxSpotRateSource = _fxSpotRateSource == null ? null : _fxSpotRateSource.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingTime")
        @RuneAttribute(value="fixingTime")
        public QuantoBuilder setFixingTime(BusinessCenterTime _fixingTime) {
            this.fixingTime = _fixingTime == null ? null : _fixingTime.toBuilder();
            return this;
        }

        @Override
        public Quanto build() {
            return new QuantoImpl(this);
        }

        @Override
        public QuantoBuilder toBuilder() {
            return this;
        }

        @Override
        public QuantoBuilder prune() {
            this.fxRate = this.fxRate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.fxSpotRateSource != null && !this.fxSpotRateSource.prune().hasData()) {
                this.fxSpotRateSource = null;
            }
            if (this.fixingTime != null && !this.fixingTime.prune().hasData()) {
                this.fixingTime = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFxRate() != null && this.getFxRate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getFxSpotRateSource() != null && this.getFxSpotRateSource().hasData()) {
                return true;
            }
            return this.getFixingTime() != null && this.getFixingTime().hasData();
        }

        public QuantoBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            QuantoBuilder o = (QuantoBuilder)other;
            merger.mergeRosetta(this.getFxRate(), o.getFxRate(), this::getOrCreateFxRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxSpotRateSource(), (RosettaModelObjectBuilder)o.getFxSpotRateSource(), this::setFxSpotRateSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixingTime(), (RosettaModelObjectBuilder)o.getFixingTime(), this::setFixingTime);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Quanto _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.fxRate, _that.getFxRate())) {
                return false;
            }
            if (!Objects.equals(this.fxSpotRateSource, _that.getFxSpotRateSource())) {
                return false;
            }
            return Objects.equals(this.fixingTime, _that.getFixingTime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fxRate != null ? this.fxRate.hashCode() : 0);
            _result = 31 * _result + (this.fxSpotRateSource != null ? this.fxSpotRateSource.hashCode() : 0);
            _result = 31 * _result + (this.fixingTime != null ? this.fixingTime.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "QuantoBuilder {fxRate=" + this.fxRate + ", fxSpotRateSource=" + this.fxSpotRateSource + ", fixingTime=" + this.fixingTime + '}';
        }
    }

    public static interface QuantoBuilder
    extends Quanto,
    RosettaModelObjectBuilder {
        public FxRate.FxRateBuilder getOrCreateFxRate(int var1);

        public List<? extends FxRate.FxRateBuilder> getFxRate();

        public FxSpotRateSource.FxSpotRateSourceBuilder getOrCreateFxSpotRateSource();

        @Override
        public FxSpotRateSource.FxSpotRateSourceBuilder getFxSpotRateSource();

        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateFixingTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getFixingTime();

        public QuantoBuilder addFxRate(FxRate var1);

        public QuantoBuilder addFxRate(FxRate var1, int var2);

        public QuantoBuilder addFxRate(List<? extends FxRate> var1);

        public QuantoBuilder setFxRate(List<? extends FxRate> var1);

        public QuantoBuilder setFxSpotRateSource(FxSpotRateSource var1);

        public QuantoBuilder setFixingTime(BusinessCenterTime var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("fxRate"), processor, FxRate.FxRateBuilder.class, this.getFxRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxSpotRateSource"), processor, FxSpotRateSource.FxSpotRateSourceBuilder.class, this.getFxSpotRateSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixingTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getFixingTime(), new AttributeMeta[0]);
        }

        public QuantoBuilder prune();
    }

    public static class QuantoImpl
    implements Quanto {
        private final List<? extends FxRate> fxRate;
        private final FxSpotRateSource fxSpotRateSource;
        private final BusinessCenterTime fixingTime;

        protected QuantoImpl(QuantoBuilder builder) {
            this.fxRate = Optional.ofNullable(builder.getFxRate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.fxSpotRateSource = Optional.ofNullable(builder.getFxSpotRateSource()).map(f -> f.build()).orElse(null);
            this.fixingTime = Optional.ofNullable(builder.getFixingTime()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="fxRate")
        @RuneAttribute(value="fxRate")
        public List<? extends FxRate> getFxRate() {
            return this.fxRate;
        }

        @Override
        @RosettaAttribute(value="fxSpotRateSource")
        @RuneAttribute(value="fxSpotRateSource")
        public FxSpotRateSource getFxSpotRateSource() {
            return this.fxSpotRateSource;
        }

        @Override
        @RosettaAttribute(value="fixingTime")
        @RuneAttribute(value="fixingTime")
        public BusinessCenterTime getFixingTime() {
            return this.fixingTime;
        }

        @Override
        public Quanto build() {
            return this;
        }

        @Override
        public QuantoBuilder toBuilder() {
            QuantoBuilder builder = Quanto.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(QuantoBuilder builder) {
            Optional.ofNullable(this.getFxRate()).ifPresent(builder::setFxRate);
            Optional.ofNullable(this.getFxSpotRateSource()).ifPresent(builder::setFxSpotRateSource);
            Optional.ofNullable(this.getFixingTime()).ifPresent(builder::setFixingTime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Quanto _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.fxRate, _that.getFxRate())) {
                return false;
            }
            if (!Objects.equals(this.fxSpotRateSource, _that.getFxSpotRateSource())) {
                return false;
            }
            return Objects.equals(this.fixingTime, _that.getFixingTime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fxRate != null ? this.fxRate.hashCode() : 0);
            _result = 31 * _result + (this.fxSpotRateSource != null ? this.fxSpotRateSource.hashCode() : 0);
            _result = 31 * _result + (this.fixingTime != null ? this.fixingTime.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Quanto {fxRate=" + this.fxRate + ", fxSpotRateSource=" + this.fxSpotRateSource + ", fixingTime=" + this.fixingTime + '}';
        }
    }
}

