/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.common.schedule.PaymentDates;
import cdm.product.common.settlement.FixedPrice;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.meta.FixedPricePayoutMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FixedPricePayout", builder=FixedPricePayoutBuilderImpl.class, version="6.10.0")
@RuneDataType(value="FixedPricePayout", model="cdm", builder=FixedPricePayoutBuilderImpl.class, version="6.10.0")
public interface FixedPricePayout
extends PayoutBase {
    public static final FixedPricePayoutMeta metaData = new FixedPricePayoutMeta();

    public PaymentDates getPaymentDates();

    public FixedPrice getFixedPrice();

    public CalculationSchedule getSchedule();

    @Override
    public FixedPricePayout build();

    @Override
    public FixedPricePayoutBuilder toBuilder();

    public static FixedPricePayoutBuilder builder() {
        return new FixedPricePayoutBuilderImpl();
    }

    default public RosettaMetaData<? extends FixedPricePayout> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FixedPricePayout> getType() {
        return FixedPricePayout.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.class, this.getPrincipalPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.class, this.getSettlementTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDates"), processor, PaymentDates.class, this.getPaymentDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedPrice"), processor, FixedPrice.class, this.getFixedPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("schedule"), processor, CalculationSchedule.class, this.getSchedule(), new AttributeMeta[0]);
    }

    public static class FixedPricePayoutBuilderImpl
    extends PayoutBase.PayoutBaseBuilderImpl
    implements FixedPricePayoutBuilder {
        protected PaymentDates.PaymentDatesBuilder paymentDates;
        protected FixedPrice.FixedPriceBuilder fixedPrice;
        protected CalculationSchedule.CalculationScheduleBuilder schedule;

        @Override
        @RosettaAttribute(value="paymentDates", isRequired=true)
        @RuneAttribute(value="paymentDates", isRequired=true)
        public PaymentDates.PaymentDatesBuilder getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        public PaymentDates.PaymentDatesBuilder getOrCreatePaymentDates() {
            PaymentDates.PaymentDatesBuilder result = this.paymentDates != null ? this.paymentDates : (this.paymentDates = PaymentDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixedPrice", isRequired=true)
        @RuneAttribute(value="fixedPrice", isRequired=true)
        public FixedPrice.FixedPriceBuilder getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public FixedPrice.FixedPriceBuilder getOrCreateFixedPrice() {
            FixedPrice.FixedPriceBuilder result = this.fixedPrice != null ? this.fixedPrice : (this.fixedPrice = FixedPrice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="schedule")
        @RuneAttribute(value="schedule")
        public CalculationSchedule.CalculationScheduleBuilder getSchedule() {
            return this.schedule;
        }

        @Override
        public CalculationSchedule.CalculationScheduleBuilder getOrCreateSchedule() {
            CalculationSchedule.CalculationScheduleBuilder result = this.schedule != null ? this.schedule : (this.schedule = CalculationSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public FixedPricePayoutBuilder setPayerReceiver(PayerReceiver _payerReceiver) {
            this.payerReceiver = _payerReceiver == null ? null : _payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceQuantity")
        @RuneAttribute(value="priceQuantity")
        public FixedPricePayoutBuilder setPriceQuantity(ResolvablePriceQuantity _priceQuantity) {
            this.priceQuantity = _priceQuantity == null ? null : _priceQuantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="principalPayment")
        @RuneAttribute(value="principalPayment")
        public FixedPricePayoutBuilder setPrincipalPayment(PrincipalPayments _principalPayment) {
            this.principalPayment = _principalPayment == null ? null : _principalPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementTerms")
        @RuneAttribute(value="settlementTerms")
        public FixedPricePayoutBuilder setSettlementTerms(SettlementTerms _settlementTerms) {
            this.settlementTerms = _settlementTerms == null ? null : _settlementTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDates", isRequired=true)
        @RuneAttribute(value="paymentDates", isRequired=true)
        public FixedPricePayoutBuilder setPaymentDates(PaymentDates _paymentDates) {
            this.paymentDates = _paymentDates == null ? null : _paymentDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedPrice", isRequired=true)
        @RuneAttribute(value="fixedPrice", isRequired=true)
        public FixedPricePayoutBuilder setFixedPrice(FixedPrice _fixedPrice) {
            this.fixedPrice = _fixedPrice == null ? null : _fixedPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="schedule")
        @RuneAttribute(value="schedule")
        public FixedPricePayoutBuilder setSchedule(CalculationSchedule _schedule) {
            this.schedule = _schedule == null ? null : _schedule.toBuilder();
            return this;
        }

        @Override
        public FixedPricePayout build() {
            return new FixedPricePayoutImpl(this);
        }

        @Override
        public FixedPricePayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public FixedPricePayoutBuilder prune() {
            super.prune();
            if (this.paymentDates != null && !this.paymentDates.prune().hasData()) {
                this.paymentDates = null;
            }
            if (this.fixedPrice != null && !this.fixedPrice.prune().hasData()) {
                this.fixedPrice = null;
            }
            if (this.schedule != null && !this.schedule.prune().hasData()) {
                this.schedule = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPaymentDates() != null && this.getPaymentDates().hasData()) {
                return true;
            }
            if (this.getFixedPrice() != null && this.getFixedPrice().hasData()) {
                return true;
            }
            return this.getSchedule() != null && this.getSchedule().hasData();
        }

        @Override
        public FixedPricePayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FixedPricePayoutBuilder o = (FixedPricePayoutBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDates(), (RosettaModelObjectBuilder)o.getPaymentDates(), this::setPaymentDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedPrice(), (RosettaModelObjectBuilder)o.getFixedPrice(), this::setFixedPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSchedule(), (RosettaModelObjectBuilder)o.getSchedule(), this::setSchedule);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FixedPricePayout _that = (FixedPricePayout)this.getType().cast(o);
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            if (!Objects.equals(this.fixedPrice, _that.getFixedPrice())) {
                return false;
            }
            return Objects.equals(this.schedule, _that.getSchedule());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.fixedPrice != null ? this.fixedPrice.hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FixedPricePayoutBuilder {paymentDates=" + this.paymentDates + ", fixedPrice=" + this.fixedPrice + ", schedule=" + this.schedule + '}' + " " + super.toString();
        }
    }

    public static interface FixedPricePayoutBuilder
    extends FixedPricePayout,
    PayoutBase.PayoutBaseBuilder {
        public PaymentDates.PaymentDatesBuilder getOrCreatePaymentDates();

        @Override
        public PaymentDates.PaymentDatesBuilder getPaymentDates();

        public FixedPrice.FixedPriceBuilder getOrCreateFixedPrice();

        @Override
        public FixedPrice.FixedPriceBuilder getFixedPrice();

        public CalculationSchedule.CalculationScheduleBuilder getOrCreateSchedule();

        @Override
        public CalculationSchedule.CalculationScheduleBuilder getSchedule();

        @Override
        public FixedPricePayoutBuilder setPayerReceiver(PayerReceiver var1);

        @Override
        public FixedPricePayoutBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        @Override
        public FixedPricePayoutBuilder setPrincipalPayment(PrincipalPayments var1);

        @Override
        public FixedPricePayoutBuilder setSettlementTerms(SettlementTerms var1);

        public FixedPricePayoutBuilder setPaymentDates(PaymentDates var1);

        public FixedPricePayoutBuilder setFixedPrice(FixedPrice var1);

        public FixedPricePayoutBuilder setSchedule(CalculationSchedule var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.PayerReceiverBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.ResolvablePriceQuantityBuilder.class, (RosettaModelObjectBuilder)this.getPriceQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.PrincipalPaymentsBuilder.class, (RosettaModelObjectBuilder)this.getPrincipalPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.SettlementTermsBuilder.class, (RosettaModelObjectBuilder)this.getSettlementTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDates"), processor, PaymentDates.PaymentDatesBuilder.class, this.getPaymentDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedPrice"), processor, FixedPrice.FixedPriceBuilder.class, this.getFixedPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("schedule"), processor, CalculationSchedule.CalculationScheduleBuilder.class, this.getSchedule(), new AttributeMeta[0]);
        }

        @Override
        public FixedPricePayoutBuilder prune();
    }

    public static class FixedPricePayoutImpl
    extends PayoutBase.PayoutBaseImpl
    implements FixedPricePayout {
        private final PaymentDates paymentDates;
        private final FixedPrice fixedPrice;
        private final CalculationSchedule schedule;

        protected FixedPricePayoutImpl(FixedPricePayoutBuilder builder) {
            super(builder);
            this.paymentDates = Optional.ofNullable(builder.getPaymentDates()).map(f -> f.build()).orElse(null);
            this.fixedPrice = Optional.ofNullable(builder.getFixedPrice()).map(f -> f.build()).orElse(null);
            this.schedule = Optional.ofNullable(builder.getSchedule()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="paymentDates", isRequired=true)
        @RuneAttribute(value="paymentDates", isRequired=true)
        public PaymentDates getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        @RosettaAttribute(value="fixedPrice", isRequired=true)
        @RuneAttribute(value="fixedPrice", isRequired=true)
        public FixedPrice getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        @RosettaAttribute(value="schedule")
        @RuneAttribute(value="schedule")
        public CalculationSchedule getSchedule() {
            return this.schedule;
        }

        @Override
        public FixedPricePayout build() {
            return this;
        }

        @Override
        public FixedPricePayoutBuilder toBuilder() {
            FixedPricePayoutBuilder builder = FixedPricePayout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FixedPricePayoutBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPaymentDates()).ifPresent(builder::setPaymentDates);
            Optional.ofNullable(this.getFixedPrice()).ifPresent(builder::setFixedPrice);
            Optional.ofNullable(this.getSchedule()).ifPresent(builder::setSchedule);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FixedPricePayout _that = (FixedPricePayout)this.getType().cast(o);
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            if (!Objects.equals(this.fixedPrice, _that.getFixedPrice())) {
                return false;
            }
            return Objects.equals(this.schedule, _that.getSchedule());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.fixedPrice != null ? this.fixedPrice.hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FixedPricePayout {paymentDates=" + this.paymentDates + ", fixedPrice=" + this.fixedPrice + ", schedule=" + this.schedule + '}' + " " + super.toString();
        }
    }
}

