/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.qualification.functions;

import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;

@ImplementedBy(value=InterestRatePayoutOnlyExistsDefault.class)
public abstract class InterestRatePayoutOnlyExists
implements RosettaFunction {
    public Boolean evaluate(List<? extends Payout> payouts) {
        Boolean result = this.doEvaluate(payouts);
        return result;
    }

    protected abstract Boolean doEvaluate(List<? extends Payout> var1);

    public static class InterestRatePayoutOnlyExistsDefault
    extends InterestRatePayoutOnlyExists {
        @Override
        protected Boolean doEvaluate(List<? extends Payout> payouts) {
            if (payouts == null) {
                payouts = Collections.emptyList();
            }
            Boolean result = null;
            return this.assignOutput(result, payouts);
        }

        protected Boolean assignOutput(Boolean result, List<? extends Payout> payouts) {
            MapperC thenArg0 = MapperC.of(payouts).mapItem(item -> ExpressionOperators.exists((Mapper)item.map("getInterestRatePayout", payout -> payout.getInterestRatePayout())).asMapper());
            MapperS thenArg1 = ExpressionOperators.areEqual((Mapper)thenArg0, (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).asMapper();
            result = (Boolean)MapperS.of((Object)((Boolean)thenArg1.getOrDefault((Object)false))).get();
            return result;
        }
    }
}

