/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.validation.datarule;

import cdm.product.common.settlement.AssetFlowBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="AssetFlowBaseQuantityUnitExists")
@ImplementedBy(value=Default.class)
public interface AssetFlowBaseQuantityUnitExists
extends Validator<AssetFlowBase> {
    public static final String NAME = "AssetFlowBaseQuantityUnitExists";
    public static final String DEFINITION = "if asset -> Cash exists then quantity -> unit -> currency exists else if asset -> Commodity exists then quantity -> unit -> capacityUnit exists else if asset -> Instrument exists then quantity -> unit -> financialUnit exists";

    public static class NoOp
    implements AssetFlowBaseQuantityUnitExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetFlowBase assetFlowBase) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements AssetFlowBaseQuantityUnitExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetFlowBase assetFlowBase) {
            ComparisonResult result = this.executeDataRule(assetFlowBase);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)AssetFlowBaseQuantityUnitExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetFlowBase", (RosettaPath)path, (String)AssetFlowBaseQuantityUnitExists.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)AssetFlowBaseQuantityUnitExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetFlowBase", (RosettaPath)path, (String)AssetFlowBaseQuantityUnitExists.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(AssetFlowBase assetFlowBase) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)assetFlowBase).map("getAsset", _assetFlowBase -> _assetFlowBase.getAsset()).map("getCash", asset -> asset.getCash())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)assetFlowBase).map("getQuantity", _assetFlowBase -> _assetFlowBase.getQuantity()).map("getUnit", nonNegativeQuantity -> nonNegativeQuantity.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()));
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)assetFlowBase).map("getAsset", _assetFlowBase -> _assetFlowBase.getAsset()).map("getCommodity", asset -> asset.getCommodity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)assetFlowBase).map("getQuantity", _assetFlowBase -> _assetFlowBase.getQuantity()).map("getUnit", nonNegativeQuantity -> nonNegativeQuantity.getUnit()).map("getCapacityUnit", unitType -> unitType.getCapacityUnit()));
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)assetFlowBase).map("getAsset", _assetFlowBase -> _assetFlowBase.getAsset()).map("getInstrument", asset -> asset.getInstrument())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)assetFlowBase).map("getQuantity", _assetFlowBase -> _assetFlowBase.getQuantity()).map("getUnit", nonNegativeQuantity -> nonNegativeQuantity.getUnit()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

