/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate.functions;

import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaFloatingRateIndexEnum;
import cdm.observable.asset.fro.FloatingRateIndexCalculationDefaults;
import cdm.observable.asset.fro.FloatingRateIndexCalculationMethodEnum;
import cdm.observable.asset.fro.FloatingRateIndexCategoryEnum;
import cdm.observable.asset.fro.FloatingRateIndexDefinition;
import cdm.observable.asset.fro.FloatingRateIndexStyleEnum;
import cdm.observable.asset.fro.functions.FloatingRateIndexMetadata;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.floatingrate.FloatingRateIndexProcessingTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import javax.inject.Inject;

@ImplementedBy(value=GetFloatingRateProcessingTypeDefault.class)
public abstract class GetFloatingRateProcessingType
implements RosettaFunction {
    @Inject
    protected FloatingRateIndexMetadata floatingRateIndexMetadata;

    public FloatingRateIndexProcessingTypeEnum evaluate(FloatingRateSpecification rateDef) {
        FloatingRateIndexProcessingTypeEnum processingType = this.doEvaluate(rateDef);
        return processingType;
    }

    protected abstract FloatingRateIndexProcessingTypeEnum doEvaluate(FloatingRateSpecification var1);

    protected abstract MapperS<Boolean> isCalculatedRate(FloatingRateSpecification var1);

    protected abstract MapperS<? extends FloatingRateIndexDefinition> floatingRateDefinition(FloatingRateSpecification var1);

    protected abstract MapperS<? extends FloatingRateIndexCalculationDefaults> calcDefaults(FloatingRateSpecification var1);

    protected abstract MapperS<FloatingRateIndexCategoryEnum> category(FloatingRateSpecification var1);

    protected abstract MapperS<FloatingRateIndexStyleEnum> idxStyle(FloatingRateSpecification var1);

    protected abstract MapperS<FloatingRateIndexCalculationMethodEnum> method(FloatingRateSpecification var1);

    protected abstract MapperS<FloatingRateIndexProcessingTypeEnum> calcProcessingType(FloatingRateSpecification var1);

    protected abstract MapperS<FloatingRateIndexProcessingTypeEnum> definitionProcessingType(FloatingRateSpecification var1);

    protected abstract MapperS<FloatingRateIndexProcessingTypeEnum> processingCategory(FloatingRateSpecification var1);

    public static class GetFloatingRateProcessingTypeDefault
    extends GetFloatingRateProcessingType {
        @Override
        protected FloatingRateIndexProcessingTypeEnum doEvaluate(FloatingRateSpecification rateDef) {
            FloatingRateIndexProcessingTypeEnum processingType = null;
            return this.assignOutput(processingType, rateDef);
        }

        protected FloatingRateIndexProcessingTypeEnum assignOutput(FloatingRateIndexProcessingTypeEnum processingType, FloatingRateSpecification rateDef) {
            processingType = (FloatingRateIndexProcessingTypeEnum)((Object)this.processingCategory(rateDef).get());
            return processingType;
        }

        @Override
        protected MapperS<Boolean> isCalculatedRate(FloatingRateSpecification rateDef) {
            return ExpressionOperators.exists((Mapper)MapperS.of((Object)rateDef).map("getCalculationParameters", floatingRateSpecification -> floatingRateSpecification.getCalculationParameters())).asMapper();
        }

        @Override
        protected MapperS<? extends FloatingRateIndexDefinition> floatingRateDefinition(FloatingRateSpecification rateDef) {
            FieldWithMetaFloatingRateIndexEnum fieldWithMetaFloatingRateIndexEnum = (FieldWithMetaFloatingRateIndexEnum)MapperS.of((Object)rateDef).map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).map("Type coercion", referenceWithMetaInterestRateIndex -> referenceWithMetaInterestRateIndex == null ? null : referenceWithMetaInterestRateIndex.getValue()).map("getFloatingRateIndex", interestRateIndex -> interestRateIndex.getFloatingRateIndex()).map("getFloatingRateIndex", floatingRateIndex -> floatingRateIndex.getFloatingRateIndex()).get();
            return MapperS.of((Object)this.floatingRateIndexMetadata.evaluate(fieldWithMetaFloatingRateIndexEnum == null ? null : fieldWithMetaFloatingRateIndexEnum.getValue()));
        }

        @Override
        protected MapperS<? extends FloatingRateIndexCalculationDefaults> calcDefaults(FloatingRateSpecification rateDef) {
            return this.floatingRateDefinition(rateDef).map("getCalculationDefaults", floatingRateIndexDefinition -> floatingRateIndexDefinition.getCalculationDefaults());
        }

        @Override
        protected MapperS<FloatingRateIndexCategoryEnum> category(FloatingRateSpecification rateDef) {
            return this.calcDefaults(rateDef).map("getCategory", floatingRateIndexCalculationDefaults -> floatingRateIndexCalculationDefaults.getCategory());
        }

        @Override
        protected MapperS<FloatingRateIndexStyleEnum> idxStyle(FloatingRateSpecification rateDef) {
            return this.calcDefaults(rateDef).map("getIndexStyle", floatingRateIndexCalculationDefaults -> floatingRateIndexCalculationDefaults.getIndexStyle());
        }

        @Override
        protected MapperS<FloatingRateIndexCalculationMethodEnum> method(FloatingRateSpecification rateDef) {
            return this.calcDefaults(rateDef).map("getMethod", floatingRateIndexCalculationDefaults -> floatingRateIndexCalculationDefaults.getMethod());
        }

        @Override
        protected MapperS<FloatingRateIndexProcessingTypeEnum> calcProcessingType(FloatingRateSpecification rateDef) {
            if (ExpressionOperators.areEqual(this.idxStyle(rateDef), (Mapper)MapperS.of((Object)((Object)FloatingRateIndexStyleEnum.COMPOUNDED_FRO)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual(this.method(rateDef), (Mapper)MapperS.of((Object)((Object)FloatingRateIndexCalculationMethodEnum.OIS_COMPOUND)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((Object)FloatingRateIndexProcessingTypeEnum.OIS));
            }
            if (ExpressionOperators.areEqual(this.idxStyle(rateDef), (Mapper)MapperS.of((Object)((Object)FloatingRateIndexStyleEnum.AVERAGE_FRO)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual(this.method(rateDef), (Mapper)MapperS.of((Object)((Object)FloatingRateIndexCalculationMethodEnum.AVERAGE)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((Object)FloatingRateIndexProcessingTypeEnum.OVERNIGHT_AVG));
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<FloatingRateIndexProcessingTypeEnum> definitionProcessingType(FloatingRateSpecification rateDef) {
            if (ExpressionOperators.areEqual(this.category(rateDef), (Mapper)MapperS.of((Object)((Object)FloatingRateIndexCategoryEnum.SCREEN_RATE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((Object)FloatingRateIndexProcessingTypeEnum.SCREEN));
            }
            return this.calcProcessingType(rateDef);
        }

        @Override
        protected MapperS<FloatingRateIndexProcessingTypeEnum> processingCategory(FloatingRateSpecification rateDef) {
            if (ExpressionOperators.areEqual(this.isCalculatedRate(rateDef), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((Object)FloatingRateIndexProcessingTypeEnum.MODULAR));
            }
            if (ExpressionOperators.exists((Mapper)this.floatingRateDefinition(rateDef).map("getFro", floatingRateIndexDefinition -> floatingRateIndexDefinition.getFro())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.definitionProcessingType(rateDef);
            }
            return MapperS.of((Object)((Object)FloatingRateIndexProcessingTypeEnum.SCREEN));
        }
    }
}

