/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate.functions;

import cdm.product.asset.floatingrate.FloatingRateProcessingParameters;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

@ImplementedBy(value=ApplyCapsAndFloorsDefault.class)
public abstract class ApplyCapsAndFloors
implements RosettaFunction {
    public BigDecimal evaluate(FloatingRateProcessingParameters processing, BigDecimal inputRate) {
        BigDecimal cappedAndFlooredRate = this.doEvaluate(processing, inputRate);
        return cappedAndFlooredRate;
    }

    protected abstract BigDecimal doEvaluate(FloatingRateProcessingParameters var1, BigDecimal var2);

    protected abstract MapperS<BigDecimal> cap(FloatingRateProcessingParameters var1, BigDecimal var2);

    protected abstract MapperS<BigDecimal> floor(FloatingRateProcessingParameters var1, BigDecimal var2);

    protected abstract MapperS<BigDecimal> cappedRate(FloatingRateProcessingParameters var1, BigDecimal var2);

    protected abstract MapperS<BigDecimal> flooredRate(FloatingRateProcessingParameters var1, BigDecimal var2);

    public static class ApplyCapsAndFloorsDefault
    extends ApplyCapsAndFloors {
        @Override
        protected BigDecimal doEvaluate(FloatingRateProcessingParameters processing, BigDecimal inputRate) {
            BigDecimal cappedAndFlooredRate = null;
            return this.assignOutput(cappedAndFlooredRate, processing, inputRate);
        }

        protected BigDecimal assignOutput(BigDecimal cappedAndFlooredRate, FloatingRateProcessingParameters processing, BigDecimal inputRate) {
            cappedAndFlooredRate = (BigDecimal)this.flooredRate(processing, inputRate).get();
            return cappedAndFlooredRate;
        }

        @Override
        protected MapperS<BigDecimal> cap(FloatingRateProcessingParameters processing, BigDecimal inputRate) {
            return MapperS.of((Object)processing).map("getCapRate", floatingRateProcessingParameters -> floatingRateProcessingParameters.getCapRate());
        }

        @Override
        protected MapperS<BigDecimal> floor(FloatingRateProcessingParameters processing, BigDecimal inputRate) {
            return MapperS.of((Object)processing).map("getFloorRate", floatingRateProcessingParameters -> floatingRateProcessingParameters.getFloorRate());
        }

        @Override
        protected MapperS<BigDecimal> cappedRate(FloatingRateProcessingParameters processing, BigDecimal inputRate) {
            if (ExpressionOperators.exists(this.cap(processing, inputRate)).and(ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)inputRate), this.cap(processing, inputRate), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.cap(processing, inputRate);
            }
            return MapperS.of((Object)inputRate);
        }

        @Override
        protected MapperS<BigDecimal> flooredRate(FloatingRateProcessingParameters processing, BigDecimal inputRate) {
            if (ExpressionOperators.exists(this.floor(processing, inputRate)).and(ExpressionOperators.lessThan(this.cappedRate(processing, inputRate), this.floor(processing, inputRate), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.floor(processing, inputRate);
            }
            return this.cappedRate(processing, inputRate);
        }
    }
}

