/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.product.asset.AssetDeliveryProfileBlock;
import cdm.product.asset.BankHolidayTreatmentEnum;
import cdm.product.asset.LoadTypeEnum;
import cdm.product.asset.meta.AssetDeliveryProfileMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AssetDeliveryProfile", builder=AssetDeliveryProfileBuilderImpl.class, version="6.10.0")
@RuneDataType(value="AssetDeliveryProfile", model="cdm", builder=AssetDeliveryProfileBuilderImpl.class, version="6.10.0")
public interface AssetDeliveryProfile
extends RosettaModelObject {
    public static final AssetDeliveryProfileMeta metaData = new AssetDeliveryProfileMeta();

    public LoadTypeEnum getLoadType();

    public List<? extends AssetDeliveryProfileBlock> getBlock();

    public BankHolidayTreatmentEnum getBankHolidaysTreatment();

    public AssetDeliveryProfile build();

    public AssetDeliveryProfileBuilder toBuilder();

    public static AssetDeliveryProfileBuilder builder() {
        return new AssetDeliveryProfileBuilderImpl();
    }

    default public RosettaMetaData<? extends AssetDeliveryProfile> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AssetDeliveryProfile> getType() {
        return AssetDeliveryProfile.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("loadType"), LoadTypeEnum.class, (Object)this.getLoadType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("block"), processor, AssetDeliveryProfileBlock.class, this.getBlock(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("bankHolidaysTreatment"), BankHolidayTreatmentEnum.class, (Object)this.getBankHolidaysTreatment(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AssetDeliveryProfileBuilderImpl
    implements AssetDeliveryProfileBuilder {
        protected LoadTypeEnum loadType;
        protected List<AssetDeliveryProfileBlock.AssetDeliveryProfileBlockBuilder> block = new ArrayList<AssetDeliveryProfileBlock.AssetDeliveryProfileBlockBuilder>();
        protected BankHolidayTreatmentEnum bankHolidaysTreatment;

        @Override
        @RosettaAttribute(value="loadType")
        @RuneAttribute(value="loadType")
        public LoadTypeEnum getLoadType() {
            return this.loadType;
        }

        @Override
        @RosettaAttribute(value="block")
        @RuneAttribute(value="block")
        public List<? extends AssetDeliveryProfileBlock.AssetDeliveryProfileBlockBuilder> getBlock() {
            return this.block;
        }

        @Override
        public AssetDeliveryProfileBlock.AssetDeliveryProfileBlockBuilder getOrCreateBlock(int index) {
            if (this.block == null) {
                this.block = new ArrayList<AssetDeliveryProfileBlock.AssetDeliveryProfileBlockBuilder>();
            }
            return (AssetDeliveryProfileBlock.AssetDeliveryProfileBlockBuilder)this.getIndex(this.block, index, () -> {
                AssetDeliveryProfileBlock.AssetDeliveryProfileBlockBuilder newBlock = AssetDeliveryProfileBlock.builder();
                return newBlock;
            });
        }

        @Override
        @RosettaAttribute(value="bankHolidaysTreatment")
        @RuneAttribute(value="bankHolidaysTreatment")
        public BankHolidayTreatmentEnum getBankHolidaysTreatment() {
            return this.bankHolidaysTreatment;
        }

        @Override
        @RosettaAttribute(value="loadType")
        @RuneAttribute(value="loadType")
        public AssetDeliveryProfileBuilder setLoadType(LoadTypeEnum _loadType) {
            this.loadType = _loadType == null ? null : _loadType;
            return this;
        }

        @Override
        @RosettaAttribute(value="block")
        @RuneAttribute(value="block")
        public AssetDeliveryProfileBuilder addBlock(AssetDeliveryProfileBlock _block) {
            if (_block != null) {
                this.block.add(_block.toBuilder());
            }
            return this;
        }

        @Override
        public AssetDeliveryProfileBuilder addBlock(AssetDeliveryProfileBlock _block, int idx) {
            this.getIndex(this.block, idx, () -> _block.toBuilder());
            return this;
        }

        @Override
        public AssetDeliveryProfileBuilder addBlock(List<? extends AssetDeliveryProfileBlock> blocks) {
            if (blocks != null) {
                for (AssetDeliveryProfileBlock assetDeliveryProfileBlock : blocks) {
                    this.block.add(assetDeliveryProfileBlock.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="block")
        public AssetDeliveryProfileBuilder setBlock(List<? extends AssetDeliveryProfileBlock> blocks) {
            this.block = blocks == null ? new ArrayList<AssetDeliveryProfileBlock.AssetDeliveryProfileBlockBuilder>() : (List)blocks.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="bankHolidaysTreatment")
        @RuneAttribute(value="bankHolidaysTreatment")
        public AssetDeliveryProfileBuilder setBankHolidaysTreatment(BankHolidayTreatmentEnum _bankHolidaysTreatment) {
            this.bankHolidaysTreatment = _bankHolidaysTreatment == null ? null : _bankHolidaysTreatment;
            return this;
        }

        @Override
        public AssetDeliveryProfile build() {
            return new AssetDeliveryProfileImpl(this);
        }

        @Override
        public AssetDeliveryProfileBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetDeliveryProfileBuilder prune() {
            this.block = this.block.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getLoadType() != null) {
                return true;
            }
            if (this.getBlock() != null && this.getBlock().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getBankHolidaysTreatment() != null;
        }

        public AssetDeliveryProfileBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AssetDeliveryProfileBuilder o = (AssetDeliveryProfileBuilder)other;
            merger.mergeRosetta(this.getBlock(), o.getBlock(), this::getOrCreateBlock);
            merger.mergeBasic((Object)this.getLoadType(), (Object)o.getLoadType(), this::setLoadType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBankHolidaysTreatment(), (Object)o.getBankHolidaysTreatment(), this::setBankHolidaysTreatment, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetDeliveryProfile _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.loadType, (Object)_that.getLoadType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.block, _that.getBlock())) {
                return false;
            }
            return Objects.equals((Object)this.bankHolidaysTreatment, (Object)_that.getBankHolidaysTreatment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.loadType != null ? ((Object)((Object)this.loadType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.block != null ? this.block.hashCode() : 0);
            _result = 31 * _result + (this.bankHolidaysTreatment != null ? ((Object)((Object)this.bankHolidaysTreatment)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetDeliveryProfileBuilder {loadType=" + (Object)((Object)this.loadType) + ", block=" + this.block + ", bankHolidaysTreatment=" + (Object)((Object)this.bankHolidaysTreatment) + '}';
        }
    }

    public static interface AssetDeliveryProfileBuilder
    extends AssetDeliveryProfile,
    RosettaModelObjectBuilder {
        public AssetDeliveryProfileBlock.AssetDeliveryProfileBlockBuilder getOrCreateBlock(int var1);

        public List<? extends AssetDeliveryProfileBlock.AssetDeliveryProfileBlockBuilder> getBlock();

        public AssetDeliveryProfileBuilder setLoadType(LoadTypeEnum var1);

        public AssetDeliveryProfileBuilder addBlock(AssetDeliveryProfileBlock var1);

        public AssetDeliveryProfileBuilder addBlock(AssetDeliveryProfileBlock var1, int var2);

        public AssetDeliveryProfileBuilder addBlock(List<? extends AssetDeliveryProfileBlock> var1);

        public AssetDeliveryProfileBuilder setBlock(List<? extends AssetDeliveryProfileBlock> var1);

        public AssetDeliveryProfileBuilder setBankHolidaysTreatment(BankHolidayTreatmentEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("loadType"), LoadTypeEnum.class, (Object)this.getLoadType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("block"), processor, AssetDeliveryProfileBlock.AssetDeliveryProfileBlockBuilder.class, this.getBlock(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("bankHolidaysTreatment"), BankHolidayTreatmentEnum.class, (Object)this.getBankHolidaysTreatment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public AssetDeliveryProfileBuilder prune();
    }

    public static class AssetDeliveryProfileImpl
    implements AssetDeliveryProfile {
        private final LoadTypeEnum loadType;
        private final List<? extends AssetDeliveryProfileBlock> block;
        private final BankHolidayTreatmentEnum bankHolidaysTreatment;

        protected AssetDeliveryProfileImpl(AssetDeliveryProfileBuilder builder) {
            this.loadType = builder.getLoadType();
            this.block = Optional.ofNullable(builder.getBlock()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.bankHolidaysTreatment = builder.getBankHolidaysTreatment();
        }

        @Override
        @RosettaAttribute(value="loadType")
        @RuneAttribute(value="loadType")
        public LoadTypeEnum getLoadType() {
            return this.loadType;
        }

        @Override
        @RosettaAttribute(value="block")
        @RuneAttribute(value="block")
        public List<? extends AssetDeliveryProfileBlock> getBlock() {
            return this.block;
        }

        @Override
        @RosettaAttribute(value="bankHolidaysTreatment")
        @RuneAttribute(value="bankHolidaysTreatment")
        public BankHolidayTreatmentEnum getBankHolidaysTreatment() {
            return this.bankHolidaysTreatment;
        }

        @Override
        public AssetDeliveryProfile build() {
            return this;
        }

        @Override
        public AssetDeliveryProfileBuilder toBuilder() {
            AssetDeliveryProfileBuilder builder = AssetDeliveryProfile.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetDeliveryProfileBuilder builder) {
            Optional.ofNullable(this.getLoadType()).ifPresent(builder::setLoadType);
            Optional.ofNullable(this.getBlock()).ifPresent(builder::setBlock);
            Optional.ofNullable(this.getBankHolidaysTreatment()).ifPresent(builder::setBankHolidaysTreatment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetDeliveryProfile _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.loadType, (Object)_that.getLoadType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.block, _that.getBlock())) {
                return false;
            }
            return Objects.equals((Object)this.bankHolidaysTreatment, (Object)_that.getBankHolidaysTreatment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.loadType != null ? ((Object)((Object)this.loadType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.block != null ? this.block.hashCode() : 0);
            _result = 31 * _result + (this.bankHolidaysTreatment != null ? ((Object)((Object)this.bankHolidaysTreatment)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetDeliveryProfile {loadType=" + (Object)((Object)this.loadType) + ", block=" + this.block + ", bankHolidaysTreatment=" + (Object)((Object)this.bankHolidaysTreatment) + '}';
        }
    }
}

