/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PriceQuantityArithmeticOperator")
@ImplementedBy(value=Default.class)
public interface PriceQuantityArithmeticOperator
extends Validator<PriceQuantity> {
    public static final String NAME = "PriceQuantityArithmeticOperator";
    public static final String DEFINITION = "if observable -> Index -> InterestRateIndex exists and price exists then price -> arithmeticOperator exists";

    public static class NoOp
    implements PriceQuantityArithmeticOperator {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceQuantity priceQuantity) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PriceQuantityArithmeticOperator {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceQuantity priceQuantity) {
            ComparisonResult result = this.executeDataRule(priceQuantity);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PriceQuantityArithmeticOperator.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceQuantity", (RosettaPath)path, (String)PriceQuantityArithmeticOperator.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PriceQuantityArithmeticOperator.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceQuantity", (RosettaPath)path, (String)PriceQuantityArithmeticOperator.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PriceQuantity priceQuantity) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)priceQuantity).map("getObservable", _priceQuantity -> _priceQuantity.getObservable()).map("Type coercion", fieldWithMetaObservable -> fieldWithMetaObservable == null ? null : fieldWithMetaObservable.getValue()).map("getIndex", observable -> observable.getIndex()).map("getInterestRateIndex", index -> index.getInterestRateIndex())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)priceQuantity).mapC("getPrice", _priceQuantity -> _priceQuantity.getPrice()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)priceQuantity).mapC("getPrice", _priceQuantity -> _priceQuantity.getPrice()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

