/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.BusinessCenters;
import cdm.base.datetime.functions.AppendDateToList;
import cdm.base.datetime.functions.GetAllBusinessCenters;
import cdm.observable.asset.calculatedrate.FloatingRateCalculationParameters;
import cdm.observable.asset.calculatedrate.ObservationShiftCalculation;
import cdm.observable.asset.calculatedrate.OffsetCalculation;
import cdm.observable.asset.calculatedrate.functions.GenerateObservationDates;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=DetermineWeightingDatesDefault.class)
public abstract class DetermineWeightingDates
implements RosettaFunction {
    @Inject
    protected AppendDateToList appendDateToList;
    @Inject
    protected GenerateObservationDates generateObservationDates;
    @Inject
    protected GetAllBusinessCenters getAllBusinessCenters;

    public List<Date> evaluate(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
        List<Date> weightingDates = this.doEvaluate(calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays);
        return weightingDates;
    }

    protected abstract List<Date> doEvaluate(FloatingRateCalculationParameters var1, List<Date> var2, CalculationPeriodBase var3, CalculationPeriodBase var4, Integer var5);

    protected abstract MapperS<? extends ObservationShiftCalculation> obsShift(FloatingRateCalculationParameters var1, List<Date> var2, CalculationPeriodBase var3, CalculationPeriodBase var4, Integer var5);

    protected abstract MapperS<? extends OffsetCalculation> lookback(FloatingRateCalculationParameters var1, List<Date> var2, CalculationPeriodBase var3, CalculationPeriodBase var4, Integer var5);

    protected abstract MapperC<BusinessCenterEnum> businessCenters(FloatingRateCalculationParameters var1, List<Date> var2, CalculationPeriodBase var3, CalculationPeriodBase var4, Integer var5);

    protected abstract MapperC<Date> baseWeightingDates(FloatingRateCalculationParameters var1, List<Date> var2, CalculationPeriodBase var3, CalculationPeriodBase var4, Integer var5);

    protected abstract MapperS<? extends CalculationPeriodBase> wtPeriod(FloatingRateCalculationParameters var1, List<Date> var2, CalculationPeriodBase var3, CalculationPeriodBase var4, Integer var5);

    protected abstract MapperC<Date> weightingDatesAll(FloatingRateCalculationParameters var1, List<Date> var2, CalculationPeriodBase var3, CalculationPeriodBase var4, Integer var5);

    public static class DetermineWeightingDatesDefault
    extends DetermineWeightingDates {
        @Override
        protected List<Date> doEvaluate(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            if (observationDates == null) {
                observationDates = Collections.emptyList();
            }
            ArrayList<Date> weightingDates = new ArrayList<Date>();
            return this.assignOutput(weightingDates, calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays);
        }

        protected List<Date> assignOutput(List<Date> weightingDates, FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            weightingDates.addAll(this.weightingDatesAll(calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays).getMulti());
            return weightingDates;
        }

        @Override
        protected MapperS<? extends ObservationShiftCalculation> obsShift(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            return MapperS.of((Object)calculationParams).map("getObservationShiftCalculation", floatingRateCalculationParameters -> floatingRateCalculationParameters.getObservationShiftCalculation());
        }

        @Override
        protected MapperS<? extends OffsetCalculation> lookback(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            return MapperS.of((Object)calculationParams).map("getLookbackCalculation", floatingRateCalculationParameters -> floatingRateCalculationParameters.getLookbackCalculation());
        }

        @Override
        protected MapperC<BusinessCenterEnum> businessCenters(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            return MapperC.of(this.getAllBusinessCenters.evaluate((BusinessCenters)MapperS.of((Object)calculationParams).map("getApplicableBusinessDays", floatingRateCalculationParameters -> floatingRateCalculationParameters.getApplicableBusinessDays()).get()));
        }

        @Override
        protected MapperC<Date> baseWeightingDates(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            if (ExpressionOperators.exists(this.obsShift(calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperC.of(observationDates);
            }
            return MapperC.of(this.generateObservationDates.evaluate(adjustedCalculationPeriod, this.businessCenters(calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays).getMulti(), lockoutDays));
        }

        @Override
        protected MapperS<? extends CalculationPeriodBase> wtPeriod(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            if (ExpressionOperators.exists(this.lookback(calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)adjustedCalculationPeriod);
            }
            return MapperS.of((Object)observationPeriod);
        }

        @Override
        protected MapperC<Date> weightingDatesAll(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            return MapperC.of(this.appendDateToList.evaluate(this.baseWeightingDates(calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays).getMulti(), (Date)this.wtPeriod(calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays).map("getAdjustedEndDate", calculationPeriodBase -> calculationPeriodBase.getAdjustedEndDate()).get()));
        }
    }
}

