/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.Taxonomy;
import cdm.base.staticdata.party.LegalEntity;
import cdm.observable.asset.IndexBase;
import cdm.observable.asset.meta.OtherIndexMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="OtherIndex", builder=OtherIndexBuilderImpl.class, version="6.10.0")
@RuneDataType(value="OtherIndex", model="cdm", builder=OtherIndexBuilderImpl.class, version="6.10.0")
public interface OtherIndex
extends IndexBase {
    public static final OtherIndexMeta metaData = new OtherIndexMeta();

    public String getDescription();

    @Override
    public OtherIndex build();

    @Override
    public OtherIndexBuilder toBuilder();

    public static OtherIndexBuilder builder() {
        return new OtherIndexBuilderImpl();
    }

    default public RosettaMetaData<? extends OtherIndex> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OtherIndex> getType() {
        return OtherIndex.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.class, this.getTaxonomy(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.class, this.getExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.class, this.getRelatedExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("name"), processor, FieldWithMetaString.class, this.getName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("provider"), processor, LegalEntity.class, this.getProvider(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("assetClass"), AssetClassEnum.class, (Object)this.getAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class OtherIndexBuilderImpl
    extends IndexBase.IndexBaseBuilderImpl
    implements OtherIndexBuilder {
        protected String description;

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public String getDescription() {
            return this.description;
        }

        @Override
        @RosettaAttribute(value="identifier", isRequired=true)
        @RuneAttribute(value="identifier", isRequired=true)
        public OtherIndexBuilder addIdentifier(AssetIdentifier _identifier) {
            if (_identifier != null) {
                this.identifier.add(_identifier.toBuilder());
            }
            return this;
        }

        @Override
        public OtherIndexBuilder addIdentifier(AssetIdentifier _identifier, int idx) {
            this.getIndex(this.identifier, idx, () -> _identifier.toBuilder());
            return this;
        }

        @Override
        public OtherIndexBuilder addIdentifier(List<? extends AssetIdentifier> identifiers) {
            if (identifiers != null) {
                for (AssetIdentifier assetIdentifier : identifiers) {
                    this.identifier.add(assetIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="identifier")
        public OtherIndexBuilder setIdentifier(List<? extends AssetIdentifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="taxonomy")
        @RuneAttribute(value="taxonomy")
        public OtherIndexBuilder addTaxonomy(Taxonomy _taxonomy) {
            if (_taxonomy != null) {
                this.taxonomy.add(_taxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public OtherIndexBuilder addTaxonomy(Taxonomy _taxonomy, int idx) {
            this.getIndex(this.taxonomy, idx, () -> _taxonomy.toBuilder());
            return this;
        }

        @Override
        public OtherIndexBuilder addTaxonomy(List<? extends Taxonomy> taxonomys) {
            if (taxonomys != null) {
                for (Taxonomy taxonomy : taxonomys) {
                    this.taxonomy.add(taxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="taxonomy")
        public OtherIndexBuilder setTaxonomy(List<? extends Taxonomy> taxonomys) {
            this.taxonomy = taxonomys == null ? new ArrayList() : (List)taxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="isExchangeListed")
        @RuneAttribute(value="isExchangeListed")
        public OtherIndexBuilder setIsExchangeListed(Boolean _isExchangeListed) {
            this.isExchangeListed = _isExchangeListed == null ? null : _isExchangeListed;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public OtherIndexBuilder setExchange(LegalEntity _exchange) {
            this.exchange = _exchange == null ? null : _exchange.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public OtherIndexBuilder addRelatedExchange(LegalEntity _relatedExchange) {
            if (_relatedExchange != null) {
                this.relatedExchange.add(_relatedExchange.toBuilder());
            }
            return this;
        }

        @Override
        public OtherIndexBuilder addRelatedExchange(LegalEntity _relatedExchange, int idx) {
            this.getIndex(this.relatedExchange, idx, () -> _relatedExchange.toBuilder());
            return this;
        }

        @Override
        public OtherIndexBuilder addRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            if (relatedExchanges != null) {
                for (LegalEntity legalEntity : relatedExchanges) {
                    this.relatedExchange.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedExchange")
        public OtherIndexBuilder setRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            this.relatedExchange = relatedExchanges == null ? new ArrayList() : (List)relatedExchanges.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public OtherIndexBuilder setName(FieldWithMetaString _name) {
            this.name = _name == null ? null : _name.toBuilder();
            return this;
        }

        @Override
        public OtherIndexBuilder setNameValue(String _name) {
            this.getOrCreateName().setValue(_name);
            return this;
        }

        @Override
        @RosettaAttribute(value="provider")
        @RuneAttribute(value="provider")
        public OtherIndexBuilder setProvider(LegalEntity _provider) {
            this.provider = _provider == null ? null : _provider.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public OtherIndexBuilder setAssetClass(AssetClassEnum _assetClass) {
            this.assetClass = _assetClass == null ? null : _assetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public OtherIndexBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        public OtherIndex build() {
            return new OtherIndexImpl(this);
        }

        @Override
        public OtherIndexBuilder toBuilder() {
            return this;
        }

        @Override
        public OtherIndexBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getDescription() != null;
        }

        @Override
        public OtherIndexBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            OtherIndexBuilder o = (OtherIndexBuilder)other;
            merger.mergeBasic((Object)this.getDescription(), (Object)o.getDescription(), this::setDescription, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OtherIndex _that = (OtherIndex)this.getType().cast(o);
            return Objects.equals(this.description, _that.getDescription());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.description != null ? this.description.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OtherIndexBuilder {description=" + this.description + '}' + " " + super.toString();
        }
    }

    public static interface OtherIndexBuilder
    extends OtherIndex,
    IndexBase.IndexBaseBuilder {
        @Override
        public OtherIndexBuilder addIdentifier(AssetIdentifier var1);

        @Override
        public OtherIndexBuilder addIdentifier(AssetIdentifier var1, int var2);

        @Override
        public OtherIndexBuilder addIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public OtherIndexBuilder setIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public OtherIndexBuilder addTaxonomy(Taxonomy var1);

        @Override
        public OtherIndexBuilder addTaxonomy(Taxonomy var1, int var2);

        @Override
        public OtherIndexBuilder addTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public OtherIndexBuilder setTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public OtherIndexBuilder setIsExchangeListed(Boolean var1);

        @Override
        public OtherIndexBuilder setExchange(LegalEntity var1);

        @Override
        public OtherIndexBuilder addRelatedExchange(LegalEntity var1);

        @Override
        public OtherIndexBuilder addRelatedExchange(LegalEntity var1, int var2);

        @Override
        public OtherIndexBuilder addRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public OtherIndexBuilder setRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public OtherIndexBuilder setName(FieldWithMetaString var1);

        @Override
        public OtherIndexBuilder setNameValue(String var1);

        @Override
        public OtherIndexBuilder setProvider(LegalEntity var1);

        @Override
        public OtherIndexBuilder setAssetClass(AssetClassEnum var1);

        public OtherIndexBuilder setDescription(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.AssetIdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.TaxonomyBuilder.class, this.getTaxonomy(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.LegalEntityBuilder.class, (RosettaModelObjectBuilder)this.getExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.LegalEntityBuilder.class, this.getRelatedExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("name"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, (RosettaModelObjectBuilder)this.getName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("provider"), processor, LegalEntity.LegalEntityBuilder.class, (RosettaModelObjectBuilder)this.getProvider(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("assetClass"), AssetClassEnum.class, (Object)this.getAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public OtherIndexBuilder prune();
    }

    public static class OtherIndexImpl
    extends IndexBase.IndexBaseImpl
    implements OtherIndex {
        private final String description;

        protected OtherIndexImpl(OtherIndexBuilder builder) {
            super(builder);
            this.description = builder.getDescription();
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public String getDescription() {
            return this.description;
        }

        @Override
        public OtherIndex build() {
            return this;
        }

        @Override
        public OtherIndexBuilder toBuilder() {
            OtherIndexBuilder builder = OtherIndex.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OtherIndexBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDescription()).ifPresent(builder::setDescription);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OtherIndex _that = (OtherIndex)this.getType().cast(o);
            return Objects.equals(this.description, _that.getDescription());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.description != null ? this.description.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OtherIndex {description=" + this.description + '}' + " " + super.toString();
        }
    }
}

