/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.staticdata.asset.common.AssetBase;
import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.Taxonomy;
import cdm.base.staticdata.party.LegalEntity;
import cdm.observable.asset.meta.IndexBaseMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="IndexBase", builder=IndexBaseBuilderImpl.class, version="6.10.0")
@RuneDataType(value="IndexBase", model="cdm", builder=IndexBaseBuilderImpl.class, version="6.10.0")
public interface IndexBase
extends AssetBase {
    public static final IndexBaseMeta metaData = new IndexBaseMeta();

    public FieldWithMetaString getName();

    public LegalEntity getProvider();

    public AssetClassEnum getAssetClass();

    @Override
    public IndexBase build();

    @Override
    public IndexBaseBuilder toBuilder();

    public static IndexBaseBuilder builder() {
        return new IndexBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends IndexBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends IndexBase> getType() {
        return IndexBase.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.class, this.getTaxonomy(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.class, this.getExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.class, this.getRelatedExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("name"), processor, FieldWithMetaString.class, this.getName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("provider"), processor, LegalEntity.class, this.getProvider(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("assetClass"), AssetClassEnum.class, (Object)this.getAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class IndexBaseBuilderImpl
    extends AssetBase.AssetBaseBuilderImpl
    implements IndexBaseBuilder {
        protected FieldWithMetaString.FieldWithMetaStringBuilder name;
        protected LegalEntity.LegalEntityBuilder provider;
        protected AssetClassEnum assetClass;

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public FieldWithMetaString.FieldWithMetaStringBuilder getName() {
            return this.name;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateName() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.name != null ? this.name : (this.name = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="provider")
        @RuneAttribute(value="provider")
        public LegalEntity.LegalEntityBuilder getProvider() {
            return this.provider;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateProvider() {
            LegalEntity.LegalEntityBuilder result = this.provider != null ? this.provider : (this.provider = LegalEntity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public AssetClassEnum getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="identifier", isRequired=true)
        @RuneAttribute(value="identifier", isRequired=true)
        public IndexBaseBuilder addIdentifier(AssetIdentifier _identifier) {
            if (_identifier != null) {
                this.identifier.add(_identifier.toBuilder());
            }
            return this;
        }

        @Override
        public IndexBaseBuilder addIdentifier(AssetIdentifier _identifier, int idx) {
            this.getIndex(this.identifier, idx, () -> _identifier.toBuilder());
            return this;
        }

        @Override
        public IndexBaseBuilder addIdentifier(List<? extends AssetIdentifier> identifiers) {
            if (identifiers != null) {
                for (AssetIdentifier assetIdentifier : identifiers) {
                    this.identifier.add(assetIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="identifier")
        public IndexBaseBuilder setIdentifier(List<? extends AssetIdentifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="taxonomy")
        @RuneAttribute(value="taxonomy")
        public IndexBaseBuilder addTaxonomy(Taxonomy _taxonomy) {
            if (_taxonomy != null) {
                this.taxonomy.add(_taxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public IndexBaseBuilder addTaxonomy(Taxonomy _taxonomy, int idx) {
            this.getIndex(this.taxonomy, idx, () -> _taxonomy.toBuilder());
            return this;
        }

        @Override
        public IndexBaseBuilder addTaxonomy(List<? extends Taxonomy> taxonomys) {
            if (taxonomys != null) {
                for (Taxonomy taxonomy : taxonomys) {
                    this.taxonomy.add(taxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="taxonomy")
        public IndexBaseBuilder setTaxonomy(List<? extends Taxonomy> taxonomys) {
            this.taxonomy = taxonomys == null ? new ArrayList() : (List)taxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="isExchangeListed")
        @RuneAttribute(value="isExchangeListed")
        public IndexBaseBuilder setIsExchangeListed(Boolean _isExchangeListed) {
            this.isExchangeListed = _isExchangeListed == null ? null : _isExchangeListed;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public IndexBaseBuilder setExchange(LegalEntity _exchange) {
            this.exchange = _exchange == null ? null : _exchange.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public IndexBaseBuilder addRelatedExchange(LegalEntity _relatedExchange) {
            if (_relatedExchange != null) {
                this.relatedExchange.add(_relatedExchange.toBuilder());
            }
            return this;
        }

        @Override
        public IndexBaseBuilder addRelatedExchange(LegalEntity _relatedExchange, int idx) {
            this.getIndex(this.relatedExchange, idx, () -> _relatedExchange.toBuilder());
            return this;
        }

        @Override
        public IndexBaseBuilder addRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            if (relatedExchanges != null) {
                for (LegalEntity legalEntity : relatedExchanges) {
                    this.relatedExchange.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedExchange")
        public IndexBaseBuilder setRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            this.relatedExchange = relatedExchanges == null ? new ArrayList() : (List)relatedExchanges.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public IndexBaseBuilder setName(FieldWithMetaString _name) {
            this.name = _name == null ? null : _name.toBuilder();
            return this;
        }

        @Override
        public IndexBaseBuilder setNameValue(String _name) {
            this.getOrCreateName().setValue(_name);
            return this;
        }

        @Override
        @RosettaAttribute(value="provider")
        @RuneAttribute(value="provider")
        public IndexBaseBuilder setProvider(LegalEntity _provider) {
            this.provider = _provider == null ? null : _provider.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public IndexBaseBuilder setAssetClass(AssetClassEnum _assetClass) {
            this.assetClass = _assetClass == null ? null : _assetClass;
            return this;
        }

        @Override
        public IndexBase build() {
            return new IndexBaseImpl(this);
        }

        @Override
        public IndexBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public IndexBaseBuilder prune() {
            super.prune();
            if (this.name != null && !this.name.prune().hasData()) {
                this.name = null;
            }
            if (this.provider != null && !this.provider.prune().hasData()) {
                this.provider = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getName() != null) {
                return true;
            }
            if (this.getProvider() != null && this.getProvider().hasData()) {
                return true;
            }
            return this.getAssetClass() != null;
        }

        @Override
        public IndexBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            IndexBaseBuilder o = (IndexBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getName(), (RosettaModelObjectBuilder)o.getName(), this::setName);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProvider(), (RosettaModelObjectBuilder)o.getProvider(), this::setProvider);
            merger.mergeBasic((Object)this.getAssetClass(), (Object)o.getAssetClass(), this::setAssetClass, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            IndexBase _that = (IndexBase)this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.provider, _that.getProvider())) {
                return false;
            }
            return Objects.equals((Object)this.assetClass, (Object)_that.getAssetClass());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.provider != null ? this.provider.hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? ((Object)((Object)this.assetClass)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "IndexBaseBuilder {name=" + this.name + ", provider=" + this.provider + ", assetClass=" + (Object)((Object)this.assetClass) + '}' + " " + super.toString();
        }
    }

    public static interface IndexBaseBuilder
    extends IndexBase,
    AssetBase.AssetBaseBuilder {
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateName();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getName();

        public LegalEntity.LegalEntityBuilder getOrCreateProvider();

        @Override
        public LegalEntity.LegalEntityBuilder getProvider();

        @Override
        public IndexBaseBuilder addIdentifier(AssetIdentifier var1);

        @Override
        public IndexBaseBuilder addIdentifier(AssetIdentifier var1, int var2);

        @Override
        public IndexBaseBuilder addIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public IndexBaseBuilder setIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public IndexBaseBuilder addTaxonomy(Taxonomy var1);

        @Override
        public IndexBaseBuilder addTaxonomy(Taxonomy var1, int var2);

        @Override
        public IndexBaseBuilder addTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public IndexBaseBuilder setTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public IndexBaseBuilder setIsExchangeListed(Boolean var1);

        @Override
        public IndexBaseBuilder setExchange(LegalEntity var1);

        @Override
        public IndexBaseBuilder addRelatedExchange(LegalEntity var1);

        @Override
        public IndexBaseBuilder addRelatedExchange(LegalEntity var1, int var2);

        @Override
        public IndexBaseBuilder addRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public IndexBaseBuilder setRelatedExchange(List<? extends LegalEntity> var1);

        public IndexBaseBuilder setName(FieldWithMetaString var1);

        public IndexBaseBuilder setNameValue(String var1);

        public IndexBaseBuilder setProvider(LegalEntity var1);

        public IndexBaseBuilder setAssetClass(AssetClassEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.AssetIdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.TaxonomyBuilder.class, this.getTaxonomy(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.LegalEntityBuilder.class, (RosettaModelObjectBuilder)this.getExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.LegalEntityBuilder.class, this.getRelatedExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("name"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("provider"), processor, LegalEntity.LegalEntityBuilder.class, this.getProvider(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("assetClass"), AssetClassEnum.class, (Object)this.getAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public IndexBaseBuilder prune();
    }

    public static class IndexBaseImpl
    extends AssetBase.AssetBaseImpl
    implements IndexBase {
        private final FieldWithMetaString name;
        private final LegalEntity provider;
        private final AssetClassEnum assetClass;

        protected IndexBaseImpl(IndexBaseBuilder builder) {
            super(builder);
            this.name = Optional.ofNullable(builder.getName()).map(f -> f.build()).orElse(null);
            this.provider = Optional.ofNullable(builder.getProvider()).map(f -> f.build()).orElse(null);
            this.assetClass = builder.getAssetClass();
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public FieldWithMetaString getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="provider")
        @RuneAttribute(value="provider")
        public LegalEntity getProvider() {
            return this.provider;
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public AssetClassEnum getAssetClass() {
            return this.assetClass;
        }

        @Override
        public IndexBase build() {
            return this;
        }

        @Override
        public IndexBaseBuilder toBuilder() {
            IndexBaseBuilder builder = IndexBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(IndexBaseBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
            Optional.ofNullable(this.getProvider()).ifPresent(builder::setProvider);
            Optional.ofNullable(this.getAssetClass()).ifPresent(builder::setAssetClass);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            IndexBase _that = (IndexBase)this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.provider, _that.getProvider())) {
                return false;
            }
            return Objects.equals((Object)this.assetClass, (Object)_that.getAssetClass());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.provider != null ? this.provider.hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? ((Object)((Object)this.assetClass)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "IndexBase {name=" + this.name + ", provider=" + this.provider + ", assetClass=" + (Object)((Object)this.assetClass) + '}' + " " + super.toString();
        }
    }
}

