/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule.validation.datarule;

import cdm.margin.schedule.StandardizedScheduleTradeInfo;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="StandardizedScheduleTradeInfoSameCurrencies")
@ImplementedBy(value=Default.class)
public interface StandardizedScheduleTradeInfoSameCurrencies
extends Validator<StandardizedScheduleTradeInfo> {
    public static final String NAME = "StandardizedScheduleTradeInfoSameCurrencies";
    public static final String DEFINITION = "grossInitialMargin -> unit -> currency = markToMarketValue -> unit -> currency";

    public static class NoOp
    implements StandardizedScheduleTradeInfoSameCurrencies {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, StandardizedScheduleTradeInfo standardizedScheduleTradeInfo) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements StandardizedScheduleTradeInfoSameCurrencies {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, StandardizedScheduleTradeInfo standardizedScheduleTradeInfo) {
            ComparisonResult result = this.executeDataRule(standardizedScheduleTradeInfo);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)StandardizedScheduleTradeInfoSameCurrencies.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"StandardizedScheduleTradeInfo", (RosettaPath)path, (String)StandardizedScheduleTradeInfoSameCurrencies.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)StandardizedScheduleTradeInfoSameCurrencies.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"StandardizedScheduleTradeInfo", (RosettaPath)path, (String)StandardizedScheduleTradeInfoSameCurrencies.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(StandardizedScheduleTradeInfo standardizedScheduleTradeInfo) {
            try {
                return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)standardizedScheduleTradeInfo).map("getGrossInitialMargin", _standardizedScheduleTradeInfo -> _standardizedScheduleTradeInfo.getGrossInitialMargin()).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString0 -> fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()), (Mapper)MapperS.of((Object)standardizedScheduleTradeInfo).map("getMarkToMarketValue", _standardizedScheduleTradeInfo -> _standardizedScheduleTradeInfo.getMarkToMarketValue()).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString1 -> fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue()), (CardinalityOperator)CardinalityOperator.All);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

