/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.event.common.Trade;
import cdm.margin.schedule.StandardizedScheduleAssetClassEnum;
import cdm.margin.schedule.StandardizedScheduleProductClassEnum;
import cdm.margin.schedule.functions.FXFarLeg;
import cdm.margin.schedule.functions.StandardizedScheduleFXSwapNotional;
import cdm.margin.schedule.functions.StandardizedScheduleMonetaryNotionalCurrencyFromResolvablePQ;
import cdm.margin.schedule.functions.UnderlierForProduct;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.template.EconomicTerms;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.NonTransferableProduct;
import cdm.product.template.OptionPayout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import cdm.product.template.SettlementPayout;
import cdm.product.template.TradeLot;
import cdm.product.template.util.ProductDeepPathUtil;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import javax.inject.Inject;

@ImplementedBy(value=StandardizedScheduleNotionalCurrencyDefault.class)
public abstract class StandardizedScheduleNotionalCurrency
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected FXFarLeg fXFarLeg;
    @Inject
    protected ProductDeepPathUtil productDeepPathUtil;
    @Inject
    protected StandardizedScheduleFXSwapNotional standardizedScheduleFXSwapNotional;
    @Inject
    protected StandardizedScheduleMonetaryNotionalCurrencyFromResolvablePQ standardizedScheduleMonetaryNotionalCurrencyFromResolvablePQ;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public String evaluate(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
        String notionalCurrency = this.doEvaluate(trade, assetClass, productClass);
        this.conditionValidator.validate(() -> ExpressionOperators.exists((Mapper)MapperS.of((Object)notionalCurrency).checkedMap("to-enum", ISOCurrencyCodeEnum::fromDisplayName, IllegalArgumentException.class)), "Ensure Currency is an ISO 3-Letter Currency Code ");
        return notionalCurrency;
    }

    protected abstract String doEvaluate(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    protected abstract MapperS<? extends NonTransferableProduct> product(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    protected abstract MapperS<? extends EconomicTerms> economicTerms(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    public static class StandardizedScheduleNotionalCurrencyDefault
    extends StandardizedScheduleNotionalCurrency {
        @Override
        protected String doEvaluate(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            String notionalCurrency = null;
            return this.assignOutput(notionalCurrency, trade, assetClass, productClass);
        }

        protected String assignOutput(String notionalCurrency, Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)assetClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleAssetClassEnum.INTEREST_RATES)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SWAP)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SWAP_WITH_CALLABLE_BERMUDAN_RIGHT_TO_ENTER_EXIT_SWAPS)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperC thenArg0 = this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).filterItemNullSafe(item -> ExpressionOperators.exists((Mapper)item.map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule())).get());
                    MapperS thenArg1 = thenArg0.first();
                    MapperS thenArg2 = thenArg1.map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity());
                    notionalCurrency = (String)MapperS.of((Object)this.standardizedScheduleMonetaryNotionalCurrencyFromResolvablePQ.evaluate((ResolvablePriceQuantity)thenArg2.get())).get();
                } else if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.CROSS_CURRENCY_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperC thenArg3 = this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).filterItemNullSafe(item -> true);
                    MapperS thenArg4 = thenArg3.first();
                    MapperS thenArg5 = thenArg4.map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity());
                    notionalCurrency = (String)MapperS.of((Object)this.standardizedScheduleMonetaryNotionalCurrencyFromResolvablePQ.evaluate((ResolvablePriceQuantity)thenArg5.get())).get();
                } else if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SWAPTION)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SWAPTION_STRADDLE)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperC thenArg6 = MapperS.of((Object)this.underlierForProduct.evaluate((NonTransferableProduct)this.product(trade, assetClass, productClass).get())).map("getProduct", underlier -> underlier.getProduct()).map("chooseEconomicTerms", _product -> this.productDeepPathUtil.chooseEconomicTerms((Product)_product)).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).filterItemNullSafe(item -> ExpressionOperators.exists((Mapper)item.map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule())).get());
                    MapperS thenArg7 = thenArg6.first();
                    MapperS thenArg8 = thenArg7.map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity());
                    notionalCurrency = (String)MapperS.of((Object)this.standardizedScheduleMonetaryNotionalCurrencyFromResolvablePQ.evaluate((ResolvablePriceQuantity)thenArg8.get())).get();
                } else if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperS thenArg9 = MapperS.of((Object)((InterestRatePayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get())).map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity());
                    notionalCurrency = (String)MapperS.of((Object)this.standardizedScheduleMonetaryNotionalCurrencyFromResolvablePQ.evaluate((ResolvablePriceQuantity)thenArg9.get())).get();
                } else if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.FORWARD_RATE_AGREEMENT)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperC thenArg10 = this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).filterItemNullSafe(item -> ExpressionOperators.exists((Mapper)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRateSpecification", rateSpecification -> rateSpecification.getFixedRateSpecification())).get());
                    MapperS thenArg11 = MapperS.of((Object)((InterestRatePayout)thenArg10.get()));
                    MapperS thenArg12 = thenArg11.map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity());
                    notionalCurrency = (String)MapperS.of((Object)this.standardizedScheduleMonetaryNotionalCurrencyFromResolvablePQ.evaluate((ResolvablePriceQuantity)thenArg12.get())).get();
                } else {
                    notionalCurrency = null;
                }
            } else if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)assetClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleAssetClassEnum.CREDIT)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SINGLE_NAME_CREDIT_DEFAULT_SWAP)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.INDEX_CDS)), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.INDEX_TRANCHE)), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.CREDIT_NTH_TO_DEFAULT)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperS thenArg13 = MapperS.of((Object)((CreditDefaultPayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).get())).map("getPriceQuantity", creditDefaultPayout -> creditDefaultPayout.getPriceQuantity());
                    notionalCurrency = (String)MapperS.of((Object)this.standardizedScheduleMonetaryNotionalCurrencyFromResolvablePQ.evaluate((ResolvablePriceQuantity)thenArg13.get())).get();
                } else if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SWAPTION)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperS thenArg14 = MapperS.of((Object)((CreditDefaultPayout)MapperS.of((Object)this.underlierForProduct.evaluate((NonTransferableProduct)this.product(trade, assetClass, productClass).get())).map("getProduct", underlier -> underlier.getProduct()).map("chooseEconomicTerms", _product -> this.productDeepPathUtil.chooseEconomicTerms((Product)_product)).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).get())).map("getPriceQuantity", creditDefaultPayout -> creditDefaultPayout.getPriceQuantity());
                    notionalCurrency = (String)MapperS.of((Object)this.standardizedScheduleMonetaryNotionalCurrencyFromResolvablePQ.evaluate((ResolvablePriceQuantity)thenArg14.get())).get();
                } else {
                    notionalCurrency = null;
                }
            } else {
                FieldWithMetaString fieldWithMetaString12;
                FieldWithMetaString fieldWithMetaString11;
                FieldWithMetaString fieldWithMetaString10;
                FieldWithMetaString fieldWithMetaString9;
                FieldWithMetaString fieldWithMetaString8;
                FieldWithMetaString fieldWithMetaString7;
                FieldWithMetaString fieldWithMetaString6;
                FieldWithMetaString fieldWithMetaString5;
                FieldWithMetaString fieldWithMetaString4;
                FieldWithMetaString fieldWithMetaString3;
                FieldWithMetaString fieldWithMetaString2;
                FieldWithMetaString fieldWithMetaString1;
                FieldWithMetaString fieldWithMetaString0;
                notionalCurrency = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)assetClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleAssetClassEnum.FOREIGN_EXCHANGE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.DELIVERABLE_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((fieldWithMetaString0 = (FieldWithMetaString)MapperS.of((Object)this.standardizedScheduleFXSwapNotional.evaluate(this.fXFarLeg.evaluate((NonTransferableProduct)this.product(trade, assetClass, productClass).get()), (TradeLot)MapperS.of((Object)trade).mapC("getTradeLot", _trade -> _trade.getTradeLot()).get())).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get()) == null ? null : fieldWithMetaString0.getValue()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.NON_DELIVERABLE_CROSS_CURRENCY_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? "AAA" : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.DELIVERABLE_FORWARD)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((fieldWithMetaString1 = (FieldWithMetaString)MapperS.of((Object)((SettlementPayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getSettlementPayout", payout -> payout.getSettlementPayout()).get())).map("getPriceQuantity", settlementPayout -> settlementPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get()) == null ? null : fieldWithMetaString1.getValue()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.NON_DELIVERABLE_FORWARD)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((fieldWithMetaString2 = (FieldWithMetaString)MapperS.of((Object)((SettlementPayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getSettlementPayout", payout -> payout.getSettlementPayout()).get())).map("getPriceQuantity", settlementPayout -> settlementPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get()) == null ? null : fieldWithMetaString2.getValue()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.DELIVERABLE_OPTION)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((fieldWithMetaString3 = (FieldWithMetaString)MapperS.of((Object)((OptionPayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule2 -> referenceWithMetaNonNegativeQuantitySchedule2 == null ? null : referenceWithMetaNonNegativeQuantitySchedule2.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get()) == null ? null : fieldWithMetaString3.getValue()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.NON_DELIVERABLE_OPTION)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((fieldWithMetaString4 = (FieldWithMetaString)MapperS.of((Object)((OptionPayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule3 -> referenceWithMetaNonNegativeQuantitySchedule3 == null ? null : referenceWithMetaNonNegativeQuantitySchedule3.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get()) == null ? null : fieldWithMetaString4.getValue()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.VARIANCE_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((fieldWithMetaString5 = (FieldWithMetaString)MapperS.of((Object)((PerformancePayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getReturnTerms", performancePayout -> performancePayout.getReturnTerms()).map("getVarianceReturnTerms", returnTerms -> returnTerms.getVarianceReturnTerms()).map("getVarianceStrikePrice", varianceReturnTerms -> varianceReturnTerms.getVarianceStrikePrice()).map("getUnit", price -> price.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get()) == null ? null : fieldWithMetaString5.getValue()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.VOLATILITY_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? "AAA" : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.CORRELATION_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? "AAA" : null))))))))) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)assetClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleAssetClassEnum.EQUITY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((fieldWithMetaString6 = (FieldWithMetaString)MapperS.of((Object)((OptionPayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getStrike", optionPayout -> optionPayout.getStrike()).map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice()).map("getUnit", price -> price.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get()) == null ? null : fieldWithMetaString6.getValue()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.FORWARD)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((fieldWithMetaString7 = (FieldWithMetaString)MapperS.of((Object)((SettlementPayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getSettlementPayout", payout -> payout.getSettlementPayout()).get())).map("getPriceQuantity", settlementPayout -> settlementPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule4 -> referenceWithMetaNonNegativeQuantitySchedule4 == null ? null : referenceWithMetaNonNegativeQuantitySchedule4.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get()) == null ? null : fieldWithMetaString7.getValue()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.DIVIDEND_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? "AAA" : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.VARIANCE_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((fieldWithMetaString8 = (FieldWithMetaString)MapperS.of((Object)((PerformancePayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getReturnTerms", performancePayout -> performancePayout.getReturnTerms()).map("getVarianceReturnTerms", returnTerms -> returnTerms.getVarianceReturnTerms()).map("getVolatilityStrikePrice", varianceReturnTerms -> varianceReturnTerms.getVolatilityStrikePrice()).map("getUnit", price -> price.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get()) == null ? null : fieldWithMetaString8.getValue()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.VOLATILITY_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? "AAA" : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SWAPS_AND_PORTFOLIO_SWAPS)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? "AAA" : null)))))) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)assetClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleAssetClassEnum.COMMODITY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.FORWARD)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((fieldWithMetaString9 = (FieldWithMetaString)MapperS.of((Object)((FixedPricePayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get())).map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).map("getPrice", fixedPrice -> fixedPrice.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule0 -> referenceWithMetaPriceSchedule0 == null ? null : referenceWithMetaPriceSchedule0.getValue()).map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get()) == null ? null : fieldWithMetaString9.getValue()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((fieldWithMetaString10 = (FieldWithMetaString)MapperS.of((Object)((OptionPayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getStrike", optionPayout -> optionPayout.getStrike()).map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice()).map("getUnit", price -> price.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get()) == null ? null : fieldWithMetaString10.getValue()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.FIXED_FLOAT_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((fieldWithMetaString11 = (FieldWithMetaString)MapperS.of((Object)((FixedPricePayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get())).map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).map("getPrice", fixedPrice -> fixedPrice.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule1 -> referenceWithMetaPriceSchedule1 == null ? null : referenceWithMetaPriceSchedule1.getValue()).map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get()) == null ? null : fieldWithMetaString11.getValue()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.BASIS_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? "AAA" : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SWAPTION)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((fieldWithMetaString12 = (FieldWithMetaString)MapperS.of((Object)((FixedPricePayout)MapperS.of((Object)this.underlierForProduct.evaluate((NonTransferableProduct)this.product(trade, assetClass, productClass).get())).map("getProduct", underlier -> underlier.getProduct()).map("chooseEconomicTerms", _product -> this.productDeepPathUtil.chooseEconomicTerms((Product)_product)).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get())).map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).map("getPrice", fixedPrice -> fixedPrice.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule2 -> referenceWithMetaPriceSchedule2 == null ? null : referenceWithMetaPriceSchedule2.getValue()).map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get()) == null ? null : fieldWithMetaString12.getValue()) : null))))) : null));
            }
            return notionalCurrency;
        }

        @Override
        protected MapperS<? extends NonTransferableProduct> product(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            return MapperS.of((Object)trade).map("getProduct", _trade -> _trade.getProduct());
        }

        @Override
        protected MapperS<? extends EconomicTerms> economicTerms(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            return this.product(trade, assetClass, productClass).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms());
        }
    }
}

