/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.template.EconomicTerms;
import cdm.product.template.FixedPricePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

@ImplementedBy(value=StandardizedScheduleCommoditySwapFixedFloatNotionalAmountDefault.class)
public abstract class StandardizedScheduleCommoditySwapFixedFloatNotionalAmount
implements RosettaFunction {
    public BigDecimal evaluate(EconomicTerms economicTerms) {
        BigDecimal amount = this.doEvaluate(economicTerms);
        return amount;
    }

    protected abstract BigDecimal doEvaluate(EconomicTerms var1);

    protected abstract MapperS<BigDecimal> fixedPrice(EconomicTerms var1);

    protected abstract MapperS<BigDecimal> notionalQuantity(EconomicTerms var1);

    public static class StandardizedScheduleCommoditySwapFixedFloatNotionalAmountDefault
    extends StandardizedScheduleCommoditySwapFixedFloatNotionalAmount {
        @Override
        protected BigDecimal doEvaluate(EconomicTerms economicTerms) {
            BigDecimal amount = null;
            return this.assignOutput(amount, economicTerms);
        }

        protected BigDecimal assignOutput(BigDecimal amount, EconomicTerms economicTerms) {
            amount = (BigDecimal)MapperMaths.multiply(this.fixedPrice(economicTerms), this.notionalQuantity(economicTerms)).get();
            return amount;
        }

        @Override
        protected MapperS<BigDecimal> fixedPrice(EconomicTerms economicTerms) {
            return MapperS.of((Object)((FixedPricePayout)MapperS.of((Object)economicTerms).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get())).map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).map("getPrice", _fixedPrice -> _fixedPrice.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule == null ? null : referenceWithMetaPriceSchedule.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue());
        }

        @Override
        protected MapperS<BigDecimal> notionalQuantity(EconomicTerms economicTerms) {
            MapperS thenArg = MapperS.of((Object)((CommodityPayout)MapperS.of((Object)economicTerms).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getCommodityPayout", payout -> payout.getCommodityPayout()).get())).map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
            MapperS ifThenElseResult = ExpressionOperators.exists((Mapper)thenArg.map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier())).getOrDefault(Boolean.valueOf(false)) != false ? MapperMaths.multiply((Mapper)thenArg.map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), (Mapper)thenArg.map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule2 -> referenceWithMetaNonNegativeQuantitySchedule2 == null ? null : referenceWithMetaNonNegativeQuantitySchedule2.getValue()).map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier()).map("getValue", measure -> measure.getValue())) : thenArg.map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule3 -> referenceWithMetaNonNegativeQuantitySchedule3 == null ? null : referenceWithMetaNonNegativeQuantitySchedule3.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue());
            return ifThenElseResult;
        }
    }
}

