/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule.functions;

import cdm.event.common.Trade;
import cdm.margin.schedule.StandardizedScheduleAssetClassEnum;
import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_AssetClass_ForeignExchange;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.template.EconomicTerms;
import cdm.product.template.NonTransferableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import javax.inject.Inject;

@ImplementedBy(value=StandardizedScheduleAssetClassDefault.class)
public abstract class StandardizedScheduleAssetClass
implements RosettaFunction {
    @Inject
    protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
    @Inject
    protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;
    @Inject
    protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
    @Inject
    protected Qualify_AssetClass_ForeignExchange qualify_AssetClass_ForeignExchange;
    @Inject
    protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;

    public StandardizedScheduleAssetClassEnum evaluate(Trade trade) {
        StandardizedScheduleAssetClassEnum assetClass = this.doEvaluate(trade);
        return assetClass;
    }

    protected abstract StandardizedScheduleAssetClassEnum doEvaluate(Trade var1);

    protected abstract MapperS<? extends NonTransferableProduct> product(Trade var1);

    protected abstract MapperS<? extends EconomicTerms> economicTerms(Trade var1);

    public static class StandardizedScheduleAssetClassDefault
    extends StandardizedScheduleAssetClass {
        @Override
        protected StandardizedScheduleAssetClassEnum doEvaluate(Trade trade) {
            StandardizedScheduleAssetClassEnum assetClass = null;
            return this.assignOutput(assetClass, trade);
        }

        protected StandardizedScheduleAssetClassEnum assignOutput(StandardizedScheduleAssetClassEnum assetClass, Trade trade) {
            Boolean boolean4;
            Boolean boolean3;
            Boolean boolean2;
            Boolean boolean1;
            Boolean boolean0 = this.qualify_AssetClass_InterestRate.evaluate((EconomicTerms)this.economicTerms(trade).get());
            assetClass = boolean0 != null && boolean0 != false ? StandardizedScheduleAssetClassEnum.INTEREST_RATES : ((boolean1 = this.qualify_AssetClass_Credit.evaluate((EconomicTerms)this.economicTerms(trade).get())) != null && boolean1 != false ? StandardizedScheduleAssetClassEnum.CREDIT : ((boolean2 = this.qualify_AssetClass_ForeignExchange.evaluate((EconomicTerms)this.economicTerms(trade).get())) != null && boolean2 != false ? StandardizedScheduleAssetClassEnum.FOREIGN_EXCHANGE : ((boolean3 = this.qualify_AssetClass_Equity.evaluate((EconomicTerms)this.economicTerms(trade).get())) != null && boolean3 != false ? StandardizedScheduleAssetClassEnum.EQUITY : ((boolean4 = this.qualify_AssetClass_Commodity.evaluate((EconomicTerms)this.economicTerms(trade).get())) != null && boolean4 != false ? StandardizedScheduleAssetClassEnum.COMMODITY : null))));
            return assetClass;
        }

        @Override
        protected MapperS<? extends NonTransferableProduct> product(Trade trade) {
            return MapperS.of((Object)trade).map("getProduct", _trade -> _trade.getProduct());
        }

        @Override
        protected MapperS<? extends EconomicTerms> economicTerms(Trade trade) {
            return this.product(trade).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms());
        }
    }
}

