/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule.functions;

import cdm.margin.schedule.StandardizedSchedule;
import cdm.margin.schedule.StandardizedScheduleAssetClassEnum;
import cdm.margin.schedule.functions.GetStandardizedScheduleMarginRate;
import cdm.observable.asset.Money;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetGrossInitialMarginFromStandardizedScheduleDefault.class)
public abstract class GetGrossInitialMarginFromStandardizedSchedule
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected GetStandardizedScheduleMarginRate getStandardizedScheduleMarginRate;

    public Money evaluate(StandardizedSchedule standardizedSchedule) {
        Money grossInitialMargin;
        Money.MoneyBuilder grossInitialMarginBuilder = this.doEvaluate(standardizedSchedule);
        if (grossInitialMarginBuilder == null) {
            grossInitialMargin = null;
        } else {
            grossInitialMargin = grossInitialMarginBuilder.build();
            this.objectValidator.validate(Money.class, (RosettaModelObject)grossInitialMargin);
        }
        this.conditionValidator.validate(() -> ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)grossInitialMargin).map("getValue", money -> money.getValue()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All), "Ensure gross initial margin is greater than 0");
        return grossInitialMargin;
    }

    protected abstract Money.MoneyBuilder doEvaluate(StandardizedSchedule var1);

    protected abstract MapperS<BigDecimal> initialMarginRequirement(StandardizedSchedule var1);

    public static class GetGrossInitialMarginFromStandardizedScheduleDefault
    extends GetGrossInitialMarginFromStandardizedSchedule {
        @Override
        protected Money.MoneyBuilder doEvaluate(StandardizedSchedule standardizedSchedule) {
            Money.MoneyBuilder grossInitialMargin = Money.builder();
            return this.assignOutput(grossInitialMargin, standardizedSchedule);
        }

        protected Money.MoneyBuilder assignOutput(Money.MoneyBuilder grossInitialMargin, StandardizedSchedule standardizedSchedule) {
            grossInitialMargin.setValue((BigDecimal)MapperMaths.multiply((Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)standardizedSchedule).map("getNotional", _standardizedSchedule -> _standardizedSchedule.getNotional()), this.initialMarginRequirement(standardizedSchedule)), (Mapper)MapperS.of((Object)new BigDecimal("0.01"))).get());
            String string = (String)MapperS.of((Object)standardizedSchedule).map("getNotionalCurrency", _standardizedSchedule -> _standardizedSchedule.getNotionalCurrency()).get();
            grossInitialMargin.getOrCreateUnit().setCurrency(string == null ? FieldWithMetaString.builder().build() : FieldWithMetaString.builder().setValue(string).build());
            return Optional.ofNullable(grossInitialMargin).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<BigDecimal> initialMarginRequirement(StandardizedSchedule standardizedSchedule) {
            return MapperS.of((Object)this.getStandardizedScheduleMarginRate.evaluate((StandardizedScheduleAssetClassEnum)((Object)MapperS.of((Object)standardizedSchedule).map("getAssetClass", _standardizedSchedule -> _standardizedSchedule.getAssetClass()).get()), (BigDecimal)MapperS.of((Object)standardizedSchedule).map("getDurationInYears", _standardizedSchedule -> _standardizedSchedule.getDurationInYears()).get()));
        }
    }
}

