/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule.functions;

import cdm.event.common.Trade;
import cdm.margin.schedule.StandardizedSchedule;
import cdm.margin.schedule.StandardizedScheduleAssetClassEnum;
import cdm.margin.schedule.StandardizedScheduleProductClassEnum;
import cdm.margin.schedule.functions.StandardizedScheduleAssetClass;
import cdm.margin.schedule.functions.StandardizedScheduleDuration;
import cdm.margin.schedule.functions.StandardizedScheduleNotional;
import cdm.margin.schedule.functions.StandardizedScheduleNotionalCurrency;
import cdm.margin.schedule.functions.StandardizedScheduleProductClass;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=BuildStandardizedScheduleDefault.class)
public abstract class BuildStandardizedSchedule
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected StandardizedScheduleAssetClass standardizedScheduleAssetClass;
    @Inject
    protected StandardizedScheduleDuration standardizedScheduleDuration;
    @Inject
    protected StandardizedScheduleNotional standardizedScheduleNotional;
    @Inject
    protected StandardizedScheduleNotionalCurrency standardizedScheduleNotionalCurrency;
    @Inject
    protected StandardizedScheduleProductClass standardizedScheduleProductClass;

    public StandardizedSchedule evaluate(Trade trade) {
        StandardizedSchedule standardizedSchedule;
        StandardizedSchedule.StandardizedScheduleBuilder standardizedScheduleBuilder = this.doEvaluate(trade);
        if (standardizedScheduleBuilder == null) {
            standardizedSchedule = null;
        } else {
            standardizedSchedule = standardizedScheduleBuilder.build();
            this.objectValidator.validate(StandardizedSchedule.class, (RosettaModelObject)standardizedSchedule);
        }
        return standardizedSchedule;
    }

    protected abstract StandardizedSchedule.StandardizedScheduleBuilder doEvaluate(Trade var1);

    protected abstract MapperS<StandardizedScheduleAssetClassEnum> assetClass(Trade var1);

    protected abstract MapperS<StandardizedScheduleProductClassEnum> productClass(Trade var1);

    public static class BuildStandardizedScheduleDefault
    extends BuildStandardizedSchedule {
        @Override
        protected StandardizedSchedule.StandardizedScheduleBuilder doEvaluate(Trade trade) {
            StandardizedSchedule.StandardizedScheduleBuilder standardizedSchedule = StandardizedSchedule.builder();
            return this.assignOutput(standardizedSchedule, trade);
        }

        protected StandardizedSchedule.StandardizedScheduleBuilder assignOutput(StandardizedSchedule.StandardizedScheduleBuilder standardizedSchedule, Trade trade) {
            standardizedSchedule.setAssetClass((StandardizedScheduleAssetClassEnum)((Object)this.assetClass(trade).get()));
            standardizedSchedule.setProductClass((StandardizedScheduleProductClassEnum)((Object)this.productClass(trade).get()));
            standardizedSchedule.setNotional(this.standardizedScheduleNotional.evaluate(trade, (StandardizedScheduleAssetClassEnum)((Object)this.assetClass(trade).get()), (StandardizedScheduleProductClassEnum)((Object)this.productClass(trade).get())));
            standardizedSchedule.setNotionalCurrency(this.standardizedScheduleNotionalCurrency.evaluate(trade, (StandardizedScheduleAssetClassEnum)((Object)this.assetClass(trade).get()), (StandardizedScheduleProductClassEnum)((Object)this.productClass(trade).get())));
            standardizedSchedule.setDurationInYears(this.standardizedScheduleDuration.evaluate(trade, (StandardizedScheduleAssetClassEnum)((Object)this.assetClass(trade).get()), (StandardizedScheduleProductClassEnum)((Object)this.productClass(trade).get())));
            return Optional.ofNullable(standardizedSchedule).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<StandardizedScheduleAssetClassEnum> assetClass(Trade trade) {
            return MapperS.of((Object)((Object)this.standardizedScheduleAssetClass.evaluate(trade)));
        }

        @Override
        protected MapperS<StandardizedScheduleProductClassEnum> productClass(Trade trade) {
            return MapperS.of((Object)((Object)this.standardizedScheduleProductClass.evaluate(trade)));
        }
    }
}

