/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.validation.datarule;

import cdm.legaldocumentation.csa.SimmVersion;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="SimmVersionVersionNotSpecified")
@ImplementedBy(value=Default.class)
public interface SimmVersionVersionNotSpecified
extends Validator<SimmVersion> {
    public static final String NAME = "SimmVersionVersionNotSpecified";
    public static final String DEFINITION = "if isSpecified = False then partyVersion is absent";

    public static class NoOp
    implements SimmVersionVersionNotSpecified {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SimmVersion simmVersion) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements SimmVersionVersionNotSpecified {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SimmVersion simmVersion) {
            ComparisonResult result = this.executeDataRule(simmVersion);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)SimmVersionVersionNotSpecified.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SimmVersion", (RosettaPath)path, (String)SimmVersionVersionNotSpecified.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)SimmVersionVersionNotSpecified.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SimmVersion", (RosettaPath)path, (String)SimmVersionVersionNotSpecified.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(SimmVersion simmVersion) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)simmVersion).map("getIsSpecified", _simmVersion -> _simmVersion.getIsSpecified()), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.notExists((Mapper)MapperS.of((Object)simmVersion).map("getPartyVersion", _simmVersion -> _simmVersion.getPartyVersion()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

