/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.validation.datarule;

import cdm.legaldocumentation.csa.LegacyValuationDate;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="LegacyValuationDateAdditionalLanguage")
@ImplementedBy(value=Default.class)
public interface LegacyValuationDateAdditionalLanguage
extends Validator<LegacyValuationDate> {
    public static final String NAME = "LegacyValuationDateAdditionalLanguage";
    public static final String DEFINITION = "if date is absent or frequency is absent then additionalLanguage exists";

    public static class NoOp
    implements LegacyValuationDateAdditionalLanguage {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LegacyValuationDate legacyValuationDate) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements LegacyValuationDateAdditionalLanguage {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LegacyValuationDate legacyValuationDate) {
            ComparisonResult result = this.executeDataRule(legacyValuationDate);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)LegacyValuationDateAdditionalLanguage.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegacyValuationDate", (RosettaPath)path, (String)LegacyValuationDateAdditionalLanguage.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)LegacyValuationDateAdditionalLanguage.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegacyValuationDate", (RosettaPath)path, (String)LegacyValuationDateAdditionalLanguage.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(LegacyValuationDate legacyValuationDate) {
            try {
                if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)legacyValuationDate).map("getDate", _legacyValuationDate -> _legacyValuationDate.getDate())).or(ExpressionOperators.notExists((Mapper)MapperS.of((Object)legacyValuationDate).map("getFrequency", _legacyValuationDate -> _legacyValuationDate.getFrequency()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)legacyValuationDate).map("getAdditionalLanguage", _legacyValuationDate -> _legacyValuationDate.getAdditionalLanguage()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

