/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.processor;

import cdm.base.datetime.CustomisableOffset;
import cdm.base.datetime.DayTypeEnum;
import cdm.base.datetime.Offset;
import cdm.base.datetime.PeriodEnum;
import cdm.legaldocumentation.csa.CustodianEventEndDate;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.List;
import java.util.Optional;
import org.isda.cdm.processor.CreateiQMappingProcessorUtils;

public class CustodianEventEndDateMappingProcessor
extends MappingProcessor {
    public CustodianEventEndDateMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext mappingContext) {
        super(modelPath, synonymPaths, mappingContext);
    }

    public void map(Path synonymPath, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent) {
        CustodianEventEndDate.CustodianEventEndDateBuilder endDateBuilder = (CustodianEventEndDate.CustodianEventEndDateBuilder)builder;
        this.getCustomisableOffset(synonymPath, "days_after_custodian_event", "after_days", true, "after_days_type", "after_specify").ifPresent(endDateBuilder::setDaysAfterCustodianEvent);
        this.getCustomisableOffset(synonymPath, "days_after_collateral_manager_event", "after_days", true, "after_days_type", "after_specify").ifPresent(endDateBuilder::setDaysAfterCustodianEvent);
        this.getCustomisableOffset(synonymPath, "days_after_euroclear_event", "after_days", true, "after_days_type", "after_specify").ifPresent(endDateBuilder::setDaysAfterCustodianEvent);
        this.getCustomisableOffset(synonymPath, "days_after_clearstream_event", "after_days", true, "after_days_type", "after_specify").ifPresent(endDateBuilder::setDaysAfterCustodianEvent);
        this.getCustomisableOffset(synonymPath, "days_after_clearstream_event", "after_days", true, "after_days_type", "specify_after_days").ifPresent(endDateBuilder::setDaysAfterCustodianEvent);
        this.getCustomisableOffset(synonymPath, "release_date", "release_days", true, "release_days_type", "release_specify").ifPresent(endDateBuilder::setReleaseDate);
        this.getCustomisableOffset(synonymPath, "release_date_i", "release_i_days", true, "release_date_i_type", "release_i_specify").ifPresent(endDateBuilder::setReleaseDate);
        this.getCustomisableOffset(synonymPath, "release_date_ii", "release_date_ii_days", true, "release_date_ii_type", "release_date_ii_specify").ifPresent(endDateBuilder::setSafekeepingPeriodExpiry);
        this.getCustomisableOffset(synonymPath, "release_date_ii", "release_ii_days", true, "release_date_ii_type", "specify_release_date_ii").ifPresent(endDateBuilder::setSafekeepingPeriodExpiry);
        this.getCustomisableOffset(synonymPath, "date_of_timely_statement", "days_prior_to_release_date", false, "days_prior_to_release_date_type", "timely_specify").ifPresent(endDateBuilder::setDateOfTimelyStatement);
        this.getCustomisableOffset(synonymPath, "date_of_timely_statement", "timely_days", false, "timely_days_type", "timely_specify").ifPresent(endDateBuilder::setDateOfTimelyStatement);
        this.getCustomisableOffset(synonymPath, "date_of_timely_statement", "days_after_timely_statement", true, "days_after_timely_statement_type", "timely_specify").ifPresent(endDateBuilder::setDateOfTimelyStatement);
    }

    private Optional<CustomisableOffset> getCustomisableOffset(Path synonymPath, String endDateTypeSynonym, String numberOfDaysSynonym, boolean after, String dayTypeSynonym, String customEndDateSynonym) {
        CustomisableOffset.CustomisableOffsetBuilder customisableOffsetBuilder = CustomisableOffset.builder();
        this.setValueAndUpdateMappings(synonymPath.addElement(endDateTypeSynonym), type -> {
            switch (type) {
                case "days": {
                    this.getOffset(synonymPath, numberOfDaysSynonym, after, dayTypeSynonym, customEndDateSynonym, customisableOffsetBuilder);
                    break;
                }
                case "other": {
                    this.setValueAndUpdateMappings(synonymPath.addElement(customEndDateSynonym), value -> customisableOffsetBuilder.setCustomProvision(CreateiQMappingProcessorUtils.removeHtml(value)));
                }
            }
        });
        return customisableOffsetBuilder.hasData() ? Optional.of(customisableOffsetBuilder.build()) : Optional.empty();
    }

    private void getOffset(Path basePath, String numberOfDaysSynonym, boolean after, String dayTypeSynonym, String customEndDateSynonym, CustomisableOffset.CustomisableOffsetBuilder customisableOffsetBuilder) {
        Offset.OffsetBuilder offsetBuilder = Offset.builder();
        Path numberOfDaysPath = basePath.addElement(numberOfDaysSynonym);
        Optional numberOfDaysValue = MappingProcessorUtils.getNonNullMappedValue((Path)numberOfDaysPath, (List)this.getMappings());
        if (!numberOfDaysValue.isPresent()) {
            return;
        }
        this.setValueAndUpdateMappings(numberOfDaysPath, value -> {
            int numberOfDays = Integer.parseInt(value);
            offsetBuilder.setPeriodMultiplier(after ? numberOfDays : -numberOfDays);
            offsetBuilder.setPeriod(PeriodEnum.D);
        });
        MappingProcessorUtils.setValueAndOptionallyUpdateMappings((Path)basePath.addElement(dayTypeSynonym), value -> {
            if ("other".equals(value)) {
                this.setValueAndUpdateMappings(basePath.addElement(customEndDateSynonym), customEndDate -> customisableOffsetBuilder.setCustomProvision(CreateiQMappingProcessorUtils.removeHtml(customEndDate)));
                return true;
            }
            Optional dayType = this.getSynonymToEnumMap().getEnumValueOptional(DayTypeEnum.class, value);
            dayType.ifPresent(offsetBuilder::setDayType);
            return dayType.isPresent();
        }, (List)this.getMappings(), (RosettaPath)this.getModelPath());
        if (offsetBuilder.hasData()) {
            customisableOffsetBuilder.setOffset(offsetBuilder);
        }
    }
}

