/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.processor;

import cdm.legaldocumentation.csa.ControlAgreement;
import cdm.legaldocumentation.csa.ControlAgreementElections;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.List;
import java.util.Optional;
import org.isda.cdm.processor.CreateiQMappingProcessorUtils;

public class ControlAgreementMappingProcessor
extends MappingProcessor {
    public ControlAgreementMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext mappingContext) {
        super(modelPath, synonymPaths, mappingContext);
    }

    public void map(Path synonymPath, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent) {
        ControlAgreement.ControlAgreementBuilder controlAgreementBuilder = (ControlAgreement.ControlAgreementBuilder)builder;
        CreateiQMappingProcessorUtils.PARTIES.forEach(party -> this.getControlAgreementElection(synonymPath, (String)party).ifPresent(controlAgreementBuilder::addPartyElection));
    }

    private Optional<ControlAgreementElections> getControlAgreementElection(Path synonymPath, String party) {
        ControlAgreementElections.ControlAgreementElectionsBuilder controlAgreementElections = ControlAgreementElections.builder();
        this.setValueAndUpdateMappings(synonymPath.addElement(party + "_" + synonymPath.getLastElement().getPathName()), value -> {
            controlAgreementElections.setParty(CreateiQMappingProcessorUtils.toCounterpartyRoleEnum(party));
            this.yesNoToBoolean((String)value).ifPresent(controlAgreementElections::setControlAgreementAsCsd);
        });
        this.setValueAndUpdateMappings(String.format("answers.partyA.inconsistency_with_the_control_agreement.%s_inconsistency_with_the_control_agreement", party), value -> this.applicableToBoolean((String)value).ifPresent(applicable -> {
            controlAgreementElections.setConsistencyWithControlAgreement((Boolean)applicable);
            MappingProcessorUtils.updateMappings((Path)Path.parse((String)"answers.partyA.inconsistency_with_the_control_agreement"), (List)this.getMappings(), (RosettaPath)this.getModelPath());
        }));
        this.setValueAndUpdateMappings(String.format("answers.partyA.relationship_with_the_control_agreement.%s_control_agreement_relationship", party), value -> this.applicableToBoolean((String)value).ifPresent(controlAgreementElections::setRelationshipWithControlAgreement));
        return controlAgreementElections.hasData() ? Optional.of(controlAgreementElections.build()) : Optional.empty();
    }

    private Optional<Boolean> yesNoToBoolean(String yesNo) {
        if ("yes".equals(yesNo)) {
            return Optional.of(true);
        }
        if ("no".equals(yesNo)) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    private Optional<Boolean> applicableToBoolean(String applicable) {
        if ("applicable".equals(applicable)) {
            return Optional.of(true);
        }
        if ("not_applicable".equals(applicable)) {
            return Optional.of(false);
        }
        return Optional.empty();
    }
}

