/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="CreditSupportAmountEnum")
public enum CreditSupportAmountEnum {
    STANDARD("Standard", "Standard"),
    IA_FLOOR_GIA("IAFloorGIA", "Non-Standard - IA Floor (Less GiverIA)"),
    IA_FLOOR_GIATIA("IAFloorGIATIA", "Non-Standard - IA Floor (Less GiverIA and TakerIA)"),
    NON_STANDARD_RATINGS("NonStandardRatings", "Non-Standard - Ratings"),
    NON_STANDARD_OTHER("NonStandardOther", "Non-Standard - Other");

    private static Map<String, CreditSupportAmountEnum> values;
    private final String rosettaName;
    private final String displayName;

    private CreditSupportAmountEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static CreditSupportAmountEnum fromDisplayName(String name) {
        CreditSupportAmountEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, CreditSupportAmountEnum> map = new ConcurrentHashMap<String, CreditSupportAmountEnum>();
        for (CreditSupportAmountEnum instance : CreditSupportAmountEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

