/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.base.math.UnitType;
import cdm.event.common.EventIntentEnum;
import cdm.event.common.QuantityChangeInstruction;
import cdm.event.common.TradeState;
import cdm.event.common.metafields.ReferenceWithMetaTradeState;
import cdm.event.workflow.EventInstruction;
import cdm.observable.asset.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ResolveRepurchaseTransferInstructionDefault.class)
public abstract class ResolveRepurchaseTransferInstruction
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public EventInstruction evaluate(TradeState tradeState, Date repurchaseDate) {
        EventInstruction repurchaseInstruction;
        EventInstruction.EventInstructionBuilder repurchaseInstructionBuilder = this.doEvaluate(tradeState, repurchaseDate);
        if (repurchaseInstructionBuilder == null) {
            repurchaseInstruction = null;
        } else {
            repurchaseInstruction = repurchaseInstructionBuilder.build();
            this.objectValidator.validate(EventInstruction.class, (RosettaModelObject)repurchaseInstruction);
        }
        return repurchaseInstruction;
    }

    protected abstract EventInstruction.EventInstructionBuilder doEvaluate(TradeState var1, Date var2);

    protected abstract MapperC<? extends NonNegativeQuantitySchedule> changeQuantity(TradeState var1, Date var2);

    protected abstract MapperS<? extends PriceQuantity> changePriceQuantity(TradeState var1, Date var2);

    public static class ResolveRepurchaseTransferInstructionDefault
    extends ResolveRepurchaseTransferInstruction {
        @Override
        protected EventInstruction.EventInstructionBuilder doEvaluate(TradeState tradeState, Date repurchaseDate) {
            EventInstruction.EventInstructionBuilder repurchaseInstruction = EventInstruction.builder();
            return this.assignOutput(repurchaseInstruction, tradeState, repurchaseDate);
        }

        protected EventInstruction.EventInstructionBuilder assignOutput(EventInstruction.EventInstructionBuilder repurchaseInstruction, TradeState tradeState, Date repurchaseDate) {
            repurchaseInstruction.setIntent(EventIntentEnum.REPURCHASE);
            repurchaseInstruction.getOrCreateInstruction(0).setBefore(tradeState == null ? ReferenceWithMetaTradeState.builder().build() : ReferenceWithMetaTradeState.builder().setValue(tradeState).build());
            repurchaseInstruction.getOrCreateInstruction(0).getOrCreatePrimitiveInstruction().setQuantityChange(QuantityChangeInstruction.builder().setChange(new ArrayList(this.changePriceQuantity(tradeState, repurchaseDate).getMulti())).setDirection(QuantityChangeDirectionEnum.REPLACE).setLotIdentifier(Collections.emptyList()).build());
            return Optional.ofNullable(repurchaseInstruction).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends NonNegativeQuantitySchedule> changeQuantity(TradeState tradeState, Date repurchaseDate) {
            MapperC thenArg = MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).mapC("getTradeLot", trade -> trade.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).mapItem(item -> MapperS.of((Object)NonNegativeQuantitySchedule.builder().setValue(new BigDecimal("0.0")).setUnit((UnitType)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).get()).build()));
            return ExpressionOperators.distinct((Mapper)thenArg);
        }

        @Override
        protected MapperS<? extends PriceQuantity> changePriceQuantity(TradeState tradeState, Date repurchaseDate) {
            return MapperS.of((Object)PriceQuantity.builder().setQuantityValue(new ArrayList(this.changeQuantity(tradeState, repurchaseDate).getMulti())).build());
        }
    }
}

