/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.observable.asset.InterestRateIndex;
import cdm.observable.asset.metafields.FieldWithMetaInterestRateIndex;
import cdm.observable.asset.metafields.ReferenceWithMetaInterestRateIndex;
import cdm.observable.event.ObservationIdentifier;
import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ResolveInterestRateObservationIdentifiersDefault.class)
public abstract class ResolveInterestRateObservationIdentifiers
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public ObservationIdentifier evaluate(InterestRatePayout payout, Date date) {
        ObservationIdentifier identifiers;
        ObservationIdentifier.ObservationIdentifierBuilder identifiersBuilder = this.doEvaluate(payout, date);
        if (identifiersBuilder == null) {
            identifiers = null;
        } else {
            identifiers = identifiersBuilder.build();
            this.objectValidator.validate(ObservationIdentifier.class, (RosettaModelObject)identifiers);
        }
        return identifiers;
    }

    protected abstract ObservationIdentifier.ObservationIdentifierBuilder doEvaluate(InterestRatePayout var1, Date var2);

    public static class ResolveInterestRateObservationIdentifiersDefault
    extends ResolveInterestRateObservationIdentifiers {
        @Override
        protected ObservationIdentifier.ObservationIdentifierBuilder doEvaluate(InterestRatePayout payout, Date date) {
            ObservationIdentifier.ObservationIdentifierBuilder identifiers = ObservationIdentifier.builder();
            return this.assignOutput(identifiers, payout, date);
        }

        protected ObservationIdentifier.ObservationIdentifierBuilder assignOutput(ObservationIdentifier.ObservationIdentifierBuilder identifiers, InterestRatePayout payout, Date date) {
            InterestRateIndex interestRateIndex;
            ReferenceWithMetaInterestRateIndex referenceWithMetaInterestRateIndex = (ReferenceWithMetaInterestRateIndex)MapperS.of((Object)payout).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRateSpecification", rateSpecification -> rateSpecification.getFloatingRateSpecification()).map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).get();
            FieldWithMetaInterestRateIndex ifThenElseResult = referenceWithMetaInterestRateIndex == null ? FieldWithMetaInterestRateIndex.builder().build() : ((interestRateIndex = referenceWithMetaInterestRateIndex.getValue()) == null ? FieldWithMetaInterestRateIndex.builder().build() : FieldWithMetaInterestRateIndex.builder().setValue(interestRateIndex).build());
            identifiers.getOrCreateObservable().getOrCreateIndex().setInterestRateIndex(ifThenElseResult);
            identifiers.setObservationDate(date);
            return Optional.ofNullable(identifiers).map(o -> o.prune()).orElse(null);
        }
    }
}

