/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.BusinessEvent;
import cdm.event.common.Trade;
import cdm.event.common.functions.ExtractAfterTrade;
import cdm.event.common.functions.ExtractBeforeEconomicTerms;
import cdm.event.common.functions.ExtractBeforeTrade;
import cdm.event.common.functions.ExtractOpenEconomicTerms;
import cdm.event.common.functions.ExtractTradeCollateralPrice;
import cdm.event.common.functions.ExtractTradeCollateralQuantity;
import cdm.event.common.functions.ExtractTradePurchasePrice;
import cdm.product.template.EconomicTerms;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.IQualifyFunctionExtension;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=Qualify_AdjustmentDefault.class)
public abstract class Qualify_Adjustment
implements RosettaFunction,
IQualifyFunctionExtension<BusinessEvent> {
    @Inject
    protected ExtractAfterTrade extractAfterTrade;
    @Inject
    protected ExtractBeforeEconomicTerms extractBeforeEconomicTerms;
    @Inject
    protected ExtractBeforeTrade extractBeforeTrade;
    @Inject
    protected ExtractOpenEconomicTerms extractOpenEconomicTerms;
    @Inject
    protected ExtractTradeCollateralPrice extractTradeCollateralPrice;
    @Inject
    protected ExtractTradeCollateralQuantity extractTradeCollateralQuantity;
    @Inject
    protected ExtractTradePurchasePrice extractTradePurchasePrice;

    public Boolean evaluate(BusinessEvent businessEvent) {
        Boolean is_event = this.doEvaluate(businessEvent);
        return is_event;
    }

    protected abstract Boolean doEvaluate(BusinessEvent var1);

    protected abstract MapperS<? extends Trade> beforeTrade(BusinessEvent var1);

    protected abstract MapperS<? extends Trade> afterTrade(BusinessEvent var1);

    protected abstract MapperC<BigDecimal> beforeTradePurchasePrice(BusinessEvent var1);

    protected abstract MapperC<BigDecimal> afterTradePurchasePrice(BusinessEvent var1);

    protected abstract MapperC<BigDecimal> beforeTradeCollateralQuantity(BusinessEvent var1);

    protected abstract MapperC<BigDecimal> afterTradeCollateralQuantity(BusinessEvent var1);

    protected abstract MapperC<BigDecimal> beforeTradeCollateralPrice(BusinessEvent var1);

    protected abstract MapperC<BigDecimal> afterTradeCollateralPrice(BusinessEvent var1);

    protected abstract MapperS<? extends EconomicTerms> beforeEconomicterms(BusinessEvent var1);

    protected abstract MapperS<? extends EconomicTerms> openEconomicTerms(BusinessEvent var1);

    public String getNamePrefix() {
        return "Qualify";
    }

    public static class Qualify_AdjustmentDefault
    extends Qualify_Adjustment {
        @Override
        protected Boolean doEvaluate(BusinessEvent businessEvent) {
            Boolean is_event = null;
            return this.assignOutput(is_event, businessEvent);
        }

        protected Boolean assignOutput(Boolean is_event, BusinessEvent businessEvent) {
            is_event = ExpressionOperators.exists((Mapper)MapperS.of((Object)businessEvent).mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).map("getTrade", tradeState -> tradeState.getTrade()).map("getProduct", trade -> trade.getProduct()).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms()).mapC("getPayout", economicTerms -> economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout())).and(ExpressionOperators.areEqual((Mapper)this.openEconomicTerms(businessEvent).mapC("getPayout", economicTerms -> economicTerms.getPayout()), (Mapper)this.beforeEconomicterms(businessEvent).mapC("getPayout", economicTerms -> economicTerms.getPayout()), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.exists(this.beforeTradePurchasePrice(businessEvent))).and(ExpressionOperators.exists(this.afterTradePurchasePrice(businessEvent))).and(ExpressionOperators.areEqual(this.afterTradePurchasePrice(businessEvent), this.beforeTradePurchasePrice(businessEvent), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.notEqual(this.beforeTradeCollateralQuantity(businessEvent), this.afterTradeCollateralQuantity(businessEvent), (CardinalityOperator)CardinalityOperator.Any)).and(ExpressionOperators.notEqual(this.beforeTradeCollateralPrice(businessEvent), this.afterTradeCollateralPrice(businessEvent), (CardinalityOperator)CardinalityOperator.Any)).and(ExpressionOperators.exists(this.beforeEconomicterms(businessEvent))).and(ExpressionOperators.exists(this.openEconomicTerms(businessEvent))).and(ExpressionOperators.areEqual((Mapper)this.openEconomicTerms(businessEvent).map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()), (Mapper)this.beforeEconomicterms(businessEvent).map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.notEqual((Mapper)this.openEconomicTerms(businessEvent).map("getEffectiveDate", economicTerms -> economicTerms.getEffectiveDate()), (Mapper)this.beforeEconomicterms(businessEvent).map("getEffectiveDate", economicTerms -> economicTerms.getEffectiveDate()), (CardinalityOperator)CardinalityOperator.Any)).get();
            return is_event;
        }

        @Override
        protected MapperS<? extends Trade> beforeTrade(BusinessEvent businessEvent) {
            return MapperS.of((Object)this.extractBeforeTrade.evaluate(businessEvent));
        }

        @Override
        protected MapperS<? extends Trade> afterTrade(BusinessEvent businessEvent) {
            return MapperS.of((Object)this.extractAfterTrade.evaluate(businessEvent));
        }

        @Override
        protected MapperC<BigDecimal> beforeTradePurchasePrice(BusinessEvent businessEvent) {
            return MapperC.of(this.extractTradePurchasePrice.evaluate((TradableProduct)this.beforeTrade(businessEvent).get()));
        }

        @Override
        protected MapperC<BigDecimal> afterTradePurchasePrice(BusinessEvent businessEvent) {
            return MapperC.of(this.extractTradePurchasePrice.evaluate((TradableProduct)this.afterTrade(businessEvent).get()));
        }

        @Override
        protected MapperC<BigDecimal> beforeTradeCollateralQuantity(BusinessEvent businessEvent) {
            return MapperC.of(this.extractTradeCollateralQuantity.evaluate((TradableProduct)this.beforeTrade(businessEvent).get()));
        }

        @Override
        protected MapperC<BigDecimal> afterTradeCollateralQuantity(BusinessEvent businessEvent) {
            return MapperC.of(this.extractTradeCollateralQuantity.evaluate((TradableProduct)this.afterTrade(businessEvent).get()));
        }

        @Override
        protected MapperC<BigDecimal> beforeTradeCollateralPrice(BusinessEvent businessEvent) {
            return MapperC.of(this.extractTradeCollateralPrice.evaluate((TradableProduct)this.beforeTrade(businessEvent).get()));
        }

        @Override
        protected MapperC<BigDecimal> afterTradeCollateralPrice(BusinessEvent businessEvent) {
            return MapperC.of(this.extractTradeCollateralPrice.evaluate((TradableProduct)this.afterTrade(businessEvent).get()));
        }

        @Override
        protected MapperS<? extends EconomicTerms> beforeEconomicterms(BusinessEvent businessEvent) {
            return MapperS.of((Object)this.extractBeforeEconomicTerms.evaluate(businessEvent));
        }

        @Override
        protected MapperS<? extends EconomicTerms> openEconomicTerms(BusinessEvent businessEvent) {
            return MapperS.of((Object)this.extractOpenEconomicTerms.evaluate(businessEvent));
        }
    }
}

