/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.BusinessEvent;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.event.common.functions.FilterOpenTradeStates;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ExtractAfterTradeDefault.class)
public abstract class ExtractAfterTrade
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected FilterOpenTradeStates filterOpenTradeStates;

    public Trade evaluate(BusinessEvent businessEvent) {
        Trade trade;
        Trade.TradeBuilder tradeBuilder = this.doEvaluate(businessEvent);
        if (tradeBuilder == null) {
            trade = null;
        } else {
            trade = tradeBuilder.build();
            this.objectValidator.validate(Trade.class, (RosettaModelObject)trade);
        }
        return trade;
    }

    protected abstract Trade.TradeBuilder doEvaluate(BusinessEvent var1);

    public static class ExtractAfterTradeDefault
    extends ExtractAfterTrade {
        @Override
        protected Trade.TradeBuilder doEvaluate(BusinessEvent businessEvent) {
            Trade.TradeBuilder trade = Trade.builder();
            return this.assignOutput(trade, businessEvent);
        }

        protected Trade.TradeBuilder assignOutput(Trade.TradeBuilder trade, BusinessEvent businessEvent) {
            trade = (Trade.TradeBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((TradeState)MapperC.of(this.filterOpenTradeStates.evaluate(MapperS.of((Object)businessEvent).mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).getMulti())).get())).map("getTrade", tradeState -> tradeState.getTrade()).get());
            return Optional.ofNullable(trade).map(o -> o.prune()).orElse(null);
        }
    }
}

