/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.event.common.ExecutionInstruction;
import cdm.event.common.ExerciseInstruction;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.TradeState;
import cdm.event.common.functions.Create_Execution;
import cdm.event.common.functions.Create_NonTransferableProduct;
import cdm.event.common.functions.Create_TradeState;
import cdm.event.common.functions.Update_ProductDirection;
import cdm.product.template.NonTransferableProduct;
import cdm.product.template.OptionPayout;
import cdm.product.template.OptionTypeEnum;
import cdm.product.template.TradeLot;
import cdm.product.template.Underlier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=Create_ExerciseDefault.class)
public abstract class Create_Exercise
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_Execution create_Execution;
    @Inject
    protected Create_NonTransferableProduct create_NonTransferableProduct;
    @Inject
    protected Create_TradeState create_TradeState;
    @Inject
    protected Update_ProductDirection update_ProductDirection;

    public List<? extends TradeState> evaluate(ExerciseInstruction exerciseInstruction, TradeState originalTrade) {
        List exercise;
        this.conditionValidator.validate(() -> ExpressionOperators.exists(this.optionPayout(exerciseInstruction, originalTrade)), "Requires that the original contract contains an option payout.");
        List<TradeState.TradeStateBuilder> exerciseBuilder = this.doEvaluate(exerciseInstruction, originalTrade);
        if (exerciseBuilder == null) {
            exercise = null;
        } else {
            exercise = exerciseBuilder.stream().map(TradeState::build).collect(Collectors.toList());
            this.objectValidator.validate(TradeState.class, exercise);
        }
        return exercise;
    }

    protected abstract List<TradeState.TradeStateBuilder> doEvaluate(ExerciseInstruction var1, TradeState var2);

    protected abstract MapperS<? extends OptionPayout> optionPayout(ExerciseInstruction var1, TradeState var2);

    protected abstract MapperS<? extends Underlier> underlier(ExerciseInstruction var1, TradeState var2);

    protected abstract MapperS<? extends NonTransferableProduct> resultProduct(ExerciseInstruction var1, TradeState var2);

    protected abstract MapperS<? extends NonTransferableProduct> productWithDirection(ExerciseInstruction var1, TradeState var2);

    protected abstract MapperS<? extends TradeState> execution(ExerciseInstruction var1, TradeState var2);

    public static class Create_ExerciseDefault
    extends Create_Exercise {
        @Override
        protected List<TradeState.TradeStateBuilder> doEvaluate(ExerciseInstruction exerciseInstruction, TradeState originalTrade) {
            ArrayList<TradeState.TradeStateBuilder> exercise = new ArrayList<TradeState.TradeStateBuilder>();
            return this.assignOutput(exercise, exerciseInstruction, originalTrade);
        }

        protected List<TradeState.TradeStateBuilder> assignOutput(List<TradeState.TradeStateBuilder> exercise, ExerciseInstruction exerciseInstruction, TradeState originalTrade) {
            TradeState tradeState = this.create_TradeState.evaluate((PrimitiveInstruction)MapperS.of((Object)exerciseInstruction).map("getExerciseQuantity", _exerciseInstruction -> _exerciseInstruction.getExerciseQuantity()).get(), originalTrade);
            if (tradeState == null) {
                exercise.addAll(this.toBuilder(Collections.emptyList()));
            } else {
                exercise.addAll(this.toBuilder(Collections.singletonList(tradeState)));
            }
            exercise.addAll(this.toBuilder(this.execution(exerciseInstruction, originalTrade).getMulti()));
            return Optional.ofNullable(exercise).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends OptionPayout> optionPayout(ExerciseInstruction exerciseInstruction, TradeState originalTrade) {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)exerciseInstruction).map("getExerciseOption", _exerciseInstruction -> _exerciseInstruction.getExerciseOption())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)exerciseInstruction).map("getExerciseOption", _exerciseInstruction -> _exerciseInstruction.getExerciseOption()).map("Type coercion", referenceWithMetaOptionPayout -> referenceWithMetaOptionPayout == null ? null : referenceWithMetaOptionPayout.getValue());
            }
            return MapperS.of((Object)((OptionPayout)MapperS.of((Object)originalTrade).map("getTrade", tradeState -> tradeState.getTrade()).map("getProduct", trade -> trade.getProduct()).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms()).mapC("getPayout", economicTerms -> economicTerms.getPayout()).map("getOptionPayout", payout -> payout.getOptionPayout()).get()));
        }

        @Override
        protected MapperS<? extends Underlier> underlier(ExerciseInstruction exerciseInstruction, TradeState originalTrade) {
            return this.optionPayout(exerciseInstruction, originalTrade).map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier());
        }

        @Override
        protected MapperS<? extends NonTransferableProduct> resultProduct(ExerciseInstruction exerciseInstruction, TradeState originalTrade) {
            if (ExpressionOperators.exists((Mapper)this.underlier(exerciseInstruction, originalTrade).map("getProduct", _underlier -> _underlier.getProduct()).map("getNonTransferableProduct", product -> product.getNonTransferableProduct())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.underlier(exerciseInstruction, originalTrade).map("getProduct", _underlier -> _underlier.getProduct()).map("getNonTransferableProduct", product -> product.getNonTransferableProduct());
            }
            return MapperS.of((Object)this.create_NonTransferableProduct.evaluate((Underlier)this.underlier(exerciseInstruction, originalTrade).get(), (PayerReceiver)this.optionPayout(exerciseInstruction, originalTrade).map("getPayerReceiver", _optionPayout -> _optionPayout.getPayerReceiver()).get()));
        }

        @Override
        protected MapperS<? extends NonTransferableProduct> productWithDirection(ExerciseInstruction exerciseInstruction, TradeState originalTrade) {
            if (ExpressionOperators.areEqual((Mapper)this.optionPayout(exerciseInstruction, originalTrade).map("getOptionType", _optionPayout -> _optionPayout.getOptionType()), (Mapper)MapperS.of((Object)((Object)OptionTypeEnum.PUT)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.update_ProductDirection.evaluate((NonTransferableProduct)this.resultProduct(exerciseInstruction, originalTrade).get(), (CounterpartyRoleEnum)((Object)this.optionPayout(exerciseInstruction, originalTrade).map("getPayerReceiver", _optionPayout -> _optionPayout.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()), (CounterpartyRoleEnum)((Object)this.optionPayout(exerciseInstruction, originalTrade).map("getPayerReceiver", _optionPayout -> _optionPayout.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get())));
            }
            return this.resultProduct(exerciseInstruction, originalTrade);
        }

        @Override
        protected MapperS<? extends TradeState> execution(ExerciseInstruction exerciseInstruction, TradeState originalTrade) {
            return MapperS.of((Object)this.create_Execution.evaluate(ExecutionInstruction.builder().setProduct((NonTransferableProduct)this.productWithDirection(exerciseInstruction, originalTrade).get()).setPriceQuantity(MapperS.of((Object)((TradeLot)MapperS.of((Object)originalTrade).map("getTrade", tradeState -> tradeState.getTrade()).mapC("getTradeLot", trade -> trade.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).getMulti()).setCounterparty(MapperS.of((Object)originalTrade).map("getTrade", tradeState -> tradeState.getTrade()).mapC("getCounterparty", trade -> trade.getCounterparty()).getMulti()).setAncillaryParty(MapperS.of((Object)originalTrade).map("getTrade", tradeState -> tradeState.getTrade()).mapC("getAncillaryParty", trade -> trade.getAncillaryParty()).getMulti()).setParties(MapperS.of((Object)originalTrade).map("getTrade", tradeState -> tradeState.getTrade()).mapC("getParty", trade -> trade.getParty()).getMulti()).setPartyRoles(MapperS.of((Object)originalTrade).map("getTrade", tradeState -> tradeState.getTrade()).mapC("getPartyRole", trade -> trade.getPartyRole()).getMulti()).setExecutionDetails(null).setTradeDate((FieldWithMetaDate)MapperS.of((Object)originalTrade).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradeDate", trade -> trade.getTradeDate()).get()).setTradeIdentifier(MapperS.of((Object)exerciseInstruction).mapC("getReplacementTradeIdentifier", _exerciseInstruction -> _exerciseInstruction.getReplacementTradeIdentifier()).getMulti()).build()));
        }
    }
}

