/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.CreditEventTypeEnum;
import cdm.event.common.meta.CreditEventMeta;
import cdm.legaldocumentation.common.Resource;
import cdm.observable.asset.Price;
import cdm.product.asset.ReferenceInformation;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CreditEvent", builder=CreditEventBuilderImpl.class, version="6.10.0")
@RuneDataType(value="CreditEvent", model="cdm", builder=CreditEventBuilderImpl.class, version="6.10.0")
public interface CreditEvent
extends RosettaModelObject {
    public static final CreditEventMeta metaData = new CreditEventMeta();

    public CreditEventTypeEnum getCreditEventType();

    public Date getEventDeterminationDate();

    public Date getAuctionDate();

    public Price getFinalPrice();

    public BigDecimal getRecoveryPercent();

    public List<? extends Resource> getPubliclyAvailableInformation();

    public ReferenceInformation getReferenceInformation();

    public CreditEvent build();

    public CreditEventBuilder toBuilder();

    public static CreditEventBuilder builder() {
        return new CreditEventBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CreditEvent> getType() {
        return CreditEvent.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("creditEventType"), CreditEventTypeEnum.class, (Object)this.getCreditEventType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDeterminationDate"), Date.class, (Object)this.getEventDeterminationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("auctionDate"), Date.class, (Object)this.getAuctionDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("finalPrice"), processor, Price.class, this.getFinalPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("recoveryPercent"), BigDecimal.class, (Object)this.getRecoveryPercent(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("publiclyAvailableInformation"), processor, Resource.class, this.getPubliclyAvailableInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referenceInformation"), processor, ReferenceInformation.class, this.getReferenceInformation(), new AttributeMeta[0]);
    }

    public static class CreditEventBuilderImpl
    implements CreditEventBuilder {
        protected CreditEventTypeEnum creditEventType;
        protected Date eventDeterminationDate;
        protected Date auctionDate;
        protected Price.PriceBuilder finalPrice;
        protected BigDecimal recoveryPercent;
        protected List<Resource.ResourceBuilder> publiclyAvailableInformation = new ArrayList<Resource.ResourceBuilder>();
        protected ReferenceInformation.ReferenceInformationBuilder referenceInformation;

        @Override
        @RosettaAttribute(value="creditEventType", isRequired=true)
        @RuneAttribute(value="creditEventType", isRequired=true)
        public CreditEventTypeEnum getCreditEventType() {
            return this.creditEventType;
        }

        @Override
        @RosettaAttribute(value="eventDeterminationDate", isRequired=true)
        @RuneAttribute(value="eventDeterminationDate", isRequired=true)
        public Date getEventDeterminationDate() {
            return this.eventDeterminationDate;
        }

        @Override
        @RosettaAttribute(value="auctionDate")
        @RuneAttribute(value="auctionDate")
        public Date getAuctionDate() {
            return this.auctionDate;
        }

        @Override
        @RosettaAttribute(value="finalPrice")
        @RuneAttribute(value="finalPrice")
        public Price.PriceBuilder getFinalPrice() {
            return this.finalPrice;
        }

        @Override
        public Price.PriceBuilder getOrCreateFinalPrice() {
            Price.PriceBuilder result = this.finalPrice != null ? this.finalPrice : (this.finalPrice = Price.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="recoveryPercent")
        @RuneAttribute(value="recoveryPercent")
        public BigDecimal getRecoveryPercent() {
            return this.recoveryPercent;
        }

        @Override
        @RosettaAttribute(value="publiclyAvailableInformation")
        @RuneAttribute(value="publiclyAvailableInformation")
        public List<? extends Resource.ResourceBuilder> getPubliclyAvailableInformation() {
            return this.publiclyAvailableInformation;
        }

        @Override
        public Resource.ResourceBuilder getOrCreatePubliclyAvailableInformation(int index) {
            if (this.publiclyAvailableInformation == null) {
                this.publiclyAvailableInformation = new ArrayList<Resource.ResourceBuilder>();
            }
            return (Resource.ResourceBuilder)this.getIndex(this.publiclyAvailableInformation, index, () -> {
                Resource.ResourceBuilder newPubliclyAvailableInformation = Resource.builder();
                return newPubliclyAvailableInformation;
            });
        }

        @Override
        @RosettaAttribute(value="referenceInformation", isRequired=true)
        @RuneAttribute(value="referenceInformation", isRequired=true)
        public ReferenceInformation.ReferenceInformationBuilder getReferenceInformation() {
            return this.referenceInformation;
        }

        @Override
        public ReferenceInformation.ReferenceInformationBuilder getOrCreateReferenceInformation() {
            ReferenceInformation.ReferenceInformationBuilder result = this.referenceInformation != null ? this.referenceInformation : (this.referenceInformation = ReferenceInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditEventType", isRequired=true)
        @RuneAttribute(value="creditEventType", isRequired=true)
        public CreditEventBuilder setCreditEventType(CreditEventTypeEnum _creditEventType) {
            this.creditEventType = _creditEventType == null ? null : _creditEventType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDeterminationDate", isRequired=true)
        @RuneAttribute(value="eventDeterminationDate", isRequired=true)
        public CreditEventBuilder setEventDeterminationDate(Date _eventDeterminationDate) {
            this.eventDeterminationDate = _eventDeterminationDate == null ? null : _eventDeterminationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="auctionDate")
        @RuneAttribute(value="auctionDate")
        public CreditEventBuilder setAuctionDate(Date _auctionDate) {
            this.auctionDate = _auctionDate == null ? null : _auctionDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalPrice")
        @RuneAttribute(value="finalPrice")
        public CreditEventBuilder setFinalPrice(Price _finalPrice) {
            this.finalPrice = _finalPrice == null ? null : _finalPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="recoveryPercent")
        @RuneAttribute(value="recoveryPercent")
        public CreditEventBuilder setRecoveryPercent(BigDecimal _recoveryPercent) {
            this.recoveryPercent = _recoveryPercent == null ? null : _recoveryPercent;
            return this;
        }

        @Override
        @RosettaAttribute(value="publiclyAvailableInformation")
        @RuneAttribute(value="publiclyAvailableInformation")
        public CreditEventBuilder addPubliclyAvailableInformation(Resource _publiclyAvailableInformation) {
            if (_publiclyAvailableInformation != null) {
                this.publiclyAvailableInformation.add(_publiclyAvailableInformation.toBuilder());
            }
            return this;
        }

        @Override
        public CreditEventBuilder addPubliclyAvailableInformation(Resource _publiclyAvailableInformation, int idx) {
            this.getIndex(this.publiclyAvailableInformation, idx, () -> _publiclyAvailableInformation.toBuilder());
            return this;
        }

        @Override
        public CreditEventBuilder addPubliclyAvailableInformation(List<? extends Resource> publiclyAvailableInformations) {
            if (publiclyAvailableInformations != null) {
                for (Resource resource : publiclyAvailableInformations) {
                    this.publiclyAvailableInformation.add(resource.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="publiclyAvailableInformation")
        public CreditEventBuilder setPubliclyAvailableInformation(List<? extends Resource> publiclyAvailableInformations) {
            this.publiclyAvailableInformation = publiclyAvailableInformations == null ? new ArrayList<Resource.ResourceBuilder>() : (List)publiclyAvailableInformations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceInformation", isRequired=true)
        @RuneAttribute(value="referenceInformation", isRequired=true)
        public CreditEventBuilder setReferenceInformation(ReferenceInformation _referenceInformation) {
            this.referenceInformation = _referenceInformation == null ? null : _referenceInformation.toBuilder();
            return this;
        }

        @Override
        public CreditEvent build() {
            return new CreditEventImpl(this);
        }

        @Override
        public CreditEventBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditEventBuilder prune() {
            if (this.finalPrice != null && !this.finalPrice.prune().hasData()) {
                this.finalPrice = null;
            }
            this.publiclyAvailableInformation = this.publiclyAvailableInformation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.referenceInformation != null && !this.referenceInformation.prune().hasData()) {
                this.referenceInformation = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCreditEventType() != null) {
                return true;
            }
            if (this.getEventDeterminationDate() != null) {
                return true;
            }
            if (this.getAuctionDate() != null) {
                return true;
            }
            if (this.getFinalPrice() != null && this.getFinalPrice().hasData()) {
                return true;
            }
            if (this.getRecoveryPercent() != null) {
                return true;
            }
            if (this.getPubliclyAvailableInformation() != null && this.getPubliclyAvailableInformation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getReferenceInformation() != null && this.getReferenceInformation().hasData();
        }

        public CreditEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CreditEventBuilder o = (CreditEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFinalPrice(), (RosettaModelObjectBuilder)o.getFinalPrice(), this::setFinalPrice);
            merger.mergeRosetta(this.getPubliclyAvailableInformation(), o.getPubliclyAvailableInformation(), this::getOrCreatePubliclyAvailableInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferenceInformation(), (RosettaModelObjectBuilder)o.getReferenceInformation(), this::setReferenceInformation);
            merger.mergeBasic((Object)this.getCreditEventType(), (Object)o.getCreditEventType(), this::setCreditEventType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventDeterminationDate(), (Object)o.getEventDeterminationDate(), this::setEventDeterminationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAuctionDate(), (Object)o.getAuctionDate(), this::setAuctionDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRecoveryPercent(), (Object)o.getRecoveryPercent(), this::setRecoveryPercent, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditEvent _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.creditEventType, (Object)_that.getCreditEventType())) {
                return false;
            }
            if (!Objects.equals(this.eventDeterminationDate, _that.getEventDeterminationDate())) {
                return false;
            }
            if (!Objects.equals(this.auctionDate, _that.getAuctionDate())) {
                return false;
            }
            if (!Objects.equals(this.finalPrice, _that.getFinalPrice())) {
                return false;
            }
            if (!Objects.equals(this.recoveryPercent, _that.getRecoveryPercent())) {
                return false;
            }
            if (!ListEquals.listEquals(this.publiclyAvailableInformation, _that.getPubliclyAvailableInformation())) {
                return false;
            }
            return Objects.equals(this.referenceInformation, _that.getReferenceInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.creditEventType != null ? ((Object)((Object)this.creditEventType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventDeterminationDate != null ? this.eventDeterminationDate.hashCode() : 0);
            _result = 31 * _result + (this.auctionDate != null ? this.auctionDate.hashCode() : 0);
            _result = 31 * _result + (this.finalPrice != null ? this.finalPrice.hashCode() : 0);
            _result = 31 * _result + (this.recoveryPercent != null ? this.recoveryPercent.hashCode() : 0);
            _result = 31 * _result + (this.publiclyAvailableInformation != null ? this.publiclyAvailableInformation.hashCode() : 0);
            _result = 31 * _result + (this.referenceInformation != null ? this.referenceInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditEventBuilder {creditEventType=" + (Object)((Object)this.creditEventType) + ", eventDeterminationDate=" + this.eventDeterminationDate + ", auctionDate=" + this.auctionDate + ", finalPrice=" + this.finalPrice + ", recoveryPercent=" + this.recoveryPercent + ", publiclyAvailableInformation=" + this.publiclyAvailableInformation + ", referenceInformation=" + this.referenceInformation + '}';
        }
    }

    public static interface CreditEventBuilder
    extends CreditEvent,
    RosettaModelObjectBuilder {
        public Price.PriceBuilder getOrCreateFinalPrice();

        @Override
        public Price.PriceBuilder getFinalPrice();

        public Resource.ResourceBuilder getOrCreatePubliclyAvailableInformation(int var1);

        public List<? extends Resource.ResourceBuilder> getPubliclyAvailableInformation();

        public ReferenceInformation.ReferenceInformationBuilder getOrCreateReferenceInformation();

        @Override
        public ReferenceInformation.ReferenceInformationBuilder getReferenceInformation();

        public CreditEventBuilder setCreditEventType(CreditEventTypeEnum var1);

        public CreditEventBuilder setEventDeterminationDate(Date var1);

        public CreditEventBuilder setAuctionDate(Date var1);

        public CreditEventBuilder setFinalPrice(Price var1);

        public CreditEventBuilder setRecoveryPercent(BigDecimal var1);

        public CreditEventBuilder addPubliclyAvailableInformation(Resource var1);

        public CreditEventBuilder addPubliclyAvailableInformation(Resource var1, int var2);

        public CreditEventBuilder addPubliclyAvailableInformation(List<? extends Resource> var1);

        public CreditEventBuilder setPubliclyAvailableInformation(List<? extends Resource> var1);

        public CreditEventBuilder setReferenceInformation(ReferenceInformation var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("creditEventType"), CreditEventTypeEnum.class, (Object)this.getCreditEventType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDeterminationDate"), Date.class, (Object)this.getEventDeterminationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("auctionDate"), Date.class, (Object)this.getAuctionDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("finalPrice"), processor, Price.PriceBuilder.class, this.getFinalPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("recoveryPercent"), BigDecimal.class, (Object)this.getRecoveryPercent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("publiclyAvailableInformation"), processor, Resource.ResourceBuilder.class, this.getPubliclyAvailableInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referenceInformation"), processor, ReferenceInformation.ReferenceInformationBuilder.class, this.getReferenceInformation(), new AttributeMeta[0]);
        }

        public CreditEventBuilder prune();
    }

    public static class CreditEventImpl
    implements CreditEvent {
        private final CreditEventTypeEnum creditEventType;
        private final Date eventDeterminationDate;
        private final Date auctionDate;
        private final Price finalPrice;
        private final BigDecimal recoveryPercent;
        private final List<? extends Resource> publiclyAvailableInformation;
        private final ReferenceInformation referenceInformation;

        protected CreditEventImpl(CreditEventBuilder builder) {
            this.creditEventType = builder.getCreditEventType();
            this.eventDeterminationDate = builder.getEventDeterminationDate();
            this.auctionDate = builder.getAuctionDate();
            this.finalPrice = Optional.ofNullable(builder.getFinalPrice()).map(f -> f.build()).orElse(null);
            this.recoveryPercent = builder.getRecoveryPercent();
            this.publiclyAvailableInformation = Optional.ofNullable(builder.getPubliclyAvailableInformation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.referenceInformation = Optional.ofNullable(builder.getReferenceInformation()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="creditEventType", isRequired=true)
        @RuneAttribute(value="creditEventType", isRequired=true)
        public CreditEventTypeEnum getCreditEventType() {
            return this.creditEventType;
        }

        @Override
        @RosettaAttribute(value="eventDeterminationDate", isRequired=true)
        @RuneAttribute(value="eventDeterminationDate", isRequired=true)
        public Date getEventDeterminationDate() {
            return this.eventDeterminationDate;
        }

        @Override
        @RosettaAttribute(value="auctionDate")
        @RuneAttribute(value="auctionDate")
        public Date getAuctionDate() {
            return this.auctionDate;
        }

        @Override
        @RosettaAttribute(value="finalPrice")
        @RuneAttribute(value="finalPrice")
        public Price getFinalPrice() {
            return this.finalPrice;
        }

        @Override
        @RosettaAttribute(value="recoveryPercent")
        @RuneAttribute(value="recoveryPercent")
        public BigDecimal getRecoveryPercent() {
            return this.recoveryPercent;
        }

        @Override
        @RosettaAttribute(value="publiclyAvailableInformation")
        @RuneAttribute(value="publiclyAvailableInformation")
        public List<? extends Resource> getPubliclyAvailableInformation() {
            return this.publiclyAvailableInformation;
        }

        @Override
        @RosettaAttribute(value="referenceInformation", isRequired=true)
        @RuneAttribute(value="referenceInformation", isRequired=true)
        public ReferenceInformation getReferenceInformation() {
            return this.referenceInformation;
        }

        @Override
        public CreditEvent build() {
            return this;
        }

        @Override
        public CreditEventBuilder toBuilder() {
            CreditEventBuilder builder = CreditEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditEventBuilder builder) {
            Optional.ofNullable(this.getCreditEventType()).ifPresent(builder::setCreditEventType);
            Optional.ofNullable(this.getEventDeterminationDate()).ifPresent(builder::setEventDeterminationDate);
            Optional.ofNullable(this.getAuctionDate()).ifPresent(builder::setAuctionDate);
            Optional.ofNullable(this.getFinalPrice()).ifPresent(builder::setFinalPrice);
            Optional.ofNullable(this.getRecoveryPercent()).ifPresent(builder::setRecoveryPercent);
            Optional.ofNullable(this.getPubliclyAvailableInformation()).ifPresent(builder::setPubliclyAvailableInformation);
            Optional.ofNullable(this.getReferenceInformation()).ifPresent(builder::setReferenceInformation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditEvent _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.creditEventType, (Object)_that.getCreditEventType())) {
                return false;
            }
            if (!Objects.equals(this.eventDeterminationDate, _that.getEventDeterminationDate())) {
                return false;
            }
            if (!Objects.equals(this.auctionDate, _that.getAuctionDate())) {
                return false;
            }
            if (!Objects.equals(this.finalPrice, _that.getFinalPrice())) {
                return false;
            }
            if (!Objects.equals(this.recoveryPercent, _that.getRecoveryPercent())) {
                return false;
            }
            if (!ListEquals.listEquals(this.publiclyAvailableInformation, _that.getPubliclyAvailableInformation())) {
                return false;
            }
            return Objects.equals(this.referenceInformation, _that.getReferenceInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.creditEventType != null ? ((Object)((Object)this.creditEventType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventDeterminationDate != null ? this.eventDeterminationDate.hashCode() : 0);
            _result = 31 * _result + (this.auctionDate != null ? this.auctionDate.hashCode() : 0);
            _result = 31 * _result + (this.finalPrice != null ? this.finalPrice.hashCode() : 0);
            _result = 31 * _result + (this.recoveryPercent != null ? this.recoveryPercent.hashCode() : 0);
            _result = 31 * _result + (this.publiclyAvailableInformation != null ? this.publiclyAvailableInformation.hashCode() : 0);
            _result = 31 * _result + (this.referenceInformation != null ? this.referenceInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditEvent {creditEventType=" + (Object)((Object)this.creditEventType) + ", eventDeterminationDate=" + this.eventDeterminationDate + ", auctionDate=" + this.auctionDate + ", finalPrice=" + this.finalPrice + ", recoveryPercent=" + this.recoveryPercent + ", publiclyAvailableInformation=" + this.publiclyAvailableInformation + ", referenceInformation=" + this.referenceInformation + '}';
        }
    }
}

