/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.Cash;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CashNoTaxonomy")
@ImplementedBy(value=Default.class)
public interface CashNoTaxonomy
extends Validator<Cash> {
    public static final String NAME = "CashNoTaxonomy";
    public static final String DEFINITION = "taxonomy is absent";

    public static class NoOp
    implements CashNoTaxonomy {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Cash cash) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CashNoTaxonomy {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Cash cash) {
            ComparisonResult result = this.executeDataRule(cash);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CashNoTaxonomy.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Cash", (RosettaPath)path, (String)CashNoTaxonomy.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CashNoTaxonomy.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Cash", (RosettaPath)path, (String)CashNoTaxonomy.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Cash cash) {
            try {
                return ExpressionOperators.notExists((Mapper)MapperS.of((Object)cash).mapC("getTaxonomy", _cash -> _cash.getTaxonomy()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

