# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['Product']


class Product(BaseDataClass):
    """
    Defines the product that is the subject of a tradable product definition, an underlying product definition, a physical exercise, a position, or other purposes.
    """
    contractualProduct: Optional[cdm.product.template.ContractualProduct.ContractualProduct] = Field(None, description="Specifies the contractual product's economic terms, product identifier, and product taxonomy.")
    """
    Specifies the contractual product's economic terms, product identifier, and product taxonomy.
    """
    index: Optional[cdm.base.staticdata.asset.common.Index.Index] = Field(None, description="Identifies an index by referencing a product identifier.")
    """
    Identifies an index by referencing a product identifier.
    """
    loan: Optional[cdm.base.staticdata.asset.common.Loan.Loan] = Field(None, description="Identifies a loan by referencing a product identifier and an optional set of attributes.")
    """
    Identifies a loan by referencing a product identifier and an optional set of attributes.
    """
    assetPool: Optional[cdm.base.staticdata.asset.common.AssetPool.AssetPool] = Field(None, description="Identifies an asset pool product for defining pool of assets backing an asset backed security.")
    """
    Identifies an asset pool product for defining pool of assets backing an asset backed security.
    """
    foreignExchange: Optional[cdm.product.asset.ForeignExchange.ForeignExchange] = Field(None, description="Defines a foreign exchange spot or forward transaction.")
    """
    Defines a foreign exchange spot or forward transaction.
    """
    commodity: Optional[AttributeWithAddress[cdm.base.staticdata.asset.common.Commodity.Commodity] | cdm.base.staticdata.asset.common.Commodity.Commodity] = Field(None, description="Identifies a commodity by referencing a product identifier.")
    """
    Identifies a commodity by referencing a product identifier.
    """
    security: Optional[cdm.base.staticdata.asset.common.Security.Security] = Field(None, description="Identifies a security by referencing a product identifier and a security type, plus an optional set of attributes.")
    """
    Identifies a security by referencing a product identifier and a security type, plus an optional set of attributes.
    """
    basket: Optional[cdm.product.template.Basket.Basket] = Field(None, description="Identifies a custom basket by referencing a product identifier and its constituents.")
    """
    Identifies a custom basket by referencing a product identifier and its constituents.
    """
    
    @rosetta_condition
    def condition_0_(self):
        item = self
        return rosetta_check_one_of(self, 'contractualProduct', 'index', 'loan', 'assetPool', 'foreignExchange', 'commodity', 'security', 'basket', necessity=True)

import cdm 
import cdm.product.template.ContractualProduct
import cdm.base.staticdata.asset.common.Index
import cdm.base.staticdata.asset.common.Loan
import cdm.base.staticdata.asset.common.AssetPool
import cdm.product.asset.ForeignExchange
import cdm.base.staticdata.asset.common.Commodity
import cdm.base.staticdata.asset.common.Security
import cdm.product.template.Basket
