# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ExtendibleProvisionAdjustedDates']


class ExtendibleProvisionAdjustedDates(BaseDataClass):
    """
    A data defining:  the adjusted dates associated with a provision to extend a swap.
    """
    extensionEvent: List[cdm.product.template.ExtensionEvent.ExtensionEvent] = Field([], description="The adjusted dates associated with a single extendible exercise date.")
    """
    The adjusted dates associated with a single extendible exercise date.
    """
    @rosetta_condition
    def cardinality_extensionEvent(self):
        return check_cardinality(self.extensionEvent, 1, None)
    

import cdm 
import cdm.product.template.ExtensionEvent
