# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['Asian']


class Asian(BaseDataClass):
    """
    As per ISDA 2002 Definitions.
    """
    averagingInOut: cdm.product.template.AveragingInOutEnum.AveragingInOutEnum = Field(..., description="")
    strikeFactor: Optional[Decimal] = Field(None, description="The factor of strike.")
    """
    The factor of strike.
    """
    averagingPeriodIn: Optional[cdm.product.common.schedule.AveragingPeriod.AveragingPeriod] = Field(None, description="The averaging in period.")
    """
    The averaging in period.
    """
    averagingPeriodOut: Optional[cdm.product.common.schedule.AveragingPeriod.AveragingPeriod] = Field(None, description="The averaging out period.")
    """
    The averaging out period.
    """

import cdm 
import cdm.product.template.AveragingInOutEnum
import cdm.product.common.schedule.AveragingPeriod
