# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['DeliveryAmount']


class DeliveryAmount(BaseDataClass):
    """
    A class to specify the application of Interest Amount with respect the Delivery Amount.
    """
    standardElection: Optional[cdm.product.collateral.DeliveryAmountElectionEnum.DeliveryAmountElectionEnum] = Field(None, description="The standard election as specified by an enumeration.")
    """
    The standard election as specified by an enumeration.
    """
    customElection: Optional[str] = Field(None, description="The custom election that might be specified by the parties to the agreement.")
    """
    The custom election that might be specified by the parties to the agreement.
    """
    
    @rosetta_condition
    def condition_0_(self):
        item = self
        return rosetta_check_one_of(self, 'standardElection', 'customElection', necessity=True)

import cdm 
import cdm.product.collateral.DeliveryAmountElectionEnum
