# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['VolatilityReturnTerms']

from cdm.product.asset.ReturnTermsBase import ReturnTermsBase

class VolatilityReturnTerms(ReturnTermsBase):
    volatilityStrikePrice: cdm.observable.asset.Price.Price = Field(..., description="Volatility Strike Price in accordance with the ISDA 2011 Equity Derivatives Definitions.")
    """
    Volatility Strike Price in accordance with the ISDA 2011 Equity Derivatives Definitions.
    """
    volatilityCapFloor: Optional[cdm.product.asset.VolatilityCapFloor.VolatilityCapFloor] = Field(None, description="Contains volatility-based barriers")
    """
    Contains volatility-based barriers
    """
    exchangeTradedContractNearest: Optional[cdm.observable.asset.Observable.Observable] = Field(None, description="Specification of the exchange traded contract nearest.")
    """
    Specification of the exchange traded contract nearest.
    """
    
    @rosetta_condition
    def condition_0_UnderlierMustBeSecurity(self):
        """
        If an exchange traded contract nearest is specified, it must have a security as underlier.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "exchangeTradedContractNearest"), "productIdentifier"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "exchangeTradedContractNearest")), _then_fn0, _else_fn0)

import cdm 
import cdm.observable.asset.Price
import cdm.product.asset.VolatilityCapFloor
import cdm.observable.asset.Observable
