# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['SecurityValuation']


class SecurityValuation(BaseDataClass):
    """
     Terms defining the security valuation method as part of a security leg in a securities fianncing transaction and closely modelled onto the CollateralValuation type in FpML.
    """
    securityValuationModel: cdm.observable.asset.SecurityValuationModel.SecurityValuationModel = Field(..., description="The security valuation model choice, based on either a nominal amount or a number of units.")
    """
    The security valuation model choice, based on either a nominal amount or a number of units.
    """
    underlier: cdm.base.staticdata.asset.common.Security.Security = Field(..., description="The underlying security of the security leg.")
    """
    The underlying security of the security leg.
    """

import cdm 
import cdm.observable.asset.SecurityValuationModel
import cdm.base.staticdata.asset.common.Security
