# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['BondChoiceModel']


class BondChoiceModel(BaseDataClass):
    _CHOICE_ALIAS_MAP ={"productIdentifier":[("bond", rosetta_resolve_attr), ("convertibleBond", rosetta_resolve_attr)]}
    """
     Either a bond or convertible bond.
    """
    bond: Optional[cdm.base.staticdata.asset.common.Bond.Bond] = Field(None, description="")
    convertibleBond: Optional[cdm.base.staticdata.asset.common.ConvertibleBond.ConvertibleBond] = Field(None, description="")
    
    @rosetta_condition
    def condition_0_(self):
        item = self
        return rosetta_check_one_of(self, 'bond', 'convertibleBond', necessity=True)

import cdm 
import cdm.base.staticdata.asset.common.Bond
import cdm.base.staticdata.asset.common.ConvertibleBond
