# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['Listing']

from cdm.base.staticdata.asset.common.ProductBase import ProductBase

class Listing(ProductBase):
    """
    Specifies the exchange where the asset is listed.
    """
    exchange: Optional[cdm.base.staticdata.party.LegalEntity.LegalEntity] = Field(None, description="Exchange refers to the principal financial market where the asset is listed. This is the main venue for the buying and selling of the asset, such as a stock exchange for equities or a futures exchange for commodities.")
    """
    Exchange refers to the principal financial market where the asset is listed. This is the main venue for the buying and selling of the asset, such as a stock exchange for equities or a futures exchange for commodities.
    """
    relatedExchange: List[cdm.base.staticdata.party.LegalEntity.LegalEntity] = Field([], description="Related Exchange denotes any additional exchange or trading platform where the asset is listed. For instance, if the asset is a particular stock, the related exchange might be the exchange where the stock is listed.")
    """
    Related Exchange denotes any additional exchange or trading platform where the asset is listed. For instance, if the asset is a particular stock, the related exchange might be the exchange where the stock is listed.
    """
    
    @rosetta_condition
    def condition_0_RelatedExchange(self):
        """
        Related Exchange should only be specified if an Exchange is also specified.
        """
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "relatedExchange")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn((not rosetta_attr_exists(rosetta_resolve_attr(self, "exchange"))), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.party.LegalEntity
