/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.OptionPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="OptionPayoutClearedPhysicalSettlementExists")
@ImplementedBy(value=Default.class)
public interface OptionPayoutClearedPhysicalSettlementExists
extends Validator<OptionPayout> {
    public static final String NAME = "OptionPayoutClearedPhysicalSettlementExists";
    public static final String DEFINITION = "if settlementTerms -> physicalSettlementTerms exists and underlier -> contractualProduct -> economicTerms -> payout -> interestRatePayout only exists and underlier -> contractualProduct -> economicTerms -> payout -> interestRatePayout count = 2 then settlementTerms -> physicalSettlementTerms -> clearedPhysicalSettlement exists";

    public static class NoOp
    implements OptionPayoutClearedPhysicalSettlementExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, OptionPayout optionPayout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements OptionPayoutClearedPhysicalSettlementExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, OptionPayout optionPayout) {
            ComparisonResult result = this.executeDataRule(optionPayout);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)OptionPayoutClearedPhysicalSettlementExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"OptionPayout", (RosettaPath)path, (String)OptionPayoutClearedPhysicalSettlementExists.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)OptionPayoutClearedPhysicalSettlementExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"OptionPayout", (RosettaPath)path, (String)OptionPayoutClearedPhysicalSettlementExists.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(OptionPayout optionPayout) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)optionPayout).map("getSettlementTerms", _optionPayout -> _optionPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms())).and(ExpressionOperators.onlyExists((Mapper)MapperS.of((Object)optionPayout).map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()), Arrays.asList("interestRatePayout", "creditDefaultPayout", "optionPayout", "commodityPayout", "forwardPayout", "fixedPricePayout", "securityPayout", "cashflow", "performancePayout", "assetPayout"), Arrays.asList("interestRatePayout"))).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)MapperS.of((Object)optionPayout).map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).resultCount()), (Mapper)MapperS.of((Object)2), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)optionPayout).map("getSettlementTerms", _optionPayout -> _optionPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getClearedPhysicalSettlement", physicalSettlementTerms -> physicalSettlementTerms.getClearedPhysicalSettlement()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

