/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.AssetPayout;
import cdm.product.template.DurationTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="AssetPayoutDividendTermsValidation")
@ImplementedBy(value=Default.class)
public interface AssetPayoutDividendTermsValidation
extends Validator<AssetPayout> {
    public static final String NAME = "AssetPayoutDividendTermsValidation";
    public static final String DEFINITION = "if dividendTerms exists then durationType -> durationType = DurationTypeEnum -> Term";

    public static class NoOp
    implements AssetPayoutDividendTermsValidation {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetPayout assetPayout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements AssetPayoutDividendTermsValidation {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetPayout assetPayout) {
            ComparisonResult result = this.executeDataRule(assetPayout);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)AssetPayoutDividendTermsValidation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetPayout", (RosettaPath)path, (String)AssetPayoutDividendTermsValidation.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)AssetPayoutDividendTermsValidation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetPayout", (RosettaPath)path, (String)AssetPayoutDividendTermsValidation.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(AssetPayout assetPayout) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)assetPayout).map("getDividendTerms", _assetPayout -> _assetPayout.getDividendTerms())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)assetPayout).map("getDurationType", _assetPayout -> _assetPayout.getDurationType()).map("getDurationType", duration -> duration.getDurationType()), (Mapper)MapperS.of((Object)((Object)DurationTypeEnum.TERM)), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

