/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.identifier.Identifier;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.meta.TradeLotMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TradeLot", builder=TradeLotBuilderImpl.class, version="5.28.0")
@RuneDataType(value="TradeLot", model="cdm", builder=TradeLotBuilderImpl.class, version="5.28.0")
public interface TradeLot
extends RosettaModelObject {
    public static final TradeLotMeta metaData = new TradeLotMeta();

    public List<? extends Identifier> getLotIdentifier();

    public List<? extends PriceQuantity> getPriceQuantity();

    public TradeLot build();

    public TradeLotBuilder toBuilder();

    public static TradeLotBuilder builder() {
        return new TradeLotBuilderImpl();
    }

    default public RosettaMetaData<? extends TradeLot> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TradeLot> getType() {
        return TradeLot.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("lotIdentifier"), processor, Identifier.class, this.getLotIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceQuantity"), processor, PriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
    }

    public static class TradeLotBuilderImpl
    implements TradeLotBuilder {
        protected List<Identifier.IdentifierBuilder> lotIdentifier = new ArrayList<Identifier.IdentifierBuilder>();
        protected List<PriceQuantity.PriceQuantityBuilder> priceQuantity = new ArrayList<PriceQuantity.PriceQuantityBuilder>();

        @Override
        @RosettaAttribute(value="lotIdentifier")
        @RuneAttribute(value="lotIdentifier")
        public List<? extends Identifier.IdentifierBuilder> getLotIdentifier() {
            return this.lotIdentifier;
        }

        @Override
        public Identifier.IdentifierBuilder getOrCreateLotIdentifier(int index) {
            if (this.lotIdentifier == null) {
                this.lotIdentifier = new ArrayList<Identifier.IdentifierBuilder>();
            }
            return (Identifier.IdentifierBuilder)this.getIndex(this.lotIdentifier, index, () -> {
                Identifier.IdentifierBuilder newLotIdentifier = Identifier.builder();
                return newLotIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="priceQuantity", isRequired=true)
        @RuneAttribute(value="priceQuantity", isRequired=true)
        public List<? extends PriceQuantity.PriceQuantityBuilder> getPriceQuantity() {
            return this.priceQuantity;
        }

        @Override
        public PriceQuantity.PriceQuantityBuilder getOrCreatePriceQuantity(int index) {
            if (this.priceQuantity == null) {
                this.priceQuantity = new ArrayList<PriceQuantity.PriceQuantityBuilder>();
            }
            return (PriceQuantity.PriceQuantityBuilder)this.getIndex(this.priceQuantity, index, () -> {
                PriceQuantity.PriceQuantityBuilder newPriceQuantity = PriceQuantity.builder();
                return newPriceQuantity;
            });
        }

        @Override
        @RosettaAttribute(value="lotIdentifier")
        @RuneAttribute(value="lotIdentifier")
        public TradeLotBuilder addLotIdentifier(Identifier _lotIdentifier) {
            if (_lotIdentifier != null) {
                this.lotIdentifier.add(_lotIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public TradeLotBuilder addLotIdentifier(Identifier _lotIdentifier, int idx) {
            this.getIndex(this.lotIdentifier, idx, () -> _lotIdentifier.toBuilder());
            return this;
        }

        @Override
        public TradeLotBuilder addLotIdentifier(List<? extends Identifier> lotIdentifiers) {
            if (lotIdentifiers != null) {
                for (Identifier identifier : lotIdentifiers) {
                    this.lotIdentifier.add(identifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="lotIdentifier")
        public TradeLotBuilder setLotIdentifier(List<? extends Identifier> lotIdentifiers) {
            this.lotIdentifier = lotIdentifiers == null ? new ArrayList<Identifier.IdentifierBuilder>() : (List)lotIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="priceQuantity", isRequired=true)
        @RuneAttribute(value="priceQuantity", isRequired=true)
        public TradeLotBuilder addPriceQuantity(PriceQuantity _priceQuantity) {
            if (_priceQuantity != null) {
                this.priceQuantity.add(_priceQuantity.toBuilder());
            }
            return this;
        }

        @Override
        public TradeLotBuilder addPriceQuantity(PriceQuantity _priceQuantity, int idx) {
            this.getIndex(this.priceQuantity, idx, () -> _priceQuantity.toBuilder());
            return this;
        }

        @Override
        public TradeLotBuilder addPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            if (priceQuantitys != null) {
                for (PriceQuantity priceQuantity : priceQuantitys) {
                    this.priceQuantity.add(priceQuantity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="priceQuantity")
        public TradeLotBuilder setPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            this.priceQuantity = priceQuantitys == null ? new ArrayList<PriceQuantity.PriceQuantityBuilder>() : (List)priceQuantitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TradeLot build() {
            return new TradeLotImpl(this);
        }

        @Override
        public TradeLotBuilder toBuilder() {
            return this;
        }

        @Override
        public TradeLotBuilder prune() {
            this.lotIdentifier = this.lotIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.priceQuantity = this.priceQuantity.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getLotIdentifier() != null && this.getLotIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPriceQuantity() != null && this.getPriceQuantity().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public TradeLotBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TradeLotBuilder o = (TradeLotBuilder)other;
            merger.mergeRosetta(this.getLotIdentifier(), o.getLotIdentifier(), this::getOrCreateLotIdentifier);
            merger.mergeRosetta(this.getPriceQuantity(), o.getPriceQuantity(), this::getOrCreatePriceQuantity);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradeLot _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.lotIdentifier, _that.getLotIdentifier())) {
                return false;
            }
            return ListEquals.listEquals(this.priceQuantity, _that.getPriceQuantity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.lotIdentifier != null ? this.lotIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.priceQuantity != null ? this.priceQuantity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeLotBuilder {lotIdentifier=" + this.lotIdentifier + ", priceQuantity=" + this.priceQuantity + '}';
        }
    }

    public static interface TradeLotBuilder
    extends TradeLot,
    RosettaModelObjectBuilder {
        public Identifier.IdentifierBuilder getOrCreateLotIdentifier(int var1);

        public List<? extends Identifier.IdentifierBuilder> getLotIdentifier();

        public PriceQuantity.PriceQuantityBuilder getOrCreatePriceQuantity(int var1);

        public List<? extends PriceQuantity.PriceQuantityBuilder> getPriceQuantity();

        public TradeLotBuilder addLotIdentifier(Identifier var1);

        public TradeLotBuilder addLotIdentifier(Identifier var1, int var2);

        public TradeLotBuilder addLotIdentifier(List<? extends Identifier> var1);

        public TradeLotBuilder setLotIdentifier(List<? extends Identifier> var1);

        public TradeLotBuilder addPriceQuantity(PriceQuantity var1);

        public TradeLotBuilder addPriceQuantity(PriceQuantity var1, int var2);

        public TradeLotBuilder addPriceQuantity(List<? extends PriceQuantity> var1);

        public TradeLotBuilder setPriceQuantity(List<? extends PriceQuantity> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("lotIdentifier"), processor, Identifier.IdentifierBuilder.class, this.getLotIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceQuantity"), processor, PriceQuantity.PriceQuantityBuilder.class, this.getPriceQuantity(), new AttributeMeta[0]);
        }

        public TradeLotBuilder prune();
    }

    public static class TradeLotImpl
    implements TradeLot {
        private final List<? extends Identifier> lotIdentifier;
        private final List<? extends PriceQuantity> priceQuantity;

        protected TradeLotImpl(TradeLotBuilder builder) {
            this.lotIdentifier = Optional.ofNullable(builder.getLotIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.priceQuantity = Optional.ofNullable(builder.getPriceQuantity()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="lotIdentifier")
        @RuneAttribute(value="lotIdentifier")
        public List<? extends Identifier> getLotIdentifier() {
            return this.lotIdentifier;
        }

        @Override
        @RosettaAttribute(value="priceQuantity", isRequired=true)
        @RuneAttribute(value="priceQuantity", isRequired=true)
        public List<? extends PriceQuantity> getPriceQuantity() {
            return this.priceQuantity;
        }

        @Override
        public TradeLot build() {
            return this;
        }

        @Override
        public TradeLotBuilder toBuilder() {
            TradeLotBuilder builder = TradeLot.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradeLotBuilder builder) {
            Optional.ofNullable(this.getLotIdentifier()).ifPresent(builder::setLotIdentifier);
            Optional.ofNullable(this.getPriceQuantity()).ifPresent(builder::setPriceQuantity);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradeLot _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.lotIdentifier, _that.getLotIdentifier())) {
                return false;
            }
            return ListEquals.listEquals(this.priceQuantity, _that.getPriceQuantity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.lotIdentifier != null ? this.lotIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.priceQuantity != null ? this.priceQuantity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeLot {lotIdentifier=" + this.lotIdentifier + ", priceQuantity=" + this.priceQuantity + '}';
        }
    }
}

