/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.observable.asset.Money;
import cdm.product.template.InitialMarginCalculation;
import cdm.product.template.MarginTypeEnum;
import cdm.product.template.meta.InitialMarginMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="InitialMargin", builder=InitialMarginBuilderImpl.class, version="5.28.0")
@RuneDataType(value="InitialMargin", model="cdm", builder=InitialMarginBuilderImpl.class, version="5.28.0")
public interface InitialMargin
extends RosettaModelObject {
    public static final InitialMarginMeta metaData = new InitialMarginMeta();

    public MarginTypeEnum getMarginType();

    public List<? extends InitialMarginCalculation> getMargin();

    public Money getMarginThreshold();

    public Money getMinimumTransferAmount();

    public InitialMargin build();

    public InitialMarginBuilder toBuilder();

    public static InitialMarginBuilder builder() {
        return new InitialMarginBuilderImpl();
    }

    default public RosettaMetaData<? extends InitialMargin> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends InitialMargin> getType() {
        return InitialMargin.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("marginType"), MarginTypeEnum.class, (Object)this.getMarginType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("margin"), processor, InitialMarginCalculation.class, this.getMargin(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("marginThreshold"), processor, Money.class, this.getMarginThreshold(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("minimumTransferAmount"), processor, Money.class, this.getMinimumTransferAmount(), new AttributeMeta[0]);
    }

    public static class InitialMarginBuilderImpl
    implements InitialMarginBuilder {
        protected MarginTypeEnum marginType;
        protected List<InitialMarginCalculation.InitialMarginCalculationBuilder> margin = new ArrayList<InitialMarginCalculation.InitialMarginCalculationBuilder>();
        protected Money.MoneyBuilder marginThreshold;
        protected Money.MoneyBuilder minimumTransferAmount;

        @Override
        @RosettaAttribute(value="marginType", isRequired=true)
        @RuneAttribute(value="marginType", isRequired=true)
        public MarginTypeEnum getMarginType() {
            return this.marginType;
        }

        @Override
        @RosettaAttribute(value="margin", isRequired=true)
        @RuneAttribute(value="margin", isRequired=true)
        public List<? extends InitialMarginCalculation.InitialMarginCalculationBuilder> getMargin() {
            return this.margin;
        }

        @Override
        public InitialMarginCalculation.InitialMarginCalculationBuilder getOrCreateMargin(int index) {
            if (this.margin == null) {
                this.margin = new ArrayList<InitialMarginCalculation.InitialMarginCalculationBuilder>();
            }
            return (InitialMarginCalculation.InitialMarginCalculationBuilder)this.getIndex(this.margin, index, () -> {
                InitialMarginCalculation.InitialMarginCalculationBuilder newMargin = InitialMarginCalculation.builder();
                return newMargin;
            });
        }

        @Override
        @RosettaAttribute(value="marginThreshold")
        @RuneAttribute(value="marginThreshold")
        public Money.MoneyBuilder getMarginThreshold() {
            return this.marginThreshold;
        }

        @Override
        public Money.MoneyBuilder getOrCreateMarginThreshold() {
            Money.MoneyBuilder result = this.marginThreshold != null ? this.marginThreshold : (this.marginThreshold = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="minimumTransferAmount")
        @RuneAttribute(value="minimumTransferAmount")
        public Money.MoneyBuilder getMinimumTransferAmount() {
            return this.minimumTransferAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateMinimumTransferAmount() {
            Money.MoneyBuilder result = this.minimumTransferAmount != null ? this.minimumTransferAmount : (this.minimumTransferAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="marginType", isRequired=true)
        @RuneAttribute(value="marginType", isRequired=true)
        public InitialMarginBuilder setMarginType(MarginTypeEnum _marginType) {
            this.marginType = _marginType == null ? null : _marginType;
            return this;
        }

        @Override
        @RosettaAttribute(value="margin", isRequired=true)
        @RuneAttribute(value="margin", isRequired=true)
        public InitialMarginBuilder addMargin(InitialMarginCalculation _margin) {
            if (_margin != null) {
                this.margin.add(_margin.toBuilder());
            }
            return this;
        }

        @Override
        public InitialMarginBuilder addMargin(InitialMarginCalculation _margin, int idx) {
            this.getIndex(this.margin, idx, () -> _margin.toBuilder());
            return this;
        }

        @Override
        public InitialMarginBuilder addMargin(List<? extends InitialMarginCalculation> margins) {
            if (margins != null) {
                for (InitialMarginCalculation initialMarginCalculation : margins) {
                    this.margin.add(initialMarginCalculation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="margin")
        public InitialMarginBuilder setMargin(List<? extends InitialMarginCalculation> margins) {
            this.margin = margins == null ? new ArrayList<InitialMarginCalculation.InitialMarginCalculationBuilder>() : (List)margins.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="marginThreshold")
        @RuneAttribute(value="marginThreshold")
        public InitialMarginBuilder setMarginThreshold(Money _marginThreshold) {
            this.marginThreshold = _marginThreshold == null ? null : _marginThreshold.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="minimumTransferAmount")
        @RuneAttribute(value="minimumTransferAmount")
        public InitialMarginBuilder setMinimumTransferAmount(Money _minimumTransferAmount) {
            this.minimumTransferAmount = _minimumTransferAmount == null ? null : _minimumTransferAmount.toBuilder();
            return this;
        }

        @Override
        public InitialMargin build() {
            return new InitialMarginImpl(this);
        }

        @Override
        public InitialMarginBuilder toBuilder() {
            return this;
        }

        @Override
        public InitialMarginBuilder prune() {
            this.margin = this.margin.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.marginThreshold != null && !this.marginThreshold.prune().hasData()) {
                this.marginThreshold = null;
            }
            if (this.minimumTransferAmount != null && !this.minimumTransferAmount.prune().hasData()) {
                this.minimumTransferAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getMarginType() != null) {
                return true;
            }
            if (this.getMargin() != null && this.getMargin().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getMarginThreshold() != null && this.getMarginThreshold().hasData()) {
                return true;
            }
            return this.getMinimumTransferAmount() != null && this.getMinimumTransferAmount().hasData();
        }

        public InitialMarginBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            InitialMarginBuilder o = (InitialMarginBuilder)other;
            merger.mergeRosetta(this.getMargin(), o.getMargin(), this::getOrCreateMargin);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMarginThreshold(), (RosettaModelObjectBuilder)o.getMarginThreshold(), this::setMarginThreshold);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMinimumTransferAmount(), (RosettaModelObjectBuilder)o.getMinimumTransferAmount(), this::setMinimumTransferAmount);
            merger.mergeBasic((Object)this.getMarginType(), (Object)o.getMarginType(), this::setMarginType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            InitialMargin _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.marginType, (Object)_that.getMarginType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.margin, _that.getMargin())) {
                return false;
            }
            if (!Objects.equals(this.marginThreshold, _that.getMarginThreshold())) {
                return false;
            }
            return Objects.equals(this.minimumTransferAmount, _that.getMinimumTransferAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.marginType != null ? ((Object)((Object)this.marginType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.margin != null ? this.margin.hashCode() : 0);
            _result = 31 * _result + (this.marginThreshold != null ? this.marginThreshold.hashCode() : 0);
            _result = 31 * _result + (this.minimumTransferAmount != null ? this.minimumTransferAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "InitialMarginBuilder {marginType=" + (Object)((Object)this.marginType) + ", margin=" + this.margin + ", marginThreshold=" + this.marginThreshold + ", minimumTransferAmount=" + this.minimumTransferAmount + '}';
        }
    }

    public static interface InitialMarginBuilder
    extends InitialMargin,
    RosettaModelObjectBuilder {
        public InitialMarginCalculation.InitialMarginCalculationBuilder getOrCreateMargin(int var1);

        public List<? extends InitialMarginCalculation.InitialMarginCalculationBuilder> getMargin();

        public Money.MoneyBuilder getOrCreateMarginThreshold();

        @Override
        public Money.MoneyBuilder getMarginThreshold();

        public Money.MoneyBuilder getOrCreateMinimumTransferAmount();

        @Override
        public Money.MoneyBuilder getMinimumTransferAmount();

        public InitialMarginBuilder setMarginType(MarginTypeEnum var1);

        public InitialMarginBuilder addMargin(InitialMarginCalculation var1);

        public InitialMarginBuilder addMargin(InitialMarginCalculation var1, int var2);

        public InitialMarginBuilder addMargin(List<? extends InitialMarginCalculation> var1);

        public InitialMarginBuilder setMargin(List<? extends InitialMarginCalculation> var1);

        public InitialMarginBuilder setMarginThreshold(Money var1);

        public InitialMarginBuilder setMinimumTransferAmount(Money var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("marginType"), MarginTypeEnum.class, (Object)this.getMarginType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("margin"), processor, InitialMarginCalculation.InitialMarginCalculationBuilder.class, this.getMargin(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("marginThreshold"), processor, Money.MoneyBuilder.class, this.getMarginThreshold(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("minimumTransferAmount"), processor, Money.MoneyBuilder.class, this.getMinimumTransferAmount(), new AttributeMeta[0]);
        }

        public InitialMarginBuilder prune();
    }

    public static class InitialMarginImpl
    implements InitialMargin {
        private final MarginTypeEnum marginType;
        private final List<? extends InitialMarginCalculation> margin;
        private final Money marginThreshold;
        private final Money minimumTransferAmount;

        protected InitialMarginImpl(InitialMarginBuilder builder) {
            this.marginType = builder.getMarginType();
            this.margin = Optional.ofNullable(builder.getMargin()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.marginThreshold = Optional.ofNullable(builder.getMarginThreshold()).map(f -> f.build()).orElse(null);
            this.minimumTransferAmount = Optional.ofNullable(builder.getMinimumTransferAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="marginType", isRequired=true)
        @RuneAttribute(value="marginType", isRequired=true)
        public MarginTypeEnum getMarginType() {
            return this.marginType;
        }

        @Override
        @RosettaAttribute(value="margin", isRequired=true)
        @RuneAttribute(value="margin", isRequired=true)
        public List<? extends InitialMarginCalculation> getMargin() {
            return this.margin;
        }

        @Override
        @RosettaAttribute(value="marginThreshold")
        @RuneAttribute(value="marginThreshold")
        public Money getMarginThreshold() {
            return this.marginThreshold;
        }

        @Override
        @RosettaAttribute(value="minimumTransferAmount")
        @RuneAttribute(value="minimumTransferAmount")
        public Money getMinimumTransferAmount() {
            return this.minimumTransferAmount;
        }

        @Override
        public InitialMargin build() {
            return this;
        }

        @Override
        public InitialMarginBuilder toBuilder() {
            InitialMarginBuilder builder = InitialMargin.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InitialMarginBuilder builder) {
            Optional.ofNullable(this.getMarginType()).ifPresent(builder::setMarginType);
            Optional.ofNullable(this.getMargin()).ifPresent(builder::setMargin);
            Optional.ofNullable(this.getMarginThreshold()).ifPresent(builder::setMarginThreshold);
            Optional.ofNullable(this.getMinimumTransferAmount()).ifPresent(builder::setMinimumTransferAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            InitialMargin _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.marginType, (Object)_that.getMarginType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.margin, _that.getMargin())) {
                return false;
            }
            if (!Objects.equals(this.marginThreshold, _that.getMarginThreshold())) {
                return false;
            }
            return Objects.equals(this.minimumTransferAmount, _that.getMinimumTransferAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.marginType != null ? ((Object)((Object)this.marginType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.margin != null ? this.margin.hashCode() : 0);
            _result = 31 * _result + (this.marginThreshold != null ? this.marginThreshold.hashCode() : 0);
            _result = 31 * _result + (this.minimumTransferAmount != null ? this.minimumTransferAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "InitialMargin {marginType=" + (Object)((Object)this.marginType) + ", margin=" + this.margin + ", marginThreshold=" + this.marginThreshold + ", minimumTransferAmount=" + this.minimumTransferAmount + '}';
        }
    }
}

