/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.asset.common.ProductBase;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.product.template.BasketConstituent;
import cdm.product.template.Product;
import cdm.product.template.meta.BasketMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneScopedAttributeReference;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Basket", builder=BasketBuilderImpl.class, version="5.28.0")
@RuneDataType(value="Basket", model="cdm", builder=BasketBuilderImpl.class, version="5.28.0")
public interface Basket
extends ProductBase {
    public static final BasketMeta metaData = new BasketMeta();

    public List<? extends Product> getBasketConstituent();

    public List<? extends BasketConstituent> getPortfolioBasketConstituent();

    @Override
    public Basket build();

    @Override
    public BasketBuilder toBuilder();

    public static BasketBuilder builder() {
        return new BasketBuilderImpl();
    }

    default public RosettaMetaData<? extends Basket> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Basket> getType() {
        return Basket.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productTaxonomy"), processor, ProductTaxonomy.class, this.getProductTaxonomy(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productIdentifier"), processor, ReferenceWithMetaProductIdentifier.class, this.getProductIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketConstituent"), processor, Product.class, this.getBasketConstituent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("portfolioBasketConstituent"), processor, BasketConstituent.class, this.getPortfolioBasketConstituent(), new AttributeMeta[0]);
    }

    public static class BasketBuilderImpl
    extends ProductBase.ProductBaseBuilderImpl
    implements BasketBuilder {
        protected List<Product.ProductBuilder> basketConstituent = new ArrayList<Product.ProductBuilder>();
        protected List<BasketConstituent.BasketConstituentBuilder> portfolioBasketConstituent = new ArrayList<BasketConstituent.BasketConstituentBuilder>();

        @Override
        @RosettaAttribute(value="basketConstituent")
        @RuneAttribute(value="basketConstituent")
        public List<? extends Product.ProductBuilder> getBasketConstituent() {
            return this.basketConstituent;
        }

        @Override
        public Product.ProductBuilder getOrCreateBasketConstituent(int index) {
            if (this.basketConstituent == null) {
                this.basketConstituent = new ArrayList<Product.ProductBuilder>();
            }
            return (Product.ProductBuilder)this.getIndex(this.basketConstituent, index, () -> {
                Product.ProductBuilder newBasketConstituent = Product.builder();
                return newBasketConstituent;
            });
        }

        @Override
        @RosettaAttribute(value="portfolioBasketConstituent")
        @RuneAttribute(value="portfolioBasketConstituent")
        public List<? extends BasketConstituent.BasketConstituentBuilder> getPortfolioBasketConstituent() {
            return this.portfolioBasketConstituent;
        }

        @Override
        public BasketConstituent.BasketConstituentBuilder getOrCreatePortfolioBasketConstituent(int index) {
            if (this.portfolioBasketConstituent == null) {
                this.portfolioBasketConstituent = new ArrayList<BasketConstituent.BasketConstituentBuilder>();
            }
            return (BasketConstituent.BasketConstituentBuilder)this.getIndex(this.portfolioBasketConstituent, index, () -> {
                BasketConstituent.BasketConstituentBuilder newPortfolioBasketConstituent = BasketConstituent.builder();
                return newPortfolioBasketConstituent;
            });
        }

        @Override
        @RosettaAttribute(value="productTaxonomy")
        @RuneAttribute(value="productTaxonomy")
        public BasketBuilder addProductTaxonomy(ProductTaxonomy _productTaxonomy) {
            if (_productTaxonomy != null) {
                this.productTaxonomy.add(_productTaxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public BasketBuilder addProductTaxonomy(ProductTaxonomy _productTaxonomy, int idx) {
            this.getIndex(this.productTaxonomy, idx, () -> _productTaxonomy.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addProductTaxonomy(List<? extends ProductTaxonomy> productTaxonomys) {
            if (productTaxonomys != null) {
                for (ProductTaxonomy productTaxonomy : productTaxonomys) {
                    this.productTaxonomy.add(productTaxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productTaxonomy")
        public BasketBuilder setProductTaxonomy(List<? extends ProductTaxonomy> productTaxonomys) {
            this.productTaxonomy = productTaxonomys == null ? new ArrayList() : (List)productTaxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="productIdentifier")
        @RuneAttribute(value="productIdentifier")
        @RuneScopedAttributeReference
        public BasketBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier _productIdentifier) {
            if (_productIdentifier != null) {
                this.productIdentifier.add(_productIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public BasketBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier _productIdentifier, int idx) {
            this.getIndex(this.productIdentifier, idx, () -> _productIdentifier.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addProductIdentifierValue(ProductIdentifier _productIdentifier) {
            this.getOrCreateProductIdentifier(-1).setValue(_productIdentifier.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addProductIdentifierValue(ProductIdentifier _productIdentifier, int idx) {
            this.getOrCreateProductIdentifier(idx).setValue(_productIdentifier.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ReferenceWithMetaProductIdentifier referenceWithMetaProductIdentifier : productIdentifiers) {
                    this.productIdentifier.add(referenceWithMetaProductIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productIdentifier")
        @RuneScopedAttributeReference
        public BasketBuilder setProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> productIdentifiers) {
            this.productIdentifier = productIdentifiers == null ? new ArrayList() : (List)productIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public BasketBuilder addProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ProductIdentifier productIdentifier : productIdentifiers) {
                    this.addProductIdentifierValue(productIdentifier);
                }
            }
            return this;
        }

        @Override
        public BasketBuilder setProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            this.productIdentifier.clear();
            if (productIdentifiers != null) {
                productIdentifiers.forEach(this::addProductIdentifierValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="basketConstituent")
        @RuneAttribute(value="basketConstituent")
        public BasketBuilder addBasketConstituent(Product _basketConstituent) {
            if (_basketConstituent != null) {
                this.basketConstituent.add(_basketConstituent.toBuilder());
            }
            return this;
        }

        @Override
        public BasketBuilder addBasketConstituent(Product _basketConstituent, int idx) {
            this.getIndex(this.basketConstituent, idx, () -> _basketConstituent.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addBasketConstituent(List<? extends Product> basketConstituents) {
            if (basketConstituents != null) {
                for (Product product : basketConstituents) {
                    this.basketConstituent.add(product.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="basketConstituent")
        public BasketBuilder setBasketConstituent(List<? extends Product> basketConstituents) {
            this.basketConstituent = basketConstituents == null ? new ArrayList<Product.ProductBuilder>() : (List)basketConstituents.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolioBasketConstituent")
        @RuneAttribute(value="portfolioBasketConstituent")
        public BasketBuilder addPortfolioBasketConstituent(BasketConstituent _portfolioBasketConstituent) {
            if (_portfolioBasketConstituent != null) {
                this.portfolioBasketConstituent.add(_portfolioBasketConstituent.toBuilder());
            }
            return this;
        }

        @Override
        public BasketBuilder addPortfolioBasketConstituent(BasketConstituent _portfolioBasketConstituent, int idx) {
            this.getIndex(this.portfolioBasketConstituent, idx, () -> _portfolioBasketConstituent.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addPortfolioBasketConstituent(List<? extends BasketConstituent> portfolioBasketConstituents) {
            if (portfolioBasketConstituents != null) {
                for (BasketConstituent basketConstituent : portfolioBasketConstituents) {
                    this.portfolioBasketConstituent.add(basketConstituent.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="portfolioBasketConstituent")
        public BasketBuilder setPortfolioBasketConstituent(List<? extends BasketConstituent> portfolioBasketConstituents) {
            this.portfolioBasketConstituent = portfolioBasketConstituents == null ? new ArrayList<BasketConstituent.BasketConstituentBuilder>() : (List)portfolioBasketConstituents.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Basket build() {
            return new BasketImpl(this);
        }

        @Override
        public BasketBuilder toBuilder() {
            return this;
        }

        @Override
        public BasketBuilder prune() {
            super.prune();
            this.basketConstituent = this.basketConstituent.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.portfolioBasketConstituent = this.portfolioBasketConstituent.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBasketConstituent() != null && this.getBasketConstituent().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPortfolioBasketConstituent() != null && this.getPortfolioBasketConstituent().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public BasketBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            BasketBuilder o = (BasketBuilder)other;
            merger.mergeRosetta(this.getBasketConstituent(), o.getBasketConstituent(), this::getOrCreateBasketConstituent);
            merger.mergeRosetta(this.getPortfolioBasketConstituent(), o.getPortfolioBasketConstituent(), this::getOrCreatePortfolioBasketConstituent);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Basket _that = (Basket)this.getType().cast(o);
            if (!ListEquals.listEquals(this.basketConstituent, _that.getBasketConstituent())) {
                return false;
            }
            return ListEquals.listEquals(this.portfolioBasketConstituent, _that.getPortfolioBasketConstituent());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.basketConstituent != null ? this.basketConstituent.hashCode() : 0);
            _result = 31 * _result + (this.portfolioBasketConstituent != null ? this.portfolioBasketConstituent.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BasketBuilder {basketConstituent=" + this.basketConstituent + ", portfolioBasketConstituent=" + this.portfolioBasketConstituent + '}' + " " + super.toString();
        }
    }

    public static interface BasketBuilder
    extends Basket,
    ProductBase.ProductBaseBuilder {
        public Product.ProductBuilder getOrCreateBasketConstituent(int var1);

        public List<? extends Product.ProductBuilder> getBasketConstituent();

        public BasketConstituent.BasketConstituentBuilder getOrCreatePortfolioBasketConstituent(int var1);

        public List<? extends BasketConstituent.BasketConstituentBuilder> getPortfolioBasketConstituent();

        @Override
        public BasketBuilder addProductTaxonomy(ProductTaxonomy var1);

        @Override
        public BasketBuilder addProductTaxonomy(ProductTaxonomy var1, int var2);

        @Override
        public BasketBuilder addProductTaxonomy(List<? extends ProductTaxonomy> var1);

        @Override
        public BasketBuilder setProductTaxonomy(List<? extends ProductTaxonomy> var1);

        @Override
        public BasketBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier var1);

        @Override
        public BasketBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier var1, int var2);

        @Override
        public BasketBuilder addProductIdentifierValue(ProductIdentifier var1);

        @Override
        public BasketBuilder addProductIdentifierValue(ProductIdentifier var1, int var2);

        @Override
        public BasketBuilder addProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> var1);

        @Override
        public BasketBuilder setProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> var1);

        @Override
        public BasketBuilder addProductIdentifierValue(List<? extends ProductIdentifier> var1);

        @Override
        public BasketBuilder setProductIdentifierValue(List<? extends ProductIdentifier> var1);

        public BasketBuilder addBasketConstituent(Product var1);

        public BasketBuilder addBasketConstituent(Product var1, int var2);

        public BasketBuilder addBasketConstituent(List<? extends Product> var1);

        public BasketBuilder setBasketConstituent(List<? extends Product> var1);

        public BasketBuilder addPortfolioBasketConstituent(BasketConstituent var1);

        public BasketBuilder addPortfolioBasketConstituent(BasketConstituent var1, int var2);

        public BasketBuilder addPortfolioBasketConstituent(List<? extends BasketConstituent> var1);

        public BasketBuilder setPortfolioBasketConstituent(List<? extends BasketConstituent> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productTaxonomy"), processor, ProductTaxonomy.ProductTaxonomyBuilder.class, this.getProductTaxonomy(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productIdentifier"), processor, ReferenceWithMetaProductIdentifier.ReferenceWithMetaProductIdentifierBuilder.class, this.getProductIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketConstituent"), processor, Product.ProductBuilder.class, this.getBasketConstituent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("portfolioBasketConstituent"), processor, BasketConstituent.BasketConstituentBuilder.class, this.getPortfolioBasketConstituent(), new AttributeMeta[0]);
        }

        @Override
        public BasketBuilder prune();
    }

    public static class BasketImpl
    extends ProductBase.ProductBaseImpl
    implements Basket {
        private final List<? extends Product> basketConstituent;
        private final List<? extends BasketConstituent> portfolioBasketConstituent;

        protected BasketImpl(BasketBuilder builder) {
            super(builder);
            this.basketConstituent = Optional.ofNullable(builder.getBasketConstituent()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.portfolioBasketConstituent = Optional.ofNullable(builder.getPortfolioBasketConstituent()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="basketConstituent")
        @RuneAttribute(value="basketConstituent")
        public List<? extends Product> getBasketConstituent() {
            return this.basketConstituent;
        }

        @Override
        @RosettaAttribute(value="portfolioBasketConstituent")
        @RuneAttribute(value="portfolioBasketConstituent")
        public List<? extends BasketConstituent> getPortfolioBasketConstituent() {
            return this.portfolioBasketConstituent;
        }

        @Override
        public Basket build() {
            return this;
        }

        @Override
        public BasketBuilder toBuilder() {
            BasketBuilder builder = Basket.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BasketBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBasketConstituent()).ifPresent(builder::setBasketConstituent);
            Optional.ofNullable(this.getPortfolioBasketConstituent()).ifPresent(builder::setPortfolioBasketConstituent);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Basket _that = (Basket)this.getType().cast(o);
            if (!ListEquals.listEquals(this.basketConstituent, _that.getBasketConstituent())) {
                return false;
            }
            return ListEquals.listEquals(this.portfolioBasketConstituent, _that.getPortfolioBasketConstituent());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.basketConstituent != null ? this.basketConstituent.hashCode() : 0);
            _result = 31 * _result + (this.portfolioBasketConstituent != null ? this.portfolioBasketConstituent.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Basket {basketConstituent=" + this.basketConstituent + ", portfolioBasketConstituent=" + this.portfolioBasketConstituent + '}' + " " + super.toString();
        }
    }
}

