/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.validation.datarule;

import cdm.product.common.settlement.Cashflow;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CashflowCashflowAmount")
@ImplementedBy(value=Default.class)
public interface CashflowCashflowAmount
extends Validator<Cashflow> {
    public static final String NAME = "CashflowCashflowAmount";
    public static final String DEFINITION = "if priceQuantity exists then priceQuantity -> quantitySchedule -> value >= 0.0";

    public static class NoOp
    implements CashflowCashflowAmount {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Cashflow cashflow) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CashflowCashflowAmount {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Cashflow cashflow) {
            ComparisonResult result = this.executeDataRule(cashflow);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CashflowCashflowAmount.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Cashflow", (RosettaPath)path, (String)CashflowCashflowAmount.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CashflowCashflowAmount.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Cashflow", (RosettaPath)path, (String)CashflowCashflowAmount.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Cashflow cashflow) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)cashflow).map("getPriceQuantity", _cashflow -> _cashflow.getPriceQuantity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)cashflow).map("getPriceQuantity", _cashflow -> _cashflow.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), (Mapper)MapperS.of((Object)new BigDecimal("0.0")), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

