/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.processor;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.processor.PriceQuantityHelper;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.util.PathUtils;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.meta.Reference;
import com.rosetta.model.lib.path.RosettaPath;
import java.math.BigDecimal;
import java.util.List;

public class NumberOfOptionsMappingProcessor
extends MappingProcessor {
    private static final Path EQUITY_UNDERLIER_PATH = Path.parse((String)"underlyer.singleUnderlyer.equity.instrumentId");
    private static final Path INDEX_UNDERLIER_PATH = Path.parse((String)"underlyer.singleUnderlyer.index.instrumentId");

    public NumberOfOptionsMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builder, RosettaModelObjectBuilder parent) {
        NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantity = NonNegativeQuantitySchedule.builder();
        this.setAmountAndUnit(synonymPath, quantity, builder.size());
        this.setMultiplierAndUnit(synonymPath, quantity);
        if (quantity.hasData()) {
            ((PriceQuantity.PriceQuantityBuilder)parent).addQuantity(PriceQuantityHelper.toReferencableQuantityBuilder(quantity));
        }
    }

    private void setAmountAndUnit(Path synonymPath, NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantityBuilder, int index) {
        Path baseModelPath = PathUtils.toPath((RosettaPath)this.getModelPath());
        Path mappedModelPath = PriceQuantityHelper.incrementPathElementIndex(baseModelPath, "quantity", index);
        MappingProcessorUtils.getNonNullMappedValue((Path)synonymPath, (List)this.getMappings()).ifPresent(xmlValue -> {
            quantityBuilder.setValue(new BigDecimal((String)xmlValue)).setUnit(UnitType.builder().setFinancialUnit(FinancialUnitEnum.CONTRACT));
            this.addMapping(synonymPath, xmlValue, mappedModelPath, xmlValue);
            this.updateReferenceMapping(synonymPath);
        });
    }

    private void setMultiplierAndUnit(Path synonymPath, NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantity) {
        Path parentSynonymPath = synonymPath.getParent();
        this.setValueAndUpdateMappings(parentSynonymPath.addElement("optionEntitlement"), xmlValue -> quantity.getOrCreateMultiplier().setValue(new BigDecimal((String)xmlValue)));
        this.setValueAndUpdateMappings(parentSynonymPath.addElement("entitlementCurrency"), xmlValue -> quantity.getOrCreateMultiplier().setUnit(UnitType.builder().setCurrencyValue((String)xmlValue)));
        this.setValueAndUpdateMappings(parentSynonymPath.addElement("entitlementCurrency").addElement("currencyScheme"), xmlValue -> quantity.getOrCreateMultiplier().getOrCreateUnit().getOrCreateCurrency().getOrCreateMeta().setScheme(xmlValue));
        if (this.pathExists(EQUITY_UNDERLIER_PATH)) {
            quantity.getOrCreateMultiplier().setUnit(UnitType.builder().setFinancialUnit(FinancialUnitEnum.SHARE));
        }
        if (this.pathExists(INDEX_UNDERLIER_PATH)) {
            quantity.getOrCreateMultiplier().setUnit(UnitType.builder().setFinancialUnit(FinancialUnitEnum.INDEX_UNIT));
        }
    }

    private boolean pathExists(Path endsWith) {
        return this.getMappings().stream().filter(m -> m.getXmlPath().endsWith(endsWith)).anyMatch(m -> m.getXmlValue() != null);
    }

    private void addMapping(Path xmlPath, Object xmlValue, Path modelPath, Object modelValue) {
        this.getMappings().add(new Mapping(xmlPath, xmlValue, modelPath, modelValue, null, true, true, false));
    }

    private void updateReferenceMapping(Path synonymPath) {
        this.getMappings().stream().filter(m -> m.getXmlPath().equals((Object)synonymPath)).filter(m -> m.getRosettaValue() instanceof Reference.ReferenceBuilder).filter(m -> m.getError() != null).forEach(m -> {
            m.setDuplicate(false);
            m.setError(null);
        });
    }
}

