/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.datetime.Period;
import cdm.base.math.Schedule;
import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.product.asset.RateTreatmentEnum;
import cdm.product.asset.SpreadSchedule;
import cdm.product.asset.meta.StubFloatingRateMeta;
import cdm.product.template.StrikeSchedule;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="StubFloatingRate", builder=StubFloatingRateBuilderImpl.class, version="5.28.0")
@RuneDataType(value="StubFloatingRate", model="cdm", builder=StubFloatingRateBuilderImpl.class, version="5.28.0")
public interface StubFloatingRate
extends RosettaModelObject {
    public static final StubFloatingRateMeta metaData = new StubFloatingRateMeta();

    public FloatingRateIndexEnum getFloatingRateIndex();

    public Period getIndexTenor();

    public Schedule getFloatingRateMultiplierSchedule();

    public List<? extends SpreadSchedule> getSpreadSchedule();

    public RateTreatmentEnum getRateTreatment();

    public List<? extends StrikeSchedule> getCapRateSchedule();

    public List<? extends StrikeSchedule> getFloorRateSchedule();

    public StubFloatingRate build();

    public StubFloatingRateBuilder toBuilder();

    public static StubFloatingRateBuilder builder() {
        return new StubFloatingRateBuilderImpl();
    }

    default public RosettaMetaData<? extends StubFloatingRate> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends StubFloatingRate> getType() {
        return StubFloatingRate.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("floatingRateIndex"), FloatingRateIndexEnum.class, (Object)this.getFloatingRateIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("indexTenor"), processor, Period.class, this.getIndexTenor(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingRateMultiplierSchedule"), processor, Schedule.class, this.getFloatingRateMultiplierSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spreadSchedule"), processor, SpreadSchedule.class, this.getSpreadSchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rateTreatment"), RateTreatmentEnum.class, (Object)this.getRateTreatment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("capRateSchedule"), processor, StrikeSchedule.class, this.getCapRateSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floorRateSchedule"), processor, StrikeSchedule.class, this.getFloorRateSchedule(), new AttributeMeta[0]);
    }

    public static class StubFloatingRateBuilderImpl
    implements StubFloatingRateBuilder {
        protected FloatingRateIndexEnum floatingRateIndex;
        protected Period.PeriodBuilder indexTenor;
        protected Schedule.ScheduleBuilder floatingRateMultiplierSchedule;
        protected List<SpreadSchedule.SpreadScheduleBuilder> spreadSchedule = new ArrayList<SpreadSchedule.SpreadScheduleBuilder>();
        protected RateTreatmentEnum rateTreatment;
        protected List<StrikeSchedule.StrikeScheduleBuilder> capRateSchedule = new ArrayList<StrikeSchedule.StrikeScheduleBuilder>();
        protected List<StrikeSchedule.StrikeScheduleBuilder> floorRateSchedule = new ArrayList<StrikeSchedule.StrikeScheduleBuilder>();

        @Override
        @RosettaAttribute(value="floatingRateIndex", isRequired=true)
        @RuneAttribute(value="floatingRateIndex", isRequired=true)
        public FloatingRateIndexEnum getFloatingRateIndex() {
            return this.floatingRateIndex;
        }

        @Override
        @RosettaAttribute(value="indexTenor")
        @RuneAttribute(value="indexTenor")
        public Period.PeriodBuilder getIndexTenor() {
            return this.indexTenor;
        }

        @Override
        public Period.PeriodBuilder getOrCreateIndexTenor() {
            Period.PeriodBuilder result = this.indexTenor != null ? this.indexTenor : (this.indexTenor = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="floatingRateMultiplierSchedule")
        @RuneAttribute(value="floatingRateMultiplierSchedule")
        public Schedule.ScheduleBuilder getFloatingRateMultiplierSchedule() {
            return this.floatingRateMultiplierSchedule;
        }

        @Override
        public Schedule.ScheduleBuilder getOrCreateFloatingRateMultiplierSchedule() {
            Schedule.ScheduleBuilder result = this.floatingRateMultiplierSchedule != null ? this.floatingRateMultiplierSchedule : (this.floatingRateMultiplierSchedule = Schedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spreadSchedule")
        @RuneAttribute(value="spreadSchedule")
        public List<? extends SpreadSchedule.SpreadScheduleBuilder> getSpreadSchedule() {
            return this.spreadSchedule;
        }

        @Override
        public SpreadSchedule.SpreadScheduleBuilder getOrCreateSpreadSchedule(int index) {
            if (this.spreadSchedule == null) {
                this.spreadSchedule = new ArrayList<SpreadSchedule.SpreadScheduleBuilder>();
            }
            return (SpreadSchedule.SpreadScheduleBuilder)this.getIndex(this.spreadSchedule, index, () -> {
                SpreadSchedule.SpreadScheduleBuilder newSpreadSchedule = SpreadSchedule.builder();
                return newSpreadSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="rateTreatment")
        @RuneAttribute(value="rateTreatment")
        public RateTreatmentEnum getRateTreatment() {
            return this.rateTreatment;
        }

        @Override
        @RosettaAttribute(value="capRateSchedule")
        @RuneAttribute(value="capRateSchedule")
        public List<? extends StrikeSchedule.StrikeScheduleBuilder> getCapRateSchedule() {
            return this.capRateSchedule;
        }

        @Override
        public StrikeSchedule.StrikeScheduleBuilder getOrCreateCapRateSchedule(int index) {
            if (this.capRateSchedule == null) {
                this.capRateSchedule = new ArrayList<StrikeSchedule.StrikeScheduleBuilder>();
            }
            return (StrikeSchedule.StrikeScheduleBuilder)this.getIndex(this.capRateSchedule, index, () -> {
                StrikeSchedule.StrikeScheduleBuilder newCapRateSchedule = StrikeSchedule.builder();
                return newCapRateSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="floorRateSchedule")
        @RuneAttribute(value="floorRateSchedule")
        public List<? extends StrikeSchedule.StrikeScheduleBuilder> getFloorRateSchedule() {
            return this.floorRateSchedule;
        }

        @Override
        public StrikeSchedule.StrikeScheduleBuilder getOrCreateFloorRateSchedule(int index) {
            if (this.floorRateSchedule == null) {
                this.floorRateSchedule = new ArrayList<StrikeSchedule.StrikeScheduleBuilder>();
            }
            return (StrikeSchedule.StrikeScheduleBuilder)this.getIndex(this.floorRateSchedule, index, () -> {
                StrikeSchedule.StrikeScheduleBuilder newFloorRateSchedule = StrikeSchedule.builder();
                return newFloorRateSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="floatingRateIndex", isRequired=true)
        @RuneAttribute(value="floatingRateIndex", isRequired=true)
        public StubFloatingRateBuilder setFloatingRateIndex(FloatingRateIndexEnum _floatingRateIndex) {
            this.floatingRateIndex = _floatingRateIndex == null ? null : _floatingRateIndex;
            return this;
        }

        @Override
        @RosettaAttribute(value="indexTenor")
        @RuneAttribute(value="indexTenor")
        public StubFloatingRateBuilder setIndexTenor(Period _indexTenor) {
            this.indexTenor = _indexTenor == null ? null : _indexTenor.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateMultiplierSchedule")
        @RuneAttribute(value="floatingRateMultiplierSchedule")
        public StubFloatingRateBuilder setFloatingRateMultiplierSchedule(Schedule _floatingRateMultiplierSchedule) {
            this.floatingRateMultiplierSchedule = _floatingRateMultiplierSchedule == null ? null : _floatingRateMultiplierSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadSchedule")
        @RuneAttribute(value="spreadSchedule")
        public StubFloatingRateBuilder addSpreadSchedule(SpreadSchedule _spreadSchedule) {
            if (_spreadSchedule != null) {
                this.spreadSchedule.add(_spreadSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public StubFloatingRateBuilder addSpreadSchedule(SpreadSchedule _spreadSchedule, int idx) {
            this.getIndex(this.spreadSchedule, idx, () -> _spreadSchedule.toBuilder());
            return this;
        }

        @Override
        public StubFloatingRateBuilder addSpreadSchedule(List<? extends SpreadSchedule> spreadSchedules) {
            if (spreadSchedules != null) {
                for (SpreadSchedule spreadSchedule : spreadSchedules) {
                    this.spreadSchedule.add(spreadSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="spreadSchedule")
        public StubFloatingRateBuilder setSpreadSchedule(List<? extends SpreadSchedule> spreadSchedules) {
            this.spreadSchedule = spreadSchedules == null ? new ArrayList<SpreadSchedule.SpreadScheduleBuilder>() : (List)spreadSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="rateTreatment")
        @RuneAttribute(value="rateTreatment")
        public StubFloatingRateBuilder setRateTreatment(RateTreatmentEnum _rateTreatment) {
            this.rateTreatment = _rateTreatment == null ? null : _rateTreatment;
            return this;
        }

        @Override
        @RosettaAttribute(value="capRateSchedule")
        @RuneAttribute(value="capRateSchedule")
        public StubFloatingRateBuilder addCapRateSchedule(StrikeSchedule _capRateSchedule) {
            if (_capRateSchedule != null) {
                this.capRateSchedule.add(_capRateSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public StubFloatingRateBuilder addCapRateSchedule(StrikeSchedule _capRateSchedule, int idx) {
            this.getIndex(this.capRateSchedule, idx, () -> _capRateSchedule.toBuilder());
            return this;
        }

        @Override
        public StubFloatingRateBuilder addCapRateSchedule(List<? extends StrikeSchedule> capRateSchedules) {
            if (capRateSchedules != null) {
                for (StrikeSchedule strikeSchedule : capRateSchedules) {
                    this.capRateSchedule.add(strikeSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="capRateSchedule")
        public StubFloatingRateBuilder setCapRateSchedule(List<? extends StrikeSchedule> capRateSchedules) {
            this.capRateSchedule = capRateSchedules == null ? new ArrayList<StrikeSchedule.StrikeScheduleBuilder>() : (List)capRateSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="floorRateSchedule")
        @RuneAttribute(value="floorRateSchedule")
        public StubFloatingRateBuilder addFloorRateSchedule(StrikeSchedule _floorRateSchedule) {
            if (_floorRateSchedule != null) {
                this.floorRateSchedule.add(_floorRateSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public StubFloatingRateBuilder addFloorRateSchedule(StrikeSchedule _floorRateSchedule, int idx) {
            this.getIndex(this.floorRateSchedule, idx, () -> _floorRateSchedule.toBuilder());
            return this;
        }

        @Override
        public StubFloatingRateBuilder addFloorRateSchedule(List<? extends StrikeSchedule> floorRateSchedules) {
            if (floorRateSchedules != null) {
                for (StrikeSchedule strikeSchedule : floorRateSchedules) {
                    this.floorRateSchedule.add(strikeSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="floorRateSchedule")
        public StubFloatingRateBuilder setFloorRateSchedule(List<? extends StrikeSchedule> floorRateSchedules) {
            this.floorRateSchedule = floorRateSchedules == null ? new ArrayList<StrikeSchedule.StrikeScheduleBuilder>() : (List)floorRateSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public StubFloatingRate build() {
            return new StubFloatingRateImpl(this);
        }

        @Override
        public StubFloatingRateBuilder toBuilder() {
            return this;
        }

        @Override
        public StubFloatingRateBuilder prune() {
            if (this.indexTenor != null && !this.indexTenor.prune().hasData()) {
                this.indexTenor = null;
            }
            if (this.floatingRateMultiplierSchedule != null && !this.floatingRateMultiplierSchedule.prune().hasData()) {
                this.floatingRateMultiplierSchedule = null;
            }
            this.spreadSchedule = this.spreadSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.capRateSchedule = this.capRateSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.floorRateSchedule = this.floorRateSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getFloatingRateIndex() != null) {
                return true;
            }
            if (this.getIndexTenor() != null && this.getIndexTenor().hasData()) {
                return true;
            }
            if (this.getFloatingRateMultiplierSchedule() != null && this.getFloatingRateMultiplierSchedule().hasData()) {
                return true;
            }
            if (this.getSpreadSchedule() != null && this.getSpreadSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getRateTreatment() != null) {
                return true;
            }
            if (this.getCapRateSchedule() != null && this.getCapRateSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getFloorRateSchedule() != null && this.getFloorRateSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public StubFloatingRateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            StubFloatingRateBuilder o = (StubFloatingRateBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndexTenor(), (RosettaModelObjectBuilder)o.getIndexTenor(), this::setIndexTenor);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingRateMultiplierSchedule(), (RosettaModelObjectBuilder)o.getFloatingRateMultiplierSchedule(), this::setFloatingRateMultiplierSchedule);
            merger.mergeRosetta(this.getSpreadSchedule(), o.getSpreadSchedule(), this::getOrCreateSpreadSchedule);
            merger.mergeRosetta(this.getCapRateSchedule(), o.getCapRateSchedule(), this::getOrCreateCapRateSchedule);
            merger.mergeRosetta(this.getFloorRateSchedule(), o.getFloorRateSchedule(), this::getOrCreateFloorRateSchedule);
            merger.mergeBasic((Object)this.getFloatingRateIndex(), (Object)o.getFloatingRateIndex(), this::setFloatingRateIndex, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRateTreatment(), (Object)o.getRateTreatment(), this::setRateTreatment, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            StubFloatingRate _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.floatingRateIndex, (Object)_that.getFloatingRateIndex())) {
                return false;
            }
            if (!Objects.equals(this.indexTenor, _that.getIndexTenor())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateMultiplierSchedule, _that.getFloatingRateMultiplierSchedule())) {
                return false;
            }
            if (!ListEquals.listEquals(this.spreadSchedule, _that.getSpreadSchedule())) {
                return false;
            }
            if (!Objects.equals((Object)this.rateTreatment, (Object)_that.getRateTreatment())) {
                return false;
            }
            if (!ListEquals.listEquals(this.capRateSchedule, _that.getCapRateSchedule())) {
                return false;
            }
            return ListEquals.listEquals(this.floorRateSchedule, _that.getFloorRateSchedule());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.floatingRateIndex != null ? ((Object)((Object)this.floatingRateIndex)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.indexTenor != null ? this.indexTenor.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateMultiplierSchedule != null ? this.floatingRateMultiplierSchedule.hashCode() : 0);
            _result = 31 * _result + (this.spreadSchedule != null ? this.spreadSchedule.hashCode() : 0);
            _result = 31 * _result + (this.rateTreatment != null ? ((Object)((Object)this.rateTreatment)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.capRateSchedule != null ? this.capRateSchedule.hashCode() : 0);
            _result = 31 * _result + (this.floorRateSchedule != null ? this.floorRateSchedule.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "StubFloatingRateBuilder {floatingRateIndex=" + (Object)((Object)this.floatingRateIndex) + ", indexTenor=" + this.indexTenor + ", floatingRateMultiplierSchedule=" + this.floatingRateMultiplierSchedule + ", spreadSchedule=" + this.spreadSchedule + ", rateTreatment=" + (Object)((Object)this.rateTreatment) + ", capRateSchedule=" + this.capRateSchedule + ", floorRateSchedule=" + this.floorRateSchedule + '}';
        }
    }

    public static interface StubFloatingRateBuilder
    extends StubFloatingRate,
    RosettaModelObjectBuilder {
        public Period.PeriodBuilder getOrCreateIndexTenor();

        @Override
        public Period.PeriodBuilder getIndexTenor();

        public Schedule.ScheduleBuilder getOrCreateFloatingRateMultiplierSchedule();

        @Override
        public Schedule.ScheduleBuilder getFloatingRateMultiplierSchedule();

        public SpreadSchedule.SpreadScheduleBuilder getOrCreateSpreadSchedule(int var1);

        public List<? extends SpreadSchedule.SpreadScheduleBuilder> getSpreadSchedule();

        public StrikeSchedule.StrikeScheduleBuilder getOrCreateCapRateSchedule(int var1);

        public List<? extends StrikeSchedule.StrikeScheduleBuilder> getCapRateSchedule();

        public StrikeSchedule.StrikeScheduleBuilder getOrCreateFloorRateSchedule(int var1);

        public List<? extends StrikeSchedule.StrikeScheduleBuilder> getFloorRateSchedule();

        public StubFloatingRateBuilder setFloatingRateIndex(FloatingRateIndexEnum var1);

        public StubFloatingRateBuilder setIndexTenor(Period var1);

        public StubFloatingRateBuilder setFloatingRateMultiplierSchedule(Schedule var1);

        public StubFloatingRateBuilder addSpreadSchedule(SpreadSchedule var1);

        public StubFloatingRateBuilder addSpreadSchedule(SpreadSchedule var1, int var2);

        public StubFloatingRateBuilder addSpreadSchedule(List<? extends SpreadSchedule> var1);

        public StubFloatingRateBuilder setSpreadSchedule(List<? extends SpreadSchedule> var1);

        public StubFloatingRateBuilder setRateTreatment(RateTreatmentEnum var1);

        public StubFloatingRateBuilder addCapRateSchedule(StrikeSchedule var1);

        public StubFloatingRateBuilder addCapRateSchedule(StrikeSchedule var1, int var2);

        public StubFloatingRateBuilder addCapRateSchedule(List<? extends StrikeSchedule> var1);

        public StubFloatingRateBuilder setCapRateSchedule(List<? extends StrikeSchedule> var1);

        public StubFloatingRateBuilder addFloorRateSchedule(StrikeSchedule var1);

        public StubFloatingRateBuilder addFloorRateSchedule(StrikeSchedule var1, int var2);

        public StubFloatingRateBuilder addFloorRateSchedule(List<? extends StrikeSchedule> var1);

        public StubFloatingRateBuilder setFloorRateSchedule(List<? extends StrikeSchedule> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("floatingRateIndex"), FloatingRateIndexEnum.class, (Object)this.getFloatingRateIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("indexTenor"), processor, Period.PeriodBuilder.class, this.getIndexTenor(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingRateMultiplierSchedule"), processor, Schedule.ScheduleBuilder.class, this.getFloatingRateMultiplierSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spreadSchedule"), processor, SpreadSchedule.SpreadScheduleBuilder.class, this.getSpreadSchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rateTreatment"), RateTreatmentEnum.class, (Object)this.getRateTreatment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("capRateSchedule"), processor, StrikeSchedule.StrikeScheduleBuilder.class, this.getCapRateSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floorRateSchedule"), processor, StrikeSchedule.StrikeScheduleBuilder.class, this.getFloorRateSchedule(), new AttributeMeta[0]);
        }

        public StubFloatingRateBuilder prune();
    }

    public static class StubFloatingRateImpl
    implements StubFloatingRate {
        private final FloatingRateIndexEnum floatingRateIndex;
        private final Period indexTenor;
        private final Schedule floatingRateMultiplierSchedule;
        private final List<? extends SpreadSchedule> spreadSchedule;
        private final RateTreatmentEnum rateTreatment;
        private final List<? extends StrikeSchedule> capRateSchedule;
        private final List<? extends StrikeSchedule> floorRateSchedule;

        protected StubFloatingRateImpl(StubFloatingRateBuilder builder) {
            this.floatingRateIndex = builder.getFloatingRateIndex();
            this.indexTenor = Optional.ofNullable(builder.getIndexTenor()).map(f -> f.build()).orElse(null);
            this.floatingRateMultiplierSchedule = Optional.ofNullable(builder.getFloatingRateMultiplierSchedule()).map(f -> f.build()).orElse(null);
            this.spreadSchedule = Optional.ofNullable(builder.getSpreadSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.rateTreatment = builder.getRateTreatment();
            this.capRateSchedule = Optional.ofNullable(builder.getCapRateSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.floorRateSchedule = Optional.ofNullable(builder.getFloorRateSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="floatingRateIndex", isRequired=true)
        @RuneAttribute(value="floatingRateIndex", isRequired=true)
        public FloatingRateIndexEnum getFloatingRateIndex() {
            return this.floatingRateIndex;
        }

        @Override
        @RosettaAttribute(value="indexTenor")
        @RuneAttribute(value="indexTenor")
        public Period getIndexTenor() {
            return this.indexTenor;
        }

        @Override
        @RosettaAttribute(value="floatingRateMultiplierSchedule")
        @RuneAttribute(value="floatingRateMultiplierSchedule")
        public Schedule getFloatingRateMultiplierSchedule() {
            return this.floatingRateMultiplierSchedule;
        }

        @Override
        @RosettaAttribute(value="spreadSchedule")
        @RuneAttribute(value="spreadSchedule")
        public List<? extends SpreadSchedule> getSpreadSchedule() {
            return this.spreadSchedule;
        }

        @Override
        @RosettaAttribute(value="rateTreatment")
        @RuneAttribute(value="rateTreatment")
        public RateTreatmentEnum getRateTreatment() {
            return this.rateTreatment;
        }

        @Override
        @RosettaAttribute(value="capRateSchedule")
        @RuneAttribute(value="capRateSchedule")
        public List<? extends StrikeSchedule> getCapRateSchedule() {
            return this.capRateSchedule;
        }

        @Override
        @RosettaAttribute(value="floorRateSchedule")
        @RuneAttribute(value="floorRateSchedule")
        public List<? extends StrikeSchedule> getFloorRateSchedule() {
            return this.floorRateSchedule;
        }

        @Override
        public StubFloatingRate build() {
            return this;
        }

        @Override
        public StubFloatingRateBuilder toBuilder() {
            StubFloatingRateBuilder builder = StubFloatingRate.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(StubFloatingRateBuilder builder) {
            Optional.ofNullable(this.getFloatingRateIndex()).ifPresent(builder::setFloatingRateIndex);
            Optional.ofNullable(this.getIndexTenor()).ifPresent(builder::setIndexTenor);
            Optional.ofNullable(this.getFloatingRateMultiplierSchedule()).ifPresent(builder::setFloatingRateMultiplierSchedule);
            Optional.ofNullable(this.getSpreadSchedule()).ifPresent(builder::setSpreadSchedule);
            Optional.ofNullable(this.getRateTreatment()).ifPresent(builder::setRateTreatment);
            Optional.ofNullable(this.getCapRateSchedule()).ifPresent(builder::setCapRateSchedule);
            Optional.ofNullable(this.getFloorRateSchedule()).ifPresent(builder::setFloorRateSchedule);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            StubFloatingRate _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.floatingRateIndex, (Object)_that.getFloatingRateIndex())) {
                return false;
            }
            if (!Objects.equals(this.indexTenor, _that.getIndexTenor())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateMultiplierSchedule, _that.getFloatingRateMultiplierSchedule())) {
                return false;
            }
            if (!ListEquals.listEquals(this.spreadSchedule, _that.getSpreadSchedule())) {
                return false;
            }
            if (!Objects.equals((Object)this.rateTreatment, (Object)_that.getRateTreatment())) {
                return false;
            }
            if (!ListEquals.listEquals(this.capRateSchedule, _that.getCapRateSchedule())) {
                return false;
            }
            return ListEquals.listEquals(this.floorRateSchedule, _that.getFloorRateSchedule());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.floatingRateIndex != null ? ((Object)((Object)this.floatingRateIndex)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.indexTenor != null ? this.indexTenor.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateMultiplierSchedule != null ? this.floatingRateMultiplierSchedule.hashCode() : 0);
            _result = 31 * _result + (this.spreadSchedule != null ? this.spreadSchedule.hashCode() : 0);
            _result = 31 * _result + (this.rateTreatment != null ? ((Object)((Object)this.rateTreatment)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.capRateSchedule != null ? this.capRateSchedule.hashCode() : 0);
            _result = 31 * _result + (this.floorRateSchedule != null ? this.floorRateSchedule.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "StubFloatingRate {floatingRateIndex=" + (Object)((Object)this.floatingRateIndex) + ", indexTenor=" + this.indexTenor + ", floatingRateMultiplierSchedule=" + this.floatingRateMultiplierSchedule + ", spreadSchedule=" + this.spreadSchedule + ", rateTreatment=" + (Object)((Object)this.rateTreatment) + ", capRateSchedule=" + this.capRateSchedule + ", floorRateSchedule=" + this.floorRateSchedule + '}';
        }
    }
}

