/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.event;

import cdm.observable.asset.Price;
import cdm.observable.event.ObservationIdentifier;
import cdm.observable.event.meta.ObservationMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Observation", builder=ObservationBuilderImpl.class, version="5.28.0")
@RuneDataType(value="Observation", model="cdm", builder=ObservationBuilderImpl.class, version="5.28.0")
public interface Observation
extends RosettaModelObject,
GlobalKey {
    public static final ObservationMeta metaData = new ObservationMeta();

    public Price getObservedValue();

    public ObservationIdentifier getObservationIdentifier();

    public MetaFields getMeta();

    public Observation build();

    public ObservationBuilder toBuilder();

    public static ObservationBuilder builder() {
        return new ObservationBuilderImpl();
    }

    default public RosettaMetaData<? extends Observation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Observation> getType() {
        return Observation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("observedValue"), processor, Price.class, this.getObservedValue(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationIdentifier"), processor, ObservationIdentifier.class, this.getObservationIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class ObservationBuilderImpl
    implements ObservationBuilder {
        protected Price.PriceBuilder observedValue;
        protected ObservationIdentifier.ObservationIdentifierBuilder observationIdentifier;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="observedValue", isRequired=true)
        @RuneAttribute(value="observedValue", isRequired=true)
        public Price.PriceBuilder getObservedValue() {
            return this.observedValue;
        }

        @Override
        public Price.PriceBuilder getOrCreateObservedValue() {
            Price.PriceBuilder result = this.observedValue != null ? this.observedValue : (this.observedValue = Price.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="observationIdentifier", isRequired=true)
        @RuneAttribute(value="observationIdentifier", isRequired=true)
        public ObservationIdentifier.ObservationIdentifierBuilder getObservationIdentifier() {
            return this.observationIdentifier;
        }

        @Override
        public ObservationIdentifier.ObservationIdentifierBuilder getOrCreateObservationIdentifier() {
            ObservationIdentifier.ObservationIdentifierBuilder result = this.observationIdentifier != null ? this.observationIdentifier : (this.observationIdentifier = ObservationIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="observedValue", isRequired=true)
        @RuneAttribute(value="observedValue", isRequired=true)
        public ObservationBuilder setObservedValue(Price _observedValue) {
            this.observedValue = _observedValue == null ? null : _observedValue.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="observationIdentifier", isRequired=true)
        @RuneAttribute(value="observationIdentifier", isRequired=true)
        public ObservationBuilder setObservationIdentifier(ObservationIdentifier _observationIdentifier) {
            this.observationIdentifier = _observationIdentifier == null ? null : _observationIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public ObservationBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public Observation build() {
            return new ObservationImpl(this);
        }

        @Override
        public ObservationBuilder toBuilder() {
            return this;
        }

        @Override
        public ObservationBuilder prune() {
            if (this.observedValue != null && !this.observedValue.prune().hasData()) {
                this.observedValue = null;
            }
            if (this.observationIdentifier != null && !this.observationIdentifier.prune().hasData()) {
                this.observationIdentifier = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getObservedValue() != null && this.getObservedValue().hasData()) {
                return true;
            }
            return this.getObservationIdentifier() != null && this.getObservationIdentifier().hasData();
        }

        public ObservationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ObservationBuilder o = (ObservationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservedValue(), (RosettaModelObjectBuilder)o.getObservedValue(), this::setObservedValue);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservationIdentifier(), (RosettaModelObjectBuilder)o.getObservationIdentifier(), this::setObservationIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Observation _that = this.getType().cast(o);
            if (!Objects.equals(this.observedValue, _that.getObservedValue())) {
                return false;
            }
            if (!Objects.equals(this.observationIdentifier, _that.getObservationIdentifier())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observedValue != null ? this.observedValue.hashCode() : 0);
            _result = 31 * _result + (this.observationIdentifier != null ? this.observationIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationBuilder {observedValue=" + this.observedValue + ", observationIdentifier=" + this.observationIdentifier + ", meta=" + this.meta + '}';
        }
    }

    public static interface ObservationBuilder
    extends Observation,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public Price.PriceBuilder getOrCreateObservedValue();

        @Override
        public Price.PriceBuilder getObservedValue();

        public ObservationIdentifier.ObservationIdentifierBuilder getOrCreateObservationIdentifier();

        @Override
        public ObservationIdentifier.ObservationIdentifierBuilder getObservationIdentifier();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public ObservationBuilder setObservedValue(Price var1);

        public ObservationBuilder setObservationIdentifier(ObservationIdentifier var1);

        public ObservationBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("observedValue"), processor, Price.PriceBuilder.class, this.getObservedValue(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationIdentifier"), processor, ObservationIdentifier.ObservationIdentifierBuilder.class, this.getObservationIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public ObservationBuilder prune();
    }

    public static class ObservationImpl
    implements Observation {
        private final Price observedValue;
        private final ObservationIdentifier observationIdentifier;
        private final MetaFields meta;

        protected ObservationImpl(ObservationBuilder builder) {
            this.observedValue = Optional.ofNullable(builder.getObservedValue()).map(f -> f.build()).orElse(null);
            this.observationIdentifier = Optional.ofNullable(builder.getObservationIdentifier()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="observedValue", isRequired=true)
        @RuneAttribute(value="observedValue", isRequired=true)
        public Price getObservedValue() {
            return this.observedValue;
        }

        @Override
        @RosettaAttribute(value="observationIdentifier", isRequired=true)
        @RuneAttribute(value="observationIdentifier", isRequired=true)
        public ObservationIdentifier getObservationIdentifier() {
            return this.observationIdentifier;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Observation build() {
            return this;
        }

        @Override
        public ObservationBuilder toBuilder() {
            ObservationBuilder builder = Observation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ObservationBuilder builder) {
            Optional.ofNullable(this.getObservedValue()).ifPresent(builder::setObservedValue);
            Optional.ofNullable(this.getObservationIdentifier()).ifPresent(builder::setObservationIdentifier);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Observation _that = this.getType().cast(o);
            if (!Objects.equals(this.observedValue, _that.getObservedValue())) {
                return false;
            }
            if (!Objects.equals(this.observationIdentifier, _that.getObservationIdentifier())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observedValue != null ? this.observedValue.hashCode() : 0);
            _result = 31 * _result + (this.observationIdentifier != null ? this.observationIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Observation {observedValue=" + this.observedValue + ", observationIdentifier=" + this.observationIdentifier + ", meta=" + this.meta + '}';
        }
    }
}

