/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.observable.asset.CsaTypeEnum;
import cdm.observable.asset.PartyDeterminationEnum;
import cdm.observable.asset.meta.CashCollateralValuationMethodMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CashCollateralValuationMethod", builder=CashCollateralValuationMethodBuilderImpl.class, version="5.28.0")
@RuneDataType(value="CashCollateralValuationMethod", model="cdm", builder=CashCollateralValuationMethodBuilderImpl.class, version="5.28.0")
public interface CashCollateralValuationMethod
extends RosettaModelObject {
    public static final CashCollateralValuationMethodMeta metaData = new CashCollateralValuationMethodMeta();

    public CsaTypeEnum getApplicableCsa();

    public String getCashCollateralCurrency();

    public FieldWithMetaString getCashCollateralInterestRate();

    public FieldWithMetaString getAgreedDiscountRate();

    public List<PartyDeterminationEnum> getProtectedParty();

    public Boolean getPrescribedDocumentationAdjustment();

    public CashCollateralValuationMethod build();

    public CashCollateralValuationMethodBuilder toBuilder();

    public static CashCollateralValuationMethodBuilder builder() {
        return new CashCollateralValuationMethodBuilderImpl();
    }

    default public RosettaMetaData<? extends CashCollateralValuationMethod> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CashCollateralValuationMethod> getType() {
        return CashCollateralValuationMethod.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("applicableCsa"), CsaTypeEnum.class, (Object)this.getApplicableCsa(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cashCollateralCurrency"), String.class, (Object)this.getCashCollateralCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashCollateralInterestRate"), processor, FieldWithMetaString.class, this.getCashCollateralInterestRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreedDiscountRate"), processor, FieldWithMetaString.class, this.getAgreedDiscountRate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("protectedParty"), PartyDeterminationEnum.class, this.getProtectedParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("prescribedDocumentationAdjustment"), Boolean.class, (Object)this.getPrescribedDocumentationAdjustment(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CashCollateralValuationMethodBuilderImpl
    implements CashCollateralValuationMethodBuilder {
        protected CsaTypeEnum applicableCsa;
        protected String cashCollateralCurrency;
        protected FieldWithMetaString.FieldWithMetaStringBuilder cashCollateralInterestRate;
        protected FieldWithMetaString.FieldWithMetaStringBuilder agreedDiscountRate;
        protected List<PartyDeterminationEnum> protectedParty = new ArrayList<PartyDeterminationEnum>();
        protected Boolean prescribedDocumentationAdjustment;

        @Override
        @RosettaAttribute(value="applicableCsa")
        @RuneAttribute(value="applicableCsa")
        public CsaTypeEnum getApplicableCsa() {
            return this.applicableCsa;
        }

        @Override
        @RosettaAttribute(value="cashCollateralCurrency")
        @RuneAttribute(value="cashCollateralCurrency")
        public String getCashCollateralCurrency() {
            return this.cashCollateralCurrency;
        }

        @Override
        @RosettaAttribute(value="cashCollateralInterestRate")
        @RuneAttribute(value="cashCollateralInterestRate")
        public FieldWithMetaString.FieldWithMetaStringBuilder getCashCollateralInterestRate() {
            return this.cashCollateralInterestRate;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateCashCollateralInterestRate() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.cashCollateralInterestRate != null ? this.cashCollateralInterestRate : (this.cashCollateralInterestRate = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="agreedDiscountRate")
        @RuneAttribute(value="agreedDiscountRate")
        public FieldWithMetaString.FieldWithMetaStringBuilder getAgreedDiscountRate() {
            return this.agreedDiscountRate;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateAgreedDiscountRate() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.agreedDiscountRate != null ? this.agreedDiscountRate : (this.agreedDiscountRate = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="protectedParty")
        @RuneAttribute(value="protectedParty")
        public List<PartyDeterminationEnum> getProtectedParty() {
            return this.protectedParty;
        }

        @Override
        @RosettaAttribute(value="prescribedDocumentationAdjustment")
        @RuneAttribute(value="prescribedDocumentationAdjustment")
        public Boolean getPrescribedDocumentationAdjustment() {
            return this.prescribedDocumentationAdjustment;
        }

        @Override
        @RosettaAttribute(value="applicableCsa")
        @RuneAttribute(value="applicableCsa")
        public CashCollateralValuationMethodBuilder setApplicableCsa(CsaTypeEnum _applicableCsa) {
            this.applicableCsa = _applicableCsa == null ? null : _applicableCsa;
            return this;
        }

        @Override
        @RosettaAttribute(value="cashCollateralCurrency")
        @RuneAttribute(value="cashCollateralCurrency")
        public CashCollateralValuationMethodBuilder setCashCollateralCurrency(String _cashCollateralCurrency) {
            this.cashCollateralCurrency = _cashCollateralCurrency == null ? null : _cashCollateralCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="cashCollateralInterestRate")
        @RuneAttribute(value="cashCollateralInterestRate")
        public CashCollateralValuationMethodBuilder setCashCollateralInterestRate(FieldWithMetaString _cashCollateralInterestRate) {
            this.cashCollateralInterestRate = _cashCollateralInterestRate == null ? null : _cashCollateralInterestRate.toBuilder();
            return this;
        }

        @Override
        public CashCollateralValuationMethodBuilder setCashCollateralInterestRateValue(String _cashCollateralInterestRate) {
            this.getOrCreateCashCollateralInterestRate().setValue(_cashCollateralInterestRate);
            return this;
        }

        @Override
        @RosettaAttribute(value="agreedDiscountRate")
        @RuneAttribute(value="agreedDiscountRate")
        public CashCollateralValuationMethodBuilder setAgreedDiscountRate(FieldWithMetaString _agreedDiscountRate) {
            this.agreedDiscountRate = _agreedDiscountRate == null ? null : _agreedDiscountRate.toBuilder();
            return this;
        }

        @Override
        public CashCollateralValuationMethodBuilder setAgreedDiscountRateValue(String _agreedDiscountRate) {
            this.getOrCreateAgreedDiscountRate().setValue(_agreedDiscountRate);
            return this;
        }

        @Override
        @RosettaAttribute(value="protectedParty")
        @RuneAttribute(value="protectedParty")
        public CashCollateralValuationMethodBuilder addProtectedParty(PartyDeterminationEnum _protectedParty) {
            if (_protectedParty != null) {
                this.protectedParty.add(_protectedParty);
            }
            return this;
        }

        @Override
        public CashCollateralValuationMethodBuilder addProtectedParty(PartyDeterminationEnum _protectedParty, int idx) {
            this.getIndex(this.protectedParty, idx, () -> _protectedParty);
            return this;
        }

        @Override
        public CashCollateralValuationMethodBuilder addProtectedParty(List<PartyDeterminationEnum> protectedPartys) {
            if (protectedPartys != null) {
                for (PartyDeterminationEnum toAdd : protectedPartys) {
                    this.protectedParty.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="protectedParty")
        public CashCollateralValuationMethodBuilder setProtectedParty(List<PartyDeterminationEnum> protectedPartys) {
            this.protectedParty = protectedPartys == null ? new ArrayList<PartyDeterminationEnum>() : (List)protectedPartys.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="prescribedDocumentationAdjustment")
        @RuneAttribute(value="prescribedDocumentationAdjustment")
        public CashCollateralValuationMethodBuilder setPrescribedDocumentationAdjustment(Boolean _prescribedDocumentationAdjustment) {
            this.prescribedDocumentationAdjustment = _prescribedDocumentationAdjustment == null ? null : _prescribedDocumentationAdjustment;
            return this;
        }

        @Override
        public CashCollateralValuationMethod build() {
            return new CashCollateralValuationMethodImpl(this);
        }

        @Override
        public CashCollateralValuationMethodBuilder toBuilder() {
            return this;
        }

        @Override
        public CashCollateralValuationMethodBuilder prune() {
            if (this.cashCollateralInterestRate != null && !this.cashCollateralInterestRate.prune().hasData()) {
                this.cashCollateralInterestRate = null;
            }
            if (this.agreedDiscountRate != null && !this.agreedDiscountRate.prune().hasData()) {
                this.agreedDiscountRate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getApplicableCsa() != null) {
                return true;
            }
            if (this.getCashCollateralCurrency() != null) {
                return true;
            }
            if (this.getCashCollateralInterestRate() != null) {
                return true;
            }
            if (this.getAgreedDiscountRate() != null) {
                return true;
            }
            if (this.getProtectedParty() != null && !this.getProtectedParty().isEmpty()) {
                return true;
            }
            return this.getPrescribedDocumentationAdjustment() != null;
        }

        public CashCollateralValuationMethodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CashCollateralValuationMethodBuilder o = (CashCollateralValuationMethodBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashCollateralInterestRate(), (RosettaModelObjectBuilder)o.getCashCollateralInterestRate(), this::setCashCollateralInterestRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAgreedDiscountRate(), (RosettaModelObjectBuilder)o.getAgreedDiscountRate(), this::setAgreedDiscountRate);
            merger.mergeBasic((Object)this.getApplicableCsa(), (Object)o.getApplicableCsa(), this::setApplicableCsa, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCashCollateralCurrency(), (Object)o.getCashCollateralCurrency(), this::setCashCollateralCurrency, new AttributeMeta[0]);
            merger.mergeBasic(this.getProtectedParty(), o.getProtectedParty(), this::addProtectedParty);
            merger.mergeBasic((Object)this.getPrescribedDocumentationAdjustment(), (Object)o.getPrescribedDocumentationAdjustment(), this::setPrescribedDocumentationAdjustment, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CashCollateralValuationMethod _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.applicableCsa, (Object)_that.getApplicableCsa())) {
                return false;
            }
            if (!Objects.equals(this.cashCollateralCurrency, _that.getCashCollateralCurrency())) {
                return false;
            }
            if (!Objects.equals(this.cashCollateralInterestRate, _that.getCashCollateralInterestRate())) {
                return false;
            }
            if (!Objects.equals(this.agreedDiscountRate, _that.getAgreedDiscountRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.protectedParty, _that.getProtectedParty())) {
                return false;
            }
            return Objects.equals(this.prescribedDocumentationAdjustment, _that.getPrescribedDocumentationAdjustment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.applicableCsa != null ? ((Object)((Object)this.applicableCsa)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cashCollateralCurrency != null ? this.cashCollateralCurrency.hashCode() : 0);
            _result = 31 * _result + (this.cashCollateralInterestRate != null ? this.cashCollateralInterestRate.hashCode() : 0);
            _result = 31 * _result + (this.agreedDiscountRate != null ? this.agreedDiscountRate.hashCode() : 0);
            _result = 31 * _result + (this.protectedParty != null ? this.protectedParty.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.prescribedDocumentationAdjustment != null ? this.prescribedDocumentationAdjustment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashCollateralValuationMethodBuilder {applicableCsa=" + (Object)((Object)this.applicableCsa) + ", cashCollateralCurrency=" + this.cashCollateralCurrency + ", cashCollateralInterestRate=" + this.cashCollateralInterestRate + ", agreedDiscountRate=" + this.agreedDiscountRate + ", protectedParty=" + this.protectedParty + ", prescribedDocumentationAdjustment=" + this.prescribedDocumentationAdjustment + '}';
        }
    }

    public static interface CashCollateralValuationMethodBuilder
    extends CashCollateralValuationMethod,
    RosettaModelObjectBuilder {
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateCashCollateralInterestRate();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getCashCollateralInterestRate();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateAgreedDiscountRate();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getAgreedDiscountRate();

        public CashCollateralValuationMethodBuilder setApplicableCsa(CsaTypeEnum var1);

        public CashCollateralValuationMethodBuilder setCashCollateralCurrency(String var1);

        public CashCollateralValuationMethodBuilder setCashCollateralInterestRate(FieldWithMetaString var1);

        public CashCollateralValuationMethodBuilder setCashCollateralInterestRateValue(String var1);

        public CashCollateralValuationMethodBuilder setAgreedDiscountRate(FieldWithMetaString var1);

        public CashCollateralValuationMethodBuilder setAgreedDiscountRateValue(String var1);

        public CashCollateralValuationMethodBuilder addProtectedParty(PartyDeterminationEnum var1);

        public CashCollateralValuationMethodBuilder addProtectedParty(PartyDeterminationEnum var1, int var2);

        public CashCollateralValuationMethodBuilder addProtectedParty(List<PartyDeterminationEnum> var1);

        public CashCollateralValuationMethodBuilder setProtectedParty(List<PartyDeterminationEnum> var1);

        public CashCollateralValuationMethodBuilder setPrescribedDocumentationAdjustment(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("applicableCsa"), CsaTypeEnum.class, (Object)this.getApplicableCsa(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cashCollateralCurrency"), String.class, (Object)this.getCashCollateralCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashCollateralInterestRate"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getCashCollateralInterestRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreedDiscountRate"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getAgreedDiscountRate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("protectedParty"), PartyDeterminationEnum.class, this.getProtectedParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("prescribedDocumentationAdjustment"), Boolean.class, (Object)this.getPrescribedDocumentationAdjustment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CashCollateralValuationMethodBuilder prune();
    }

    public static class CashCollateralValuationMethodImpl
    implements CashCollateralValuationMethod {
        private final CsaTypeEnum applicableCsa;
        private final String cashCollateralCurrency;
        private final FieldWithMetaString cashCollateralInterestRate;
        private final FieldWithMetaString agreedDiscountRate;
        private final List<PartyDeterminationEnum> protectedParty;
        private final Boolean prescribedDocumentationAdjustment;

        protected CashCollateralValuationMethodImpl(CashCollateralValuationMethodBuilder builder) {
            this.applicableCsa = builder.getApplicableCsa();
            this.cashCollateralCurrency = builder.getCashCollateralCurrency();
            this.cashCollateralInterestRate = Optional.ofNullable(builder.getCashCollateralInterestRate()).map(f -> f.build()).orElse(null);
            this.agreedDiscountRate = Optional.ofNullable(builder.getAgreedDiscountRate()).map(f -> f.build()).orElse(null);
            this.protectedParty = Optional.ofNullable(builder.getProtectedParty()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.prescribedDocumentationAdjustment = builder.getPrescribedDocumentationAdjustment();
        }

        @Override
        @RosettaAttribute(value="applicableCsa")
        @RuneAttribute(value="applicableCsa")
        public CsaTypeEnum getApplicableCsa() {
            return this.applicableCsa;
        }

        @Override
        @RosettaAttribute(value="cashCollateralCurrency")
        @RuneAttribute(value="cashCollateralCurrency")
        public String getCashCollateralCurrency() {
            return this.cashCollateralCurrency;
        }

        @Override
        @RosettaAttribute(value="cashCollateralInterestRate")
        @RuneAttribute(value="cashCollateralInterestRate")
        public FieldWithMetaString getCashCollateralInterestRate() {
            return this.cashCollateralInterestRate;
        }

        @Override
        @RosettaAttribute(value="agreedDiscountRate")
        @RuneAttribute(value="agreedDiscountRate")
        public FieldWithMetaString getAgreedDiscountRate() {
            return this.agreedDiscountRate;
        }

        @Override
        @RosettaAttribute(value="protectedParty")
        @RuneAttribute(value="protectedParty")
        public List<PartyDeterminationEnum> getProtectedParty() {
            return this.protectedParty;
        }

        @Override
        @RosettaAttribute(value="prescribedDocumentationAdjustment")
        @RuneAttribute(value="prescribedDocumentationAdjustment")
        public Boolean getPrescribedDocumentationAdjustment() {
            return this.prescribedDocumentationAdjustment;
        }

        @Override
        public CashCollateralValuationMethod build() {
            return this;
        }

        @Override
        public CashCollateralValuationMethodBuilder toBuilder() {
            CashCollateralValuationMethodBuilder builder = CashCollateralValuationMethod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CashCollateralValuationMethodBuilder builder) {
            Optional.ofNullable(this.getApplicableCsa()).ifPresent(builder::setApplicableCsa);
            Optional.ofNullable(this.getCashCollateralCurrency()).ifPresent(builder::setCashCollateralCurrency);
            Optional.ofNullable(this.getCashCollateralInterestRate()).ifPresent(builder::setCashCollateralInterestRate);
            Optional.ofNullable(this.getAgreedDiscountRate()).ifPresent(builder::setAgreedDiscountRate);
            Optional.ofNullable(this.getProtectedParty()).ifPresent(builder::setProtectedParty);
            Optional.ofNullable(this.getPrescribedDocumentationAdjustment()).ifPresent(builder::setPrescribedDocumentationAdjustment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CashCollateralValuationMethod _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.applicableCsa, (Object)_that.getApplicableCsa())) {
                return false;
            }
            if (!Objects.equals(this.cashCollateralCurrency, _that.getCashCollateralCurrency())) {
                return false;
            }
            if (!Objects.equals(this.cashCollateralInterestRate, _that.getCashCollateralInterestRate())) {
                return false;
            }
            if (!Objects.equals(this.agreedDiscountRate, _that.getAgreedDiscountRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.protectedParty, _that.getProtectedParty())) {
                return false;
            }
            return Objects.equals(this.prescribedDocumentationAdjustment, _that.getPrescribedDocumentationAdjustment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.applicableCsa != null ? ((Object)((Object)this.applicableCsa)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cashCollateralCurrency != null ? this.cashCollateralCurrency.hashCode() : 0);
            _result = 31 * _result + (this.cashCollateralInterestRate != null ? this.cashCollateralInterestRate.hashCode() : 0);
            _result = 31 * _result + (this.agreedDiscountRate != null ? this.agreedDiscountRate.hashCode() : 0);
            _result = 31 * _result + (this.protectedParty != null ? this.protectedParty.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.prescribedDocumentationAdjustment != null ? this.prescribedDocumentationAdjustment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashCollateralValuationMethod {applicableCsa=" + (Object)((Object)this.applicableCsa) + ", cashCollateralCurrency=" + this.cashCollateralCurrency + ", cashCollateralInterestRate=" + this.cashCollateralInterestRate + ", agreedDiscountRate=" + this.agreedDiscountRate + ", protectedParty=" + this.protectedParty + ", prescribedDocumentationAdjustment=" + this.prescribedDocumentationAdjustment + '}';
        }
    }
}

